/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.scenegraph;

import com.ardor3d.annotation.SavableFactory;
import com.ardor3d.bounding.BoundingVolume;
import com.ardor3d.math.Transform;
import com.ardor3d.math.ValidatingTransform;
import com.ardor3d.math.Vector3;
import com.ardor3d.math.type.ReadOnlyMatrix3;
import com.ardor3d.math.type.ReadOnlyQuaternion;
import com.ardor3d.math.type.ReadOnlyTransform;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.renderer.Camera;
import com.ardor3d.renderer.ContextManager;
import com.ardor3d.renderer.RenderContext;
import com.ardor3d.renderer.Renderer;
import com.ardor3d.renderer.state.RenderState;
import com.ardor3d.scenegraph.Node;
import com.ardor3d.scenegraph.controller.SpatialController;
import com.ardor3d.scenegraph.event.DirtyEventListener;
import com.ardor3d.scenegraph.event.DirtyType;
import com.ardor3d.scenegraph.hint.CullHint;
import com.ardor3d.scenegraph.hint.Hintable;
import com.ardor3d.scenegraph.hint.SceneHints;
import com.ardor3d.scenegraph.visitor.Visitor;
import com.ardor3d.util.Constants;
import com.ardor3d.util.export.CapsuleUtils;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.export.Savable;
import com.ardor3d.util.scenegraph.RenderDelegate;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Spatial
implements Savable,
Hintable {
    private static final Logger logger = Logger.getLogger(Spatial.class.getName());
    protected String _name;
    protected final Transform _localTransform;
    protected final Transform _worldTransform;
    protected BoundingVolume _worldBound;
    protected Node _parent;
    protected List<SpatialController<?>> _controllers;
    protected EnumMap<RenderState.StateType, RenderState> _renderStateList = new EnumMap(RenderState.StateType.class);
    protected DirtyEventListener _listener;
    protected EnumSet<DirtyType> _dirtyMark = EnumSet.of(DirtyType.Bounding, DirtyType.RenderState, DirtyType.Transform);
    protected Object _userData = null;
    protected Camera.FrustumIntersect _frustumIntersects = Camera.FrustumIntersect.Intersects;
    protected SceneHints _sceneHints;
    protected transient Map<Object, RenderDelegate> _delegateMap = null;
    public transient double _queueDistance = Double.NEGATIVE_INFINITY;
    private static final Object defaultDelegateRef = new Object();
    protected static final EnumSet<DirtyType> ON_DIRTY_TRANSFORM = EnumSet.of(DirtyType.Bounding, DirtyType.Transform);
    protected static final EnumSet<DirtyType> ON_DIRTY_RENDERSTATE = EnumSet.of(DirtyType.RenderState);
    protected static final EnumSet<DirtyType> ON_DIRTY_BOUNDING = EnumSet.of(DirtyType.Bounding);
    protected static final EnumSet<DirtyType> ON_DIRTY_ATTACHED = EnumSet.of(DirtyType.Transform, DirtyType.RenderState, DirtyType.Bounding);

    public Spatial() {
        this._localTransform = Constants.useValidatingTransform ? new ValidatingTransform() : new Transform();
        this._worldTransform = Constants.useValidatingTransform ? new ValidatingTransform() : new Transform();
        this._sceneHints = new SceneHints(this);
    }

    public Spatial(String name) {
        this();
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setRenderDelegate(RenderDelegate delegate, Object glContextRef) {
        if (this._delegateMap == null) {
            if (delegate == null) {
                return;
            }
            this._delegateMap = new WeakHashMap<Object, RenderDelegate>();
        }
        if (delegate != null) {
            if (glContextRef == null) {
                this._delegateMap.put(defaultDelegateRef, delegate);
            } else {
                this._delegateMap.put(glContextRef, delegate);
            }
        } else {
            if (glContextRef == null) {
                this._delegateMap.remove(defaultDelegateRef);
            } else {
                this._delegateMap.remove(glContextRef);
            }
            if (this._delegateMap.isEmpty()) {
                this._delegateMap = null;
            }
        }
    }

    public RenderDelegate getRenderDelegate(Object glContextRef) {
        if (this._delegateMap == null) {
            return null;
        }
        if (glContextRef == null) {
            return this._delegateMap.get(defaultDelegateRef);
        }
        return this._delegateMap.get(glContextRef);
    }

    public Node getParent() {
        return this._parent;
    }

    protected void setParent(Node parent) {
        this._parent = parent;
    }

    public boolean removeFromParent() {
        if (this._parent != null) {
            this._parent.detachChild(this);
            return true;
        }
        return false;
    }

    public boolean hasAncestor(Node ancestor) {
        if (this._parent == null) {
            return false;
        }
        if (this._parent.equals(ancestor)) {
            return true;
        }
        return this._parent.hasAncestor(ancestor);
    }

    @Override
    public Hintable getParentHintable() {
        return this._parent;
    }

    @Override
    public SceneHints getSceneHints() {
        return this._sceneHints;
    }

    public DirtyEventListener getListener() {
        return this._listener;
    }

    public void setListener(DirtyEventListener listener) {
        this._listener = listener;
    }

    public void markDirty(DirtyType dirtyType) {
        this.markDirty(this, dirtyType);
    }

    protected void markDirty(Spatial caller, DirtyType dirtyType) {
        switch (dirtyType) {
            case Transform: {
                this.propagateDirtyDown(ON_DIRTY_TRANSFORM);
                if (this._parent == null) break;
                this._parent.propagateDirtyUp(ON_DIRTY_BOUNDING);
                break;
            }
            case RenderState: {
                this.propagateDirtyDown(ON_DIRTY_RENDERSTATE);
                break;
            }
            case Bounding: {
                this.propagateDirtyUp(ON_DIRTY_BOUNDING);
                break;
            }
            case Attached: {
                this.propagateDirtyDown(ON_DIRTY_ATTACHED);
                if (this._parent == null) break;
                this._parent.propagateDirtyUp(ON_DIRTY_BOUNDING);
                break;
            }
            case Detached: 
            case Destroyed: {
                if (this._parent == null) break;
                this._parent.propagateDirtyUp(ON_DIRTY_BOUNDING);
                break;
            }
        }
        this.propageEventUp(caller, dirtyType, true);
    }

    public boolean isDirty(DirtyType dirtyType) {
        return this._dirtyMark.contains((Object)dirtyType);
    }

    public void clearDirty(DirtyType dirtyType) {
        this.clearDirty(this, dirtyType);
    }

    public void clearDirty(Spatial caller, DirtyType dirtyType) {
        this._dirtyMark.remove((Object)dirtyType);
        this.propageEventUp(caller, dirtyType, false);
    }

    protected void propagateDirtyUp(EnumSet<DirtyType> dirtyTypes) {
        this._dirtyMark.addAll(dirtyTypes);
        if (this._parent != null) {
            this._parent.propagateDirtyUp(dirtyTypes);
        }
    }

    protected void propagateDirtyDown(EnumSet<DirtyType> dirtyTypes) {
        this._dirtyMark.addAll(dirtyTypes);
    }

    protected void propageEventUp(Spatial spatial, DirtyType dirtyType, boolean dirty) {
        boolean consumed = false;
        if (this._listener != null) {
            consumed = dirty ? this._listener.spatialDirty(spatial, dirtyType) : this._listener.spatialClean(spatial, dirtyType);
        }
        if (!consumed && this._parent != null) {
            this._parent.propageEventUp(spatial, dirtyType, dirty);
        }
    }

    public ReadOnlyMatrix3 getRotation() {
        return this._localTransform.getMatrix();
    }

    public ReadOnlyVector3 getScale() {
        return this._localTransform.getScale();
    }

    public ReadOnlyVector3 getTranslation() {
        return this._localTransform.getTranslation();
    }

    public ReadOnlyTransform getTransform() {
        return this._localTransform;
    }

    public void setTransform(ReadOnlyTransform transform) {
        this._localTransform.set(transform);
        this.markDirty(DirtyType.Transform);
    }

    public void setWorldRotation(ReadOnlyMatrix3 rotation) {
        this._worldTransform.setRotation(rotation);
    }

    public void setWorldRotation(ReadOnlyQuaternion rotation) {
        this._worldTransform.setRotation(rotation);
    }

    public void setWorldScale(ReadOnlyVector3 scale) {
        this._worldTransform.setScale(scale);
    }

    public void setWorldScale(double x, double y, double z) {
        this._worldTransform.setScale(x, y, z);
    }

    public void setWorldScale(double scale) {
        this._worldTransform.setScale(scale);
    }

    public void setWorldTranslation(ReadOnlyVector3 translation) {
        this._worldTransform.setTranslation(translation);
    }

    public void setWorldTranslation(double x, double y, double z) {
        this._worldTransform.setTranslation(x, y, z);
    }

    public void setWorldTransform(ReadOnlyTransform transform) {
        this._worldTransform.set(transform);
    }

    public void setRotation(ReadOnlyMatrix3 rotation) {
        this._localTransform.setRotation(rotation);
        this.markDirty(DirtyType.Transform);
    }

    public void setRotation(ReadOnlyQuaternion rotation) {
        this._localTransform.setRotation(rotation);
        this.markDirty(DirtyType.Transform);
    }

    public void setScale(ReadOnlyVector3 scale) {
        this._localTransform.setScale(scale);
        this.markDirty(DirtyType.Transform);
    }

    public void setScale(double scale) {
        this._localTransform.setScale(scale);
        this.markDirty(DirtyType.Transform);
    }

    public void setScale(double x, double y, double z) {
        this._localTransform.setScale(x, y, z);
        this.markDirty(DirtyType.Transform);
    }

    public void setTranslation(ReadOnlyVector3 translation) {
        this._localTransform.setTranslation(translation);
        this.markDirty(DirtyType.Transform);
    }

    public void setTranslation(double x, double y, double z) {
        this._localTransform.setTranslation(x, y, z);
        this.markDirty(DirtyType.Transform);
    }

    public void addTranslation(ReadOnlyVector3 translation) {
        this.addTranslation(translation.getX(), translation.getY(), translation.getZ());
    }

    public void addTranslation(double x, double y, double z) {
        this._localTransform.translate(x, y, z);
        this.markDirty(DirtyType.Transform);
    }

    public ReadOnlyMatrix3 getWorldRotation() {
        return this._worldTransform.getMatrix();
    }

    public ReadOnlyVector3 getWorldScale() {
        return this._worldTransform.getScale();
    }

    public ReadOnlyVector3 getWorldTranslation() {
        return this._worldTransform.getTranslation();
    }

    public ReadOnlyTransform getWorldTransform() {
        return this._worldTransform;
    }

    public BoundingVolume getWorldBound() {
        return this._worldBound;
    }

    public void onDraw(Renderer r) {
        CullHint cm = this._sceneHints.getCullHint();
        if (cm == CullHint.Always) {
            this.setLastFrustumIntersection(Camera.FrustumIntersect.Outside);
            return;
        }
        if (cm == CullHint.Never) {
            this.setLastFrustumIntersection(Camera.FrustumIntersect.Intersects);
            this.draw(r);
            return;
        }
        Camera camera = Camera.getCurrentCamera();
        int state = camera.getPlaneState();
        Camera.FrustumIntersect frustumIntersect = this._frustumIntersects = this._parent != null && this._parent.getWorldBound() != null ? this._parent._frustumIntersects : Camera.FrustumIntersect.Intersects;
        if (cm == CullHint.Dynamic && this._frustumIntersects == Camera.FrustumIntersect.Intersects) {
            this._frustumIntersects = camera.contains(this._worldBound);
        }
        if (this._frustumIntersects != Camera.FrustumIntersect.Outside) {
            this.draw(r);
        }
        camera.setPlaneState(state);
    }

    public abstract void draw(Renderer var1);

    protected RenderDelegate getCurrentRenderDelegate() {
        if (this._delegateMap == null || this._delegateMap.isEmpty()) {
            return null;
        }
        RenderContext context = ContextManager.getCurrentContext();
        RenderDelegate delegate = this.getRenderDelegate(context.getGlContextRep());
        if (delegate == null) {
            delegate = this.getRenderDelegate(null);
        }
        return delegate;
    }

    public void updateGeometricState(double time) {
        this.updateGeometricState(time, true);
    }

    public void updateGeometricState(double time, boolean initiator) {
        this.updateControllers(time);
        if (this._dirtyMark.isEmpty()) {
            this.updateChildren(time);
        } else {
            if (this.isDirty(DirtyType.Transform)) {
                this.updateWorldTransform(false);
            }
            if (this.isDirty(DirtyType.RenderState)) {
                this.updateWorldRenderStates(false);
                this.clearDirty(DirtyType.RenderState);
            }
            this.updateChildren(time);
            if (this.isDirty(DirtyType.Bounding)) {
                this.updateWorldBound(false);
                if (initiator) {
                    this.propagateBoundToRoot();
                }
            }
        }
    }

    protected void updateChildren(double time) {
    }

    public void updateControllers(double time) {
        if (this._controllers != null) {
            int gSize = this._controllers.size();
            for (int i = 0; i < gSize; ++i) {
                try {
                    SpatialController<?> controller = this._controllers.get(i);
                    if (controller == null) continue;
                    controller.update(time, this);
                    continue;
                }
                catch (IndexOutOfBoundsException e) {
                    break;
                }
            }
        }
    }

    public void updateWorldTransform(boolean recurse) {
        if (this._parent != null) {
            this._parent._worldTransform.multiply((ReadOnlyTransform)this._localTransform, this._worldTransform);
        } else {
            this._worldTransform.set((ReadOnlyTransform)this._localTransform);
        }
        this.clearDirty(DirtyType.Transform);
    }

    public Vector3 localToWorld(ReadOnlyVector3 in, Vector3 store) {
        if (store == null) {
            store = new Vector3();
        }
        return this._worldTransform.applyForward(in, store);
    }

    public Vector3 worldToLocal(ReadOnlyVector3 in, Vector3 store) {
        if (store == null) {
            store = new Vector3();
        }
        return this._worldTransform.applyInverse(in, store);
    }

    public void updateWorldRenderStates(boolean recurse) {
        this.updateWorldRenderStates(recurse, null);
    }

    protected void updateWorldRenderStates(boolean recurse, RenderState.StateStack stateStack) {
        if (stateStack == null) {
            RenderState.StateStack stack = RenderState.StateStack.fetchTempInstance();
            this.propagateStatesFromRoot(stack);
            this.applyWorldRenderStates(recurse, stack);
            RenderState.StateStack.releaseTempInstance(stack);
        } else {
            for (RenderState state : this._renderStateList.values()) {
                stateStack.push(state);
            }
            this.applyWorldRenderStates(recurse, stateStack);
            for (RenderState state : this._renderStateList.values()) {
                stateStack.pop(state);
            }
        }
    }

    protected void applyWorldRenderStates(boolean recurse, RenderState.StateStack stack) {
    }

    public void sortLights() {
    }

    public EnumMap<RenderState.StateType, RenderState> getLocalRenderStates() {
        return this._renderStateList;
    }

    public RenderState setRenderState(RenderState rs) {
        if (rs == null) {
            return null;
        }
        RenderState.StateType type = rs.getType();
        RenderState oldState = this._renderStateList.get((Object)type);
        this._renderStateList.put(type, rs);
        this.markDirty(DirtyType.RenderState);
        return oldState;
    }

    public RenderState getLocalRenderState(RenderState.StateType type) {
        return this._renderStateList.get((Object)type);
    }

    public void clearRenderState(RenderState.StateType type) {
        this._renderStateList.remove((Object)type);
        this.markDirty(DirtyType.RenderState);
    }

    public void propagateStatesFromRoot(RenderState.StateStack stack) {
        if (this._parent != null) {
            this._parent.propagateStatesFromRoot(stack);
        }
        for (RenderState state : this._renderStateList.values()) {
            stack.push(state);
        }
    }

    public abstract void updateWorldBound(boolean var1);

    public void propagateBoundToRoot() {
        if (this._parent != null) {
            this._parent.updateWorldBound(false);
            this._parent.propagateBoundToRoot();
        }
    }

    public Object getUserData() {
        return this._userData;
    }

    public void setUserData(Object userData) {
        this._userData = userData;
    }

    public void addController(SpatialController<?> controller) {
        if (this._controllers == null) {
            this._controllers = new ArrayList(1);
        }
        this._controllers.add(controller);
    }

    public boolean removeController(SpatialController<?> controller) {
        if (this._controllers == null) {
            return false;
        }
        return this._controllers.remove(controller);
    }

    public SpatialController<?> removeController(int index) {
        if (this._controllers == null) {
            return null;
        }
        return this._controllers.remove(index);
    }

    public void clearControllers() {
        if (this._controllers != null) {
            this._controllers.clear();
        }
    }

    public SpatialController<?> getController(int i) {
        if (this._controllers == null) {
            this._controllers = new ArrayList(1);
        }
        return this._controllers.get(i);
    }

    public List<SpatialController<?>> getControllers() {
        if (this._controllers == null) {
            this._controllers = new ArrayList(1);
        }
        return this._controllers;
    }

    public int getControllerCount() {
        if (this._controllers == null) {
            return 0;
        }
        return this._controllers.size();
    }

    public Camera.FrustumIntersect getLocalLastFrustumIntersection() {
        return this._frustumIntersects;
    }

    public Camera.FrustumIntersect getLastFrustumIntersection() {
        Camera.FrustumIntersect parentIntersect;
        if (this._parent != null && this._frustumIntersects != Camera.FrustumIntersect.Outside && (parentIntersect = this._parent.getLastFrustumIntersection()) == Camera.FrustumIntersect.Outside) {
            return Camera.FrustumIntersect.Outside;
        }
        return this._frustumIntersects;
    }

    public void setLastFrustumIntersection(Camera.FrustumIntersect frustumIntersects) {
        this._frustumIntersects = frustumIntersects;
    }

    public void acceptVisitor(Visitor visitor, boolean preexecute) {
        visitor.visit(this);
    }

    public String toString() {
        return this._name + " (" + this.getClass().getName() + ')';
    }

    public Spatial makeCopy(boolean shareGeometricData) {
        Spatial spat = this.duplicate();
        spat.setName(this.getName());
        spat.getSceneHints().set(this._sceneHints);
        spat.setTransform((ReadOnlyTransform)this._localTransform);
        for (RenderState.StateType stateType : this._renderStateList.keySet()) {
            RenderState state = this._renderStateList.get((Object)stateType);
            if (state == null) continue;
            spat.setRenderState(state);
        }
        if (this._controllers != null) {
            for (SpatialController spatialController : this._controllers) {
                spat.addController(spatialController);
            }
        }
        return spat;
    }

    private Spatial duplicate() {
        Spatial spat = null;
        Class<?> clazz = this.getClass();
        try {
            SavableFactory ann = clazz.getAnnotation(SavableFactory.class);
            spat = ann == null ? (Spatial)clazz.newInstance() : (Spatial)clazz.getMethod(ann.factoryMethod(), null).invoke(null, (Object[])null);
        }
        catch (InstantiationException e) {
            logger.log(Level.SEVERE, "Could not access final constructor of class " + clazz.getCanonicalName(), e);
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            logger.log(Level.SEVERE, "Could not access final constructor of class " + clazz.getCanonicalName(), e);
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            logger.log(Level.SEVERE, "Could not access final constructor of class " + clazz.getCanonicalName(), e);
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            logger.log(Level.SEVERE, "Could not access final constructor of class " + clazz.getCanonicalName(), e);
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            logger.log(Level.SEVERE, "Could not access final constructor of class " + clazz.getCanonicalName(), e);
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            logger.log(Level.SEVERE, "Could not access final constructor of class " + clazz.getCanonicalName(), e);
            throw new RuntimeException(e);
        }
        return spat;
    }

    public Spatial makeInstanced() {
        Spatial spat = this.duplicate();
        spat.setName(this.getName());
        spat._sceneHints = this._sceneHints;
        spat.setTransform((ReadOnlyTransform)this._localTransform);
        spat._renderStateList = this._renderStateList;
        if (this._controllers != null) {
            for (SpatialController<?> sc : this._controllers) {
                spat.addController(sc);
            }
        }
        return spat;
    }

    public Class<? extends Spatial> getClassTag() {
        return this.getClass();
    }

    public void read(InputCapsule capsule) throws IOException {
        List list;
        this._name = capsule.readString("name", null);
        RenderState[] states = (RenderState[])CapsuleUtils.asArray((Savable[])capsule.readSavableArray("renderStateList", null), RenderState.class);
        this._renderStateList.clear();
        if (states != null) {
            for (RenderState state : states) {
                this._renderStateList.put(state.getType(), state);
            }
        }
        this._localTransform.set((ReadOnlyTransform)((Transform)capsule.readSavable("localTransform", (Savable)new Transform(Transform.IDENTITY))));
        this._worldTransform.set((ReadOnlyTransform)((Transform)capsule.readSavable("worldTransform", (Savable)new Transform(Transform.IDENTITY))));
        Savable userData = capsule.readSavable("userData", null);
        if (userData != null) {
            this._userData = userData;
        }
        if ((list = capsule.readSavableList("controllers", null)) != null) {
            for (Savable s : list) {
                if (!(s instanceof SpatialController)) continue;
                this.addController((SpatialController)s);
            }
        }
    }

    public void write(OutputCapsule capsule) throws IOException {
        capsule.write(this._name, "name", null);
        capsule.write((Savable[])this._renderStateList.values().toArray(new RenderState[0]), "renderStateList", null);
        capsule.write((Savable)this._localTransform, "localTransform", (Savable)new Transform(Transform.IDENTITY));
        capsule.write((Savable)this._worldTransform, "worldTransform", (Savable)new Transform(Transform.IDENTITY));
        if (this._userData instanceof Savable) {
            capsule.write((Savable)this._userData, "userData", null);
        }
        if (this._controllers != null) {
            ArrayList<Savable> list = new ArrayList<Savable>();
            for (SpatialController<?> sc : this._controllers) {
                if (!(sc instanceof Savable)) continue;
                list.add((Savable)sc);
            }
            capsule.writeSavableList(list, "controllers", null);
        }
    }
}

