/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.scenegraph.controller;

import com.ardor3d.scenegraph.Spatial;
import com.ardor3d.scenegraph.controller.SpatialController;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.export.Savable;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;

public abstract class ComplexSpatialController<T extends Spatial>
implements SpatialController<T>,
Serializable,
Savable {
    private static final long serialVersionUID = 1L;
    private RepeatType _repeatType = RepeatType.CLAMP;
    private double _minTime;
    private double _maxTime;
    private double _speed = 1.0;
    private boolean _active = true;

    public double getSpeed() {
        return this._speed;
    }

    public void setSpeed(double speed) {
        this._speed = speed;
    }

    public double getMaxTime() {
        return this._maxTime;
    }

    public void setMaxTime(double maxTime) {
        this._maxTime = maxTime;
    }

    public double getMinTime() {
        return this._minTime;
    }

    public void setMinTime(double minTime) {
        this._minTime = minTime;
    }

    public RepeatType getRepeatType() {
        return this._repeatType;
    }

    public void setRepeatType(RepeatType repeatType) {
        if (null == repeatType) {
            throw new IllegalArgumentException("repeatType can not be null!");
        }
        this._repeatType = repeatType;
    }

    public void setActive(boolean active) {
        this._active = active;
    }

    public boolean isActive() {
        return this._active;
    }

    public boolean isRepeatTypeClamp() {
        return RepeatType.CLAMP.equals((Object)this.getRepeatType());
    }

    public boolean isRepeatTypeWrap() {
        return RepeatType.WRAP.equals((Object)this.getRepeatType());
    }

    public boolean isRepeatTypeCycle() {
        return RepeatType.CYCLE.equals((Object)this.getRepeatType());
    }

    @Override
    public abstract void update(double var1, T var3);

    public void write(OutputCapsule capsule) throws IOException {
        capsule.write((Enum)this._repeatType, "repeatType", (Enum)RepeatType.CLAMP);
        capsule.write(this._minTime, "minTime", 0.0);
        capsule.write(this._maxTime, "maxTime", 0.0);
        capsule.write(this._speed, "speed", 1.0);
        capsule.write(this._active, "active", true);
    }

    public void read(InputCapsule capsule) throws IOException {
        this._repeatType = (RepeatType)capsule.readEnum("repeatType", RepeatType.class, (Enum)RepeatType.CLAMP);
        this._minTime = capsule.readDouble("minTime", 0.0);
        this._maxTime = capsule.readDouble("maxTime", 0.0);
        this._speed = capsule.readDouble("speed", 1.0);
        this._active = capsule.readBoolean("active", true);
    }

    public Class<? extends ComplexSpatialController> getClassTag() {
        return this.getClass();
    }

    public void getControllerValues(HashMap<String, Object> store) {
    }

    public void setControllerValues(HashMap<String, Object> values) {
    }

    public static enum RepeatType {
        CLAMP,
        WRAP,
        CYCLE;

    }
}

