/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.scenegraph.controller.interpolation;

import com.ardor3d.math.Vector3;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.scenegraph.controller.ComplexSpatialController;
import com.ardor3d.scenegraph.controller.interpolation.Vector3InterpolationController;
import com.ardor3d.spline.ArcLengthTable;
import com.ardor3d.spline.Curve;
import com.ardor3d.spline.Spline;
import java.util.logging.Logger;

public class CurveInterpolationController
extends Vector3InterpolationController {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(CurveInterpolationController.class.getName());
    private Curve _curve;
    private ArcLengthTable _arcLengths;
    private ArcLengthTable _arcLengthsReverse;
    private double _distance = 0.0;

    @Override
    protected double incrementDelta(double by) {
        double delta;
        if (this.isConstantSpeed()) {
            this._distance += by;
            if (this.isCycleForward()) {
                assert (null != this._arcLengths) : "You need to call generateArcLengths(x, false) to create the required arc length table!";
                delta = this._arcLengths.getDelta(this.getIndex(), this._distance);
            } else {
                assert (null != this._arcLengthsReverse) : "You need to call generateArcLengths(x, true) to create the required reverse arc length table!";
                delta = this._arcLengthsReverse.getDelta(this.getIndex(), this._distance);
            }
            this.setDelta(delta);
        } else {
            delta = super.incrementDelta(by);
        }
        return delta;
    }

    @Override
    protected int decrementIndex() {
        assert (null != this._arcLengthsReverse) : "You need to call generateArcLengths() to create the required arc length tables!";
        this._distance -= this._arcLengthsReverse.getLength(this.getIndex());
        return super.decrementIndex();
    }

    @Override
    protected int incrementIndex() {
        assert (null != this._arcLengths) : "You need to call generateArcLengths() to create the required arc length tables!";
        this._distance -= this._arcLengths.getLength(this.getIndex());
        return super.incrementIndex();
    }

    @Override
    protected Vector3 interpolateVectors(ReadOnlyVector3 from, ReadOnlyVector3 to, double delta, Vector3 target) {
        assert (null != from) : "parameter 'from' can not be null";
        assert (null != to) : "parameter 'to' can not be null";
        ReadOnlyVector3 p0 = this.getControlPointStart();
        ReadOnlyVector3 p3 = this.getCotnrolPointEnd();
        Spline spline = this.getCurve().getSpline();
        return spline.interpolate(p0, from, to, p3, delta, target);
    }

    protected ReadOnlyVector3 getControlPointStart() {
        ReadOnlyVector3 control = null;
        int fromIndex = this.getIndex();
        switch (this.getRepeatType()) {
            case CLAMP: {
                control = (ReadOnlyVector3)this.getControls().get(fromIndex - 1);
                break;
            }
            case CYCLE: {
                if (this.isCycleForward()) {
                    control = (ReadOnlyVector3)this.getControls().get(fromIndex - 1);
                    break;
                }
                control = (ReadOnlyVector3)this.getControls().get(fromIndex + 1);
                break;
            }
            case WRAP: {
                control = (ReadOnlyVector3)this.getControls().get(fromIndex - 1);
            }
        }
        return control;
    }

    protected ReadOnlyVector3 getCotnrolPointEnd() {
        ReadOnlyVector3 control = null;
        int toIndex = this.getIndex();
        switch (this.getRepeatType()) {
            case CLAMP: {
                control = (ReadOnlyVector3)this.getControls().get(toIndex + 2);
                break;
            }
            case CYCLE: {
                if (this.isCycleForward()) {
                    control = (ReadOnlyVector3)this.getControls().get(toIndex + 2);
                    break;
                }
                control = (ReadOnlyVector3)this.getControls().get(toIndex - 2);
                break;
            }
            case WRAP: {
                control = (ReadOnlyVector3)this.getControls().get(toIndex + 2);
            }
        }
        return control;
    }

    public void setCurve(Curve curve) {
        if (null == curve) {
            throw new IllegalArgumentException("curve can not be null!");
        }
        this._curve = curve;
        this.setControls(this._curve.getControlPoints());
        if (this.isConstantSpeed()) {
            LOGGER.warning("Constant speed is set to true, you will need to call generateArcLengths() to avoid errors during update.");
        }
    }

    public Curve getCurve() {
        assert (null != this._curve) : "curve was null, it must be set before use!";
        return this._curve;
    }

    @Override
    public void setConstantSpeed(boolean constantSpeed) {
        super.setConstantSpeed(constantSpeed);
        if (this.isConstantSpeed() && null == this._arcLengths) {
            LOGGER.warning("Constant speed was set to true, you will need to call generateArcLengths() to avoid errors during update.");
        }
    }

    public void generateArcLengths(int step) {
        this.generateArcLengths(step, ComplexSpatialController.RepeatType.CYCLE.equals((Object)this.getRepeatType()));
    }

    public void generateArcLengths(int step, boolean reverse) {
        this._arcLengths = new ArcLengthTable(this.getCurve());
        this._arcLengths.generate(step, false);
        if (reverse) {
            this._arcLengthsReverse = new ArcLengthTable(this.getCurve());
            this._arcLengthsReverse.generate(step, true);
        }
    }

    @Override
    protected int getMaximumIndex() {
        return super.getMaximumIndex() - 1;
    }

    @Override
    protected int getMinimumIndex() {
        return super.getMinimumIndex() + 1;
    }

    @Override
    public void reset() {
        super.reset();
        this._distance = 0.0;
    }
}

