/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.scenegraph.controller.interpolation;

import com.ardor3d.math.MathUtils;
import com.ardor3d.math.Matrix3;
import com.ardor3d.math.Vector3;
import com.ardor3d.math.type.ReadOnlyMatrix3;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.scenegraph.Spatial;
import com.ardor3d.scenegraph.controller.SpatialController;
import com.ardor3d.scenegraph.controller.interpolation.CurveInterpolationController;
import java.io.Serializable;

public class CurveLookAtController
implements SpatialController<Spatial>,
Serializable {
    private static final long serialVersionUID = 1L;
    private ReadOnlyVector3 _worldUp;
    private final CurveInterpolationController _curveController;
    private final Vector3 _previous;
    private boolean _localRotation = true;

    public CurveLookAtController(CurveInterpolationController curveController) {
        this(curveController, Vector3.UNIT_Y);
    }

    public CurveLookAtController(CurveInterpolationController curveController, ReadOnlyVector3 worldUp) {
        if (null == curveController) {
            throw new IllegalArgumentException("curveController can not be null!");
        }
        this._curveController = curveController;
        this._previous = new Vector3((ReadOnlyVector3)this._curveController.getControlFrom());
        this.setWorldUp(worldUp);
    }

    @Override
    public void update(double time, Spatial caller) {
        if (null == caller) {
            throw new IllegalArgumentException("caller can not be null!");
        }
        Vector3 interpolated = Vector3.fetchTempInstance();
        Matrix3 rotation = Matrix3.fetchTempInstance();
        this._curveController.interpolateVectors((ReadOnlyVector3)this._curveController.getControlFrom(), (ReadOnlyVector3)this._curveController.getControlTo(), this._curveController.getDelta(), interpolated);
        MathUtils.matrixLookAt((ReadOnlyVector3)this._previous, (ReadOnlyVector3)interpolated, (ReadOnlyVector3)this._worldUp, (Matrix3)rotation);
        if (this.isLocalRotation()) {
            caller.setRotation((ReadOnlyMatrix3)rotation);
        } else {
            caller.setWorldRotation((ReadOnlyMatrix3)rotation);
        }
        this._previous.set((ReadOnlyVector3)interpolated);
        Matrix3.releaseTempInstance((Matrix3)rotation);
        Vector3.releaseTempInstance((Vector3)interpolated);
    }

    public void setWorldUp(ReadOnlyVector3 worldUp) {
        if (null == worldUp) {
            throw new IllegalArgumentException("worldUp can not be null!");
        }
        this._worldUp = worldUp;
    }

    public void setLocalRotation(boolean localRotation) {
        this._localRotation = localRotation;
    }

    public boolean isLocalRotation() {
        return this._localRotation;
    }
}

