/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.scenegraph.controller.interpolation;

import com.ardor3d.math.ColorRGBA;
import com.ardor3d.math.type.ReadOnlyColorRGBA;
import com.ardor3d.scenegraph.Mesh;
import com.ardor3d.scenegraph.controller.interpolation.InterpolationController;

public class DefaultColorInterpolationController
extends InterpolationController<ReadOnlyColorRGBA, Mesh> {
    private static final long serialVersionUID = 1L;

    @Override
    protected void interpolate(ReadOnlyColorRGBA from, ReadOnlyColorRGBA to, double delta, Mesh caller) {
        assert (null != from) : "parameter 'from' can not be null";
        assert (null != to) : "parameter 'to' can not be null";
        assert (null != caller) : "parameter 'caller' can not be null";
        ColorRGBA color = ColorRGBA.fetchTempInstance().set(caller.getDefaultColor());
        color.lerpLocal(from, to, (float)delta);
        caller.setDefaultColor((ReadOnlyColorRGBA)color);
        ColorRGBA.releaseTempInstance((ColorRGBA)color);
    }
}

