/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.scenegraph.controller.interpolation;

import com.ardor3d.scenegraph.Spatial;
import com.ardor3d.scenegraph.controller.ComplexSpatialController;
import java.util.Arrays;
import java.util.List;

public abstract class InterpolationController<C, T extends Spatial>
extends ComplexSpatialController<T> {
    private static final long serialVersionUID = 1L;
    public static final double DELTA_MIN = 0.0;
    public static final double DELTA_MAX = 1.0;
    private List<C> _controls = null;
    private int _index = this.getMinimumIndex();
    private double _delta = 0.0;
    private boolean _cycleForward = true;

    protected abstract void interpolate(C var1, C var2, double var3, T var5);

    @Override
    public void update(double time, T caller) {
        if (this.shouldUpdate(time, caller)) {
            this.updateDeltaAndIndex(time);
            assert (this.getDelta() >= 0.0) : "delta is less than 0.0, updateDeltaAndIndex() has probably been overriden incorrectly";
            assert (this.getDelta() <= 1.0) : "delta is greater than 1.0, updateDeltaAndIndex() has probably been overriden incorrectly";
            this.clampIndex();
            assert (this.getIndex() < this.getControls().size()) : "_index was greater than the number of controls, clampIndex() has probably been overriden incorrectly";
            assert (this.getIndex() >= 0) : "_index was negative, clampIndex() has probably been overriden incorrectly";
            this.interpolate(this.getControlFrom(), this.getControlTo(), this.getDelta(), caller);
        }
    }

    private boolean shouldUpdate(double time, T caller) {
        return this.isActive() && null != caller && time > 0.0 && this.getSpeed() > 0.0 && !this.isClamped();
    }

    protected int getMinimumIndex() {
        return 0;
    }

    protected int getMaximumIndex() {
        return this.getControls().size() - 1;
    }

    public void setControls(List<C> controls) {
        if (null == controls) {
            throw new IllegalArgumentException("controls can not be null!");
        }
        if (controls.isEmpty()) {
            throw new IllegalArgumentException("controls can not be empty!");
        }
        this._controls = controls;
    }

    public void setControls(C ... controlArray) {
        if (null == controlArray) {
            throw new IllegalArgumentException("controlArray can not be null!");
        }
        this.setControls(Arrays.asList(controlArray));
    }

    public List<C> getControls() {
        assert (null != this._controls) : "_controls was null, it must be set before use!";
        assert (!this._controls.isEmpty()) : "_controls was empty, it must contain at least 1 element for this class to work!";
        return this._controls;
    }

    protected void updateDeltaAndIndex(double time) {
        this.incrementDelta(this.getSpeed() * time);
        while (this.getDelta() >= 1.0) {
            this.decrementDelta(1.0);
            if (this.isCycleForward()) {
                this.incrementIndex();
                continue;
            }
            this.decrementIndex();
        }
    }

    protected void clampIndex() {
        switch (this.getRepeatType()) {
            case CLAMP: {
                if (this.getIndex() < this.getMaximumIndex()) break;
                this.setIndex(this.getMaximumIndex());
                this.setDelta(1.0);
                break;
            }
            case CYCLE: {
                if (this.isCycleForward()) {
                    if (this.getIndex() < this.getMaximumIndex()) break;
                    this.setIndex(this.getMaximumIndex());
                    this.setCycleForward(false);
                    break;
                }
                if (this.getIndex() > this.getMinimumIndex()) break;
                this.setIndex(this.getMinimumIndex());
                this.setCycleForward(true);
                break;
            }
            case WRAP: {
                if (this.getIndex() < this.getMaximumIndex()) break;
                this.setIndex(this.getMinimumIndex());
            }
        }
    }

    protected C getControlFrom() {
        C from = null;
        switch (this.getRepeatType()) {
            case CLAMP: {
                if (this.getIndex() > this.getMaximumIndex()) {
                    from = this.getControls().get(this.getMaximumIndex());
                    break;
                }
                from = this.getControls().get(this.getIndex());
                break;
            }
            case CYCLE: {
                from = this.getControls().get(this.getIndex());
                break;
            }
            case WRAP: {
                from = this.getControls().get(this.getIndex());
            }
        }
        return from;
    }

    protected C getControlTo() {
        C to = null;
        switch (this.getRepeatType()) {
            case CLAMP: {
                if (this.getIndex() >= this.getMaximumIndex()) {
                    to = this.getControls().get(this.getMaximumIndex());
                    break;
                }
                to = this.getControls().get(this.getIndex() + 1);
                break;
            }
            case CYCLE: {
                if (this.isCycleForward()) {
                    to = this.getControls().get(this.getIndex() + 1);
                    break;
                }
                to = this.getControls().get(this.getIndex() - 1);
                break;
            }
            case WRAP: {
                to = this.getControls().get(this.getIndex() + 1);
            }
        }
        return to;
    }

    protected int incrementIndex() {
        return ++this._index;
    }

    protected int decrementIndex() {
        return --this._index;
    }

    protected void setIndex(int index) {
        this._index = index;
    }

    protected int getIndex() {
        return this._index;
    }

    protected double incrementDelta(double by) {
        this._delta += by;
        return this._delta;
    }

    protected double decrementDelta(double by) {
        this._delta -= by;
        return this._delta;
    }

    protected void setDelta(double delta) {
        this._delta = delta;
    }

    protected double getDelta() {
        return this._delta;
    }

    protected void setCycleForward(boolean cycleForward) {
        this._cycleForward = cycleForward;
    }

    protected boolean isCycleForward() {
        return this._cycleForward;
    }

    @Override
    public void setRepeatType(ComplexSpatialController.RepeatType repeatType) {
        if (this.getRepeatType() != repeatType) {
            this.reset();
        }
        super.setRepeatType(repeatType);
    }

    public void reset() {
        this.setCycleForward(true);
        this.setDelta(0.0);
        this.setIndex(this.getMinimumIndex());
    }

    public boolean isClamped() {
        return this.isRepeatTypeClamp() && this.getIndex() == this.getMaximumIndex();
    }
}

