/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.scenegraph.controller.interpolation;

import com.ardor3d.math.Quaternion;
import com.ardor3d.math.type.ReadOnlyQuaternion;
import com.ardor3d.scenegraph.Spatial;
import com.ardor3d.scenegraph.controller.interpolation.InterpolationController;

public class QuaternionInterpolationController
extends InterpolationController<ReadOnlyQuaternion, Spatial> {
    private static final long serialVersionUID = 1L;
    private boolean _localRotation = true;

    @Override
    protected void interpolate(ReadOnlyQuaternion from, ReadOnlyQuaternion to, double delta, Spatial caller) {
        assert (null != from) : "parameter 'from' can not be null";
        assert (null != to) : "parameter 'to' can not be null";
        assert (null != caller) : "parameter 'caller' can not be null";
        Quaternion tempQuat = Quaternion.fetchTempInstance();
        tempQuat.slerpLocal(from, to, delta);
        if (this.isLocalRotation()) {
            caller.setRotation((ReadOnlyQuaternion)tempQuat);
        } else {
            caller.setWorldRotation((ReadOnlyQuaternion)tempQuat);
        }
        Quaternion.releaseTempInstance((Quaternion)tempQuat);
    }

    public void setLocalRotation(boolean localRotation) {
        this._localRotation = localRotation;
    }

    public boolean isLocalRotation() {
        return this._localRotation;
    }
}

