/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.scenegraph.controller.interpolation;

import com.ardor3d.math.Vector3;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.scenegraph.Spatial;
import com.ardor3d.scenegraph.controller.interpolation.InterpolationController;

public abstract class Vector3InterpolationController
extends InterpolationController<ReadOnlyVector3, Spatial> {
    private static final long serialVersionUID = 1L;
    private boolean _constantSpeed;
    private UpdateField _updateField = UpdateField.LOCAL_TRANSLATION;

    protected abstract Vector3 interpolateVectors(ReadOnlyVector3 var1, ReadOnlyVector3 var2, double var3, Vector3 var5);

    @Override
    protected void interpolate(ReadOnlyVector3 from, ReadOnlyVector3 to, double delta, Spatial caller) {
        assert (null != from) : "parameter 'from' can not be null";
        assert (null != to) : "parameter 'to' can not be null";
        assert (null != caller) : "parameter 'caller' can not be null";
        Vector3 target = Vector3.fetchTempInstance();
        Vector3 interpolated = this.interpolateVectors(from, to, delta, target);
        switch (this.getUpdateField()) {
            case LOCAL_SCALE: {
                caller.setScale((ReadOnlyVector3)interpolated);
                break;
            }
            case LOCAL_TRANSLATION: {
                caller.setTranslation((ReadOnlyVector3)interpolated);
                break;
            }
            case WORLD_SCALE: {
                caller.setWorldScale((ReadOnlyVector3)interpolated);
                break;
            }
            case WORLD_TRANSLATION: {
                caller.setWorldTranslation((ReadOnlyVector3)interpolated);
                break;
            }
            default: {
                caller.setTranslation((ReadOnlyVector3)interpolated);
            }
        }
        Vector3.releaseTempInstance((Vector3)target);
    }

    public void setConstantSpeed(boolean constantSpeed) {
        this._constantSpeed = constantSpeed;
    }

    public boolean isConstantSpeed() {
        return this._constantSpeed;
    }

    public void setUpdateField(UpdateField updateField) {
        this._updateField = updateField;
    }

    public UpdateField getUpdateField() {
        return this._updateField;
    }

    public static enum UpdateField {
        LOCAL_TRANSLATION,
        WORLD_TRANSLATION,
        LOCAL_SCALE,
        WORLD_SCALE;

    }
}

