/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.scenegraph.event;

import com.ardor3d.scenegraph.Spatial;
import com.ardor3d.scenegraph.event.DirtyEventListener;
import com.ardor3d.scenegraph.event.DirtyType;
import java.util.ArrayList;
import java.util.List;

public class SceneGraphManager
implements DirtyEventListener {
    private static SceneGraphManager sceneGraphManagerInstance;
    private final List<DirtyEventListener> _listeners = new ArrayList<DirtyEventListener>();

    private SceneGraphManager() {
    }

    public static SceneGraphManager getSceneGraphManager() {
        if (sceneGraphManagerInstance == null) {
            sceneGraphManagerInstance = new SceneGraphManager();
        }
        return sceneGraphManagerInstance;
    }

    public void listenOnSpatial(Spatial spatial) {
        spatial.setListener(this);
    }

    public void addDirtyEventListener(DirtyEventListener listener) {
        this._listeners.add(listener);
    }

    public void removeDirtyEventListener(DirtyEventListener listener) {
        this._listeners.remove(listener);
    }

    @Override
    public boolean spatialDirty(Spatial spatial, DirtyType dirtyType) {
        for (DirtyEventListener listener : this._listeners) {
            listener.spatialDirty(spatial, dirtyType);
        }
        return false;
    }

    @Override
    public boolean spatialClean(Spatial spatial, DirtyType dirtyType) {
        for (DirtyEventListener listener : this._listeners) {
            listener.spatialClean(spatial, dirtyType);
        }
        return false;
    }
}

