/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.scenegraph.extension;

import com.ardor3d.math.Matrix3;
import com.ardor3d.math.Vector3;
import com.ardor3d.math.type.ReadOnlyMatrix3;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.renderer.Camera;
import com.ardor3d.renderer.Renderer;
import com.ardor3d.scenegraph.Node;
import com.ardor3d.scenegraph.Spatial;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.export.Savable;
import java.io.IOException;

public class BillboardNode
extends Node {
    private double _lastTime;
    private final Matrix3 _orient = new Matrix3(Matrix3.IDENTITY);
    private final Vector3 _look = new Vector3(Vector3.ZERO);
    private final Vector3 _left = new Vector3(Vector3.ZERO);
    private BillboardAlignment _alignment;

    public BillboardNode() {
    }

    public BillboardNode(String name) {
        super(name);
        this._alignment = BillboardAlignment.ScreenAligned;
    }

    @Override
    public void updateWorldTransform(boolean recurse) {
        this._lastTime = 0.0;
        super.updateWorldTransform(recurse);
    }

    @Override
    public void draw(Renderer r) {
        this.rotateBillboard();
        super.draw(r);
    }

    public void rotateBillboard() {
        this.updateWorldTransform(false);
        switch (this._alignment) {
            case ScreenAligned: {
                this.rotateScreenAligned();
                break;
            }
            case CameraAligned: {
                this.rotateCameraAligned();
                break;
            }
            case AxialY: {
                this.rotateAxial(new Vector3(Vector3.UNIT_Y));
                break;
            }
            case AxialZ: {
                this.rotateAxial(new Vector3(Vector3.UNIT_Z));
            }
        }
        if (this._children == null) {
            return;
        }
        this.propagateDirtyDown(ON_DIRTY_TRANSFORM);
        int cSize = this.getNumberOfChildren();
        for (int i = 0; i < cSize; ++i) {
            Spatial child = this.getChild(i);
            if (child == null) continue;
            child.updateGeometricState(this._lastTime, false);
        }
    }

    private void rotateCameraAligned() {
        Camera camera = Camera.getCurrentCamera();
        this._look.set(camera.getLocation()).subtractLocal(this._worldTransform.getTranslation());
        Vector3 xzp = this._left;
        xzp.set(this._look.getX(), 0.0, this._look.getZ());
        if (xzp.equals((Object)Vector3.ZERO)) {
            return;
        }
        this._look.normalizeLocal();
        xzp.normalizeLocal();
        double cosp = this._look.dot((ReadOnlyVector3)xzp);
        this._orient.setValue(0, 0, xzp.getZ());
        this._orient.setValue(0, 1, xzp.getX() * -this._look.getY());
        this._orient.setValue(0, 2, xzp.getX() * cosp);
        this._orient.setValue(1, 0, 0.0);
        this._orient.setValue(1, 1, cosp);
        this._orient.setValue(1, 2, this._look.getY());
        this._orient.setValue(2, 0, -xzp.getX());
        this._orient.setValue(2, 1, xzp.getZ() * -this._look.getY());
        this._orient.setValue(2, 2, xzp.getZ() * cosp);
        Matrix3 mat = Matrix3.fetchTempInstance().set(this._worldTransform.getMatrix()).multiplyLocal((ReadOnlyMatrix3)this._orient);
        this._worldTransform.setRotation((ReadOnlyMatrix3)mat);
        Matrix3.releaseTempInstance((Matrix3)mat);
    }

    private void rotateScreenAligned() {
        Camera camera = Camera.getCurrentCamera();
        this._look.set(camera.getDirection()).negateLocal();
        this._left.set(camera.getLeft()).negateLocal();
        this._orient.fromAxes((ReadOnlyVector3)this._left, camera.getUp(), (ReadOnlyVector3)this._look);
        this._worldTransform.setRotation((ReadOnlyMatrix3)this._orient);
    }

    private void rotateAxial(Vector3 axis) {
        Camera camera = Camera.getCurrentCamera();
        this._look.set(camera.getLocation()).subtractLocal(this._worldTransform.getTranslation());
        Matrix3 worldMatrix = Matrix3.fetchTempInstance().set(this._worldTransform.getMatrix());
        worldMatrix.applyPost((ReadOnlyVector3)this._look, this._left);
        ReadOnlyVector3 scale = this._worldTransform.getScale();
        this._left.divideLocal(scale);
        double lengthSquared = this._left.getX() * this._left.getX() + this._left.getZ() * this._left.getZ();
        if (lengthSquared < 2.220446049250313E-16) {
            return;
        }
        double invLength = 1.0 / Math.sqrt(lengthSquared);
        if (axis.getY() == 1.0) {
            this._left.setX(this._left.getX() * invLength);
            this._left.setY(0.0);
            this._left.setZ(this._left.getZ() * invLength);
            this._left.normalizeLocal();
            this._orient.setValue(0, 0, this._left.getZ());
            this._orient.setValue(0, 1, 0.0);
            this._orient.setValue(0, 2, this._left.getX());
            this._orient.setValue(1, 0, 0.0);
            this._orient.setValue(1, 1, 1.0);
            this._orient.setValue(1, 2, 0.0);
            this._orient.setValue(2, 0, -this._left.getX());
            this._orient.setValue(2, 1, 0.0);
            this._orient.setValue(2, 2, this._left.getZ());
        } else if (axis.getZ() == 1.0) {
            this._left.setX(this._left.getX() * invLength);
            this._left.setY(this._left.getY() * invLength);
            this._left.setZ(0.0);
            this._left.normalizeLocal();
            this._orient.setValue(0, 0, this._left.getY());
            this._orient.setValue(0, 1, this._left.getX());
            this._orient.setValue(0, 2, 0.0);
            this._orient.setValue(1, 0, -this._left.getX());
            this._orient.setValue(1, 1, this._left.getY());
            this._orient.setValue(1, 2, 0.0);
            this._orient.setValue(2, 0, 0.0);
            this._orient.setValue(2, 1, 0.0);
            this._orient.setValue(2, 2, 1.0);
        }
        worldMatrix.multiplyLocal((ReadOnlyMatrix3)this._orient);
        this._worldTransform.setRotation((ReadOnlyMatrix3)worldMatrix);
        Matrix3.releaseTempInstance((Matrix3)worldMatrix);
    }

    public BillboardAlignment getAlignment() {
        return this._alignment;
    }

    public void setAlignment(BillboardAlignment alignment) {
        this._alignment = alignment;
    }

    @Override
    public void write(OutputCapsule capsule) throws IOException {
        super.write(capsule);
        capsule.write((Savable)this._orient, "orient", (Savable)new Matrix3());
        capsule.write((Savable)this._look, "look", (Savable)new Vector3(Vector3.ZERO));
        capsule.write((Savable)this._left, "left", (Savable)new Vector3(Vector3.ZERO));
        capsule.write((Enum)this._alignment, "alignment", (Enum)BillboardAlignment.ScreenAligned);
    }

    @Override
    public void read(InputCapsule capsule) throws IOException {
        super.read(capsule);
        this._orient.set((ReadOnlyMatrix3)((Matrix3)capsule.readSavable("orient", (Savable)new Matrix3(Matrix3.IDENTITY))));
        this._look.set((ReadOnlyVector3)((Vector3)capsule.readSavable("look", (Savable)new Vector3(Vector3.ZERO))));
        this._left.set((ReadOnlyVector3)((Vector3)capsule.readSavable("left", (Savable)new Vector3(Vector3.ZERO))));
        this._alignment = (BillboardAlignment)capsule.readEnum("alignment", BillboardAlignment.class, (Enum)BillboardAlignment.ScreenAligned);
    }

    public static enum BillboardAlignment {
        ScreenAligned,
        CameraAligned,
        AxialY,
        AxialZ;

    }
}

