/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.scenegraph.extension;

import com.ardor3d.math.Matrix3;
import com.ardor3d.math.type.ReadOnlyMatrix3;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.renderer.Camera;
import com.ardor3d.scenegraph.Node;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.export.Savable;
import java.io.IOException;

public class CameraNode
extends Node {
    private Camera _camera;

    public CameraNode() {
    }

    public CameraNode(String name, Camera camera) {
        super(name);
        this._camera = camera;
    }

    public void updateFromCamera() {
        ReadOnlyVector3 camLeft = this._camera.getLeft();
        ReadOnlyVector3 camUp = this._camera.getUp();
        ReadOnlyVector3 camDir = this._camera.getDirection();
        ReadOnlyVector3 camLoc = this._camera.getLocation();
        Matrix3 rotation = Matrix3.fetchTempInstance();
        rotation.fromAxes(camLeft, camUp, camDir);
        this.setRotation((ReadOnlyMatrix3)rotation);
        this.setTranslation(camLoc);
        Matrix3.releaseTempInstance((Matrix3)rotation);
    }

    public void setCamera(Camera camera) {
        this._camera = camera;
    }

    public Camera getCamera() {
        return this._camera;
    }

    @Override
    public void updateWorldTransform(boolean recurse) {
        super.updateWorldTransform(recurse);
        if (this._camera != null) {
            ReadOnlyVector3 worldTranslation = this.getWorldTranslation();
            ReadOnlyMatrix3 worldRotation = this.getWorldRotation();
            this._camera.setFrame(worldTranslation, worldRotation);
        }
    }

    @Override
    public void write(OutputCapsule capsule) throws IOException {
        super.write(capsule);
        capsule.write((Savable)this._camera, "camera", null);
    }

    @Override
    public void read(InputCapsule capsule) throws IOException {
        super.read(capsule);
        this._camera = (Camera)capsule.readSavable("camera", null);
    }
}

