/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.scenegraph.extension;

import com.ardor3d.renderer.ContextManager;
import com.ardor3d.renderer.RenderContext;
import com.ardor3d.renderer.Renderer;
import com.ardor3d.scenegraph.Node;
import com.ardor3d.scenegraph.Spatial;
import com.ardor3d.scenegraph.extension.PassNodeState;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class PassNode
extends Node {
    private List<PassNodeState> _passNodeStates = new ArrayList<PassNodeState>();

    public PassNode(String name) {
        super(name);
    }

    public PassNode() {
    }

    @Override
    public void draw(Renderer r) {
        if (this._children == null) {
            return;
        }
        RenderContext context = ContextManager.getCurrentContext();
        r.getQueue().pushBuckets();
        for (PassNodeState pass : this._passNodeStates) {
            if (!pass.isEnabled()) continue;
            pass.applyPassNodeStates(context);
            int cSize = this._children.size();
            for (int i = 0; i < cSize; ++i) {
                Spatial child = (Spatial)this._children.get(i);
                if (child == null) continue;
                child.onDraw(r);
            }
            r.renderBuckets();
            context.popEnforcedStates();
        }
        r.getQueue().popBuckets();
    }

    public void addPass(PassNodeState toAdd) {
        this._passNodeStates.add(toAdd);
    }

    public void insertPass(PassNodeState toAdd, int index) {
        this._passNodeStates.add(index, toAdd);
    }

    public boolean containsPass(PassNodeState s) {
        return this._passNodeStates.contains(s);
    }

    public boolean removePass(PassNodeState toRemove) {
        return this._passNodeStates.remove(toRemove);
    }

    public PassNodeState getPass(int index) {
        return this._passNodeStates.get(index);
    }

    public int nrPasses() {
        return this._passNodeStates.size();
    }

    public void clearAll() {
        this._passNodeStates.clear();
    }

    @Override
    public void write(OutputCapsule capsule) throws IOException {
        super.write(capsule);
        capsule.writeSavableList(this._passNodeStates, "passNodeStates", null);
    }

    @Override
    public void read(InputCapsule capsule) throws IOException {
        super.read(capsule);
        this._passNodeStates = capsule.readSavableList("passNodeStates", null);
    }
}

