/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.scenegraph.extension;

import com.ardor3d.renderer.RenderContext;
import com.ardor3d.renderer.state.RenderState;
import com.ardor3d.util.export.CapsuleUtils;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.export.Savable;
import java.io.IOException;
import java.io.Serializable;
import java.util.EnumMap;

public class PassNodeState
implements Savable,
Serializable {
    private static final long serialVersionUID = 1L;
    protected boolean _enabled = true;
    protected final EnumMap<RenderState.StateType, RenderState> _passStates = new EnumMap(RenderState.StateType.class);

    public void applyPassNodeStates(RenderContext context) {
        context.pushEnforcedStates();
        context.enforceStates(this._passStates);
    }

    public void setPassState(RenderState state) {
        this._passStates.put(state.getType(), state);
    }

    public RenderState getPassState(RenderState.StateType type) {
        return this._passStates.get((Object)type);
    }

    public void clearPassState(RenderState.StateType type) {
        this._passStates.remove((Object)type);
    }

    public void clearPassStates() {
        this._passStates.clear();
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void setEnabled(boolean enabled) {
        this._enabled = enabled;
    }

    public Class<? extends PassNodeState> getClassTag() {
        return this.getClass();
    }

    public void write(OutputCapsule capsule) throws IOException {
        OutputCapsule oc = capsule;
        oc.write(this._enabled, "enabled", true);
        oc.write((Savable[])this._passStates.values().toArray(new RenderState[0]), "passStates", null);
    }

    public void read(InputCapsule capsule) throws IOException {
        InputCapsule ic = capsule;
        this._enabled = ic.readBoolean("enabled", true);
        RenderState[] states = (RenderState[])CapsuleUtils.asArray((Savable[])ic.readSavableArray("passStates", null), RenderState.class);
        this._passStates.clear();
        if (states != null) {
            for (RenderState state : states) {
                this._passStates.put(state.getType(), state);
            }
        }
    }
}

