/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.scenegraph.extension;

import com.ardor3d.bounding.BoundingBox;
import com.ardor3d.bounding.BoundingSphere;
import com.ardor3d.bounding.BoundingVolume;
import com.ardor3d.image.Texture;
import com.ardor3d.image.Texture2D;
import com.ardor3d.image.TextureStoreFormat;
import com.ardor3d.math.ColorRGBA;
import com.ardor3d.math.Vector2;
import com.ardor3d.math.Vector3;
import com.ardor3d.math.type.ReadOnlyColorRGBA;
import com.ardor3d.math.type.ReadOnlyVector2;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.renderer.Camera;
import com.ardor3d.renderer.ContextManager;
import com.ardor3d.renderer.Renderer;
import com.ardor3d.renderer.TextureRenderer;
import com.ardor3d.renderer.TextureRendererFactory;
import com.ardor3d.renderer.queue.RenderBucketType;
import com.ardor3d.renderer.state.BlendState;
import com.ardor3d.renderer.state.TextureState;
import com.ardor3d.scenegraph.Node;
import com.ardor3d.scenegraph.Spatial;
import com.ardor3d.scenegraph.hint.LightCombineMode;
import com.ardor3d.scenegraph.hint.TextureCombineMode;
import com.ardor3d.scenegraph.shape.Quad;
import com.ardor3d.util.Timer;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.export.Savable;
import com.ardor3d.util.geom.BufferUtils;
import java.io.IOException;
import java.nio.FloatBuffer;

public class QuadImposterNode
extends Node {
    protected TextureRenderer _tRenderer;
    protected Texture2D _texture;
    protected Node _targetScene;
    protected Quad _imposterQuad;
    protected double _redrawRate;
    protected double _elapsed;
    protected double _cameraAngleThreshold;
    protected double _cameraDistanceThreshold = Double.MAX_VALUE;
    protected boolean _haveDrawn;
    protected Vector3 _worldUpVector = new Vector3(0.0, 1.0, 0.0);
    protected boolean _doUpdate = true;
    protected Camera _cam;
    protected int _twidth;
    protected int _theight;
    protected int _depth;
    protected int _samples;
    protected final Vector3 _lastCamDir = new Vector3();
    protected double _lastCamDist;
    protected Vector3[] _corners = new Vector3[8];
    protected final Vector3 _center = new Vector3();
    protected final Vector3 _extents = new Vector3();
    protected final Vector2 _minScreenPos = new Vector2();
    protected final Vector2 _maxScreenPos = new Vector2();
    protected final Vector2 _minMaxScreenPos = new Vector2();
    protected final Vector2 _maxMinScreenPos = new Vector2();
    protected final Vector3 _tempVec = new Vector3();
    protected double _minZ;
    protected double _nearPlane;
    protected double _farPlane;
    protected Timer _timer;

    public QuadImposterNode() {
        this(null, 64, 64);
    }

    public QuadImposterNode(String name, int twidth, int theight) {
        this(name, twidth, theight, null);
    }

    public QuadImposterNode(String name, int twidth, int theight, Timer timer) {
        this(name, twidth, theight, 8, 0, timer);
    }

    public QuadImposterNode(String name, int twidth, int theight, int depth, int samples, Timer timer) {
        super(name);
        this._twidth = twidth;
        this._theight = theight;
        this._depth = depth;
        this._samples = samples;
        this._timer = timer;
        this._texture = new Texture2D();
        this._imposterQuad = new Quad("ImposterQuad");
        this._imposterQuad.resize(1.0, 1.0);
        this._imposterQuad.setModelBound(new BoundingBox());
        this._imposterQuad.getSceneHints().setTextureCombineMode(TextureCombineMode.Replace);
        this._imposterQuad.getSceneHints().setLightCombineMode(LightCombineMode.Off);
        super.attachChild(this._imposterQuad);
        this.getSceneHints().setRenderBucketType(RenderBucketType.Transparent);
        this._targetScene = new Node();
        super.attachChild(this._targetScene);
        for (int i = 0; i < this._corners.length; ++i) {
            this._corners[i] = new Vector3();
        }
        if (timer != null) {
            this._elapsed = 0.05;
            this._redrawRate = 0.05;
        } else {
            this.setCameraAngleThreshold(10.0);
            this.setCameraDistanceThreshold(0.2);
        }
        this._haveDrawn = false;
    }

    @Override
    public int attachChild(Spatial child) {
        return this._targetScene.attachChild(child);
    }

    @Override
    public int attachChildAt(Spatial child, int index) {
        return this._targetScene.attachChildAt(child, index);
    }

    @Override
    public void detachAllChildren() {
        this._targetScene.detachAllChildren();
    }

    @Override
    public int detachChild(Spatial child) {
        return this._targetScene.detachChild(child);
    }

    @Override
    public Spatial detachChildAt(int index) {
        return this._targetScene.detachChildAt(index);
    }

    @Override
    public int detachChildNamed(String childName) {
        return this._targetScene.detachChildNamed(childName);
    }

    private void init(Renderer renderer) {
        this._tRenderer = TextureRendererFactory.INSTANCE.createTextureRenderer(this._twidth, this._theight, this._depth, this._samples, renderer, ContextManager.getCurrentContext().getCapabilities());
        this._tRenderer.setBackgroundColor((ReadOnlyColorRGBA)new ColorRGBA(0.0f, 0.0f, 0.0f, 0.0f));
        this.resetTexture();
    }

    @Override
    public void draw(Renderer r) {
        if (this._timer != null && this._redrawRate > 0.0) {
            this._elapsed += this._timer.getTimePerFrame();
        }
        if (this._tRenderer == null) {
            this.init(r);
        }
        if (this._cam == null) {
            this._cam = Camera.getCurrentCamera();
            this._tRenderer.getCamera().setFrustum(this._cam.getFrustumNear(), this._cam.getFrustumFar(), this._cam.getFrustumLeft(), this._cam.getFrustumRight(), this._cam.getFrustumTop(), this._cam.getFrustumBottom());
            this._tRenderer.getCamera().setFrame(this._cam.getLocation(), this._cam.getLeft(), this._cam.getUp(), this._cam.getDirection());
        }
        if (this._doUpdate && (!this._haveDrawn || this.shouldDoUpdate(this._cam)) && this._targetScene.getWorldBound() != null) {
            BoundingVolume b = this._targetScene.getWorldBound();
            this._center.set(b.getCenter());
            this.updateCameraLookat();
            this.calculateImposter();
            this.updateCameraLookat();
            this.updateCameraFrustum();
            this.renderImposter();
            this._haveDrawn = true;
        }
        this._imposterQuad.draw(r);
    }

    @Override
    protected void updateChildren(double time) {
        this._imposterQuad.updateGeometricState(time, false);
        if (this._doUpdate && (!this._haveDrawn || this.shouldDoUpdate(this._cam))) {
            this._targetScene.updateGeometricState(time, false);
        }
    }

    private void calculateImposter() {
        int i;
        BoundingVolume worldBound = this._targetScene.getWorldBound();
        this._center.set(worldBound.getCenter());
        for (int i2 = 0; i2 < this._corners.length; ++i2) {
            this._corners[i2].set((ReadOnlyVector3)this._center);
        }
        if (worldBound instanceof BoundingBox) {
            BoundingBox bbox = (BoundingBox)worldBound;
            bbox.getExtent(this._extents);
        } else if (worldBound instanceof BoundingSphere) {
            BoundingSphere bsphere = (BoundingSphere)worldBound;
            this._extents.set(bsphere.getRadius(), bsphere.getRadius(), bsphere.getRadius());
        }
        this._corners[0].addLocal(this._extents.getX(), this._extents.getY(), -this._extents.getZ());
        this._corners[1].addLocal(-this._extents.getX(), this._extents.getY(), -this._extents.getZ());
        this._corners[2].addLocal(this._extents.getX(), -this._extents.getY(), -this._extents.getZ());
        this._corners[3].addLocal(-this._extents.getX(), -this._extents.getY(), -this._extents.getZ());
        this._corners[4].addLocal(this._extents.getX(), this._extents.getY(), this._extents.getZ());
        this._corners[5].addLocal(-this._extents.getX(), this._extents.getY(), this._extents.getZ());
        this._corners[6].addLocal(this._extents.getX(), -this._extents.getY(), this._extents.getZ());
        this._corners[7].addLocal(-this._extents.getX(), -this._extents.getY(), this._extents.getZ());
        for (i = 0; i < this._corners.length; ++i) {
            this._tRenderer.getCamera().getScreenCoordinates((ReadOnlyVector3)this._corners[i], this._corners[i]);
        }
        this._minScreenPos.set(Double.MAX_VALUE, Double.MAX_VALUE);
        this._maxScreenPos.set(-1.7976931348623157E308, -1.7976931348623157E308);
        this._minZ = Double.MAX_VALUE;
        for (i = 0; i < this._corners.length; ++i) {
            this._minScreenPos.setX(Math.min(this._corners[i].getX(), this._minScreenPos.getX()));
            this._minScreenPos.setY(Math.min(this._corners[i].getY(), this._minScreenPos.getY()));
            this._maxScreenPos.setX(Math.max(this._corners[i].getX(), this._maxScreenPos.getX()));
            this._maxScreenPos.setY(Math.max(this._corners[i].getY(), this._maxScreenPos.getY()));
            this._minZ = Math.min(this._corners[i].getZ(), this._minZ);
        }
        this._maxMinScreenPos.set(this._maxScreenPos.getX(), this._minScreenPos.getY());
        this._minMaxScreenPos.set(this._minScreenPos.getX(), this._maxScreenPos.getY());
        this._tRenderer.getCamera().getWorldCoordinates((ReadOnlyVector2)this._maxScreenPos, this._minZ, this._corners[0]);
        this._tRenderer.getCamera().getWorldCoordinates((ReadOnlyVector2)this._maxMinScreenPos, this._minZ, this._corners[1]);
        this._tRenderer.getCamera().getWorldCoordinates((ReadOnlyVector2)this._minScreenPos, this._minZ, this._corners[2]);
        this._tRenderer.getCamera().getWorldCoordinates((ReadOnlyVector2)this._minMaxScreenPos, this._minZ, this._corners[3]);
        this._center.set((ReadOnlyVector3)this._corners[0]).addLocal((ReadOnlyVector3)this._corners[1]).addLocal((ReadOnlyVector3)this._corners[2]).addLocal((ReadOnlyVector3)this._corners[3]).multiplyLocal(0.25);
        this._lastCamDir.set((ReadOnlyVector3)this._center).subtractLocal(this._tRenderer.getCamera().getLocation());
        this._lastCamDist = this._nearPlane = this._lastCamDir.length();
        this._farPlane = this._nearPlane + this._extents.length() * 2.0;
        this._lastCamDir.normalizeLocal();
        FloatBuffer vertexBuffer = this._imposterQuad.getMeshData().getVertexBuffer();
        BufferUtils.setInBuffer((ReadOnlyVector3)this._corners[0], vertexBuffer, 3);
        BufferUtils.setInBuffer((ReadOnlyVector3)this._corners[1], vertexBuffer, 2);
        BufferUtils.setInBuffer((ReadOnlyVector3)this._corners[2], vertexBuffer, 1);
        BufferUtils.setInBuffer((ReadOnlyVector3)this._corners[3], vertexBuffer, 0);
        this._imposterQuad.updateModelBound();
    }

    private void updateCameraLookat() {
        this._tRenderer.getCamera().setLocation(this._cam.getLocation());
        this._tRenderer.getCamera().lookAt((ReadOnlyVector3)this._center, (ReadOnlyVector3)this._worldUpVector);
    }

    private void updateCameraFrustum() {
        double width = this._corners[2].subtractLocal((ReadOnlyVector3)this._corners[1]).length() / 2.0;
        double height = this._corners[1].subtractLocal((ReadOnlyVector3)this._corners[0]).length() / 2.0;
        this._tRenderer.getCamera().setFrustum(this._nearPlane, this._farPlane, -width, width, height, -height);
    }

    private boolean shouldDoUpdate(Camera cam) {
        if (this._redrawRate > 0.0 && this._elapsed >= this._redrawRate) {
            this._elapsed %= this._redrawRate;
            return true;
        }
        if (this._cameraAngleThreshold > 0.0) {
            this._tempVec.set((ReadOnlyVector3)this._center).subtractLocal(cam.getLocation());
            double currentDist = this._tempVec.length();
            if (this._lastCamDist != 0.0 && Math.abs(currentDist - this._lastCamDist) / this._lastCamDist > this._cameraDistanceThreshold) {
                return true;
            }
            this._tempVec.normalizeLocal();
            double angle = this._tempVec.smallestAngleBetween((ReadOnlyVector3)this._lastCamDir);
            if (angle > this._cameraAngleThreshold) {
                return true;
            }
        }
        return false;
    }

    public void setRedrawRate(double rate) {
        this._redrawRate = this._elapsed = rate;
    }

    public double getCameraDistanceThreshold() {
        return this._cameraDistanceThreshold;
    }

    public void setCameraDistanceThreshold(double cameraDistanceThreshold) {
        this._cameraDistanceThreshold = cameraDistanceThreshold;
    }

    public double getCameraAngleThreshold() {
        return this._cameraAngleThreshold;
    }

    public void setCameraAngleThreshold(double cameraAngleThreshold) {
        this._cameraAngleThreshold = cameraAngleThreshold;
    }

    public void resetTexture() {
        this._texture.setWrap(Texture.WrapMode.EdgeClamp);
        this._texture.setMinificationFilter(Texture.MinificationFilter.BilinearNoMipMaps);
        this._texture.setMagnificationFilter(Texture.MagnificationFilter.Bilinear);
        this._texture.setTextureStoreFormat(TextureStoreFormat.RGBA8);
        this._tRenderer.setupTexture(this._texture);
        TextureState ts = new TextureState();
        ts.setEnabled(true);
        ts.setTexture(this._texture, 0);
        this._imposterQuad.setRenderState(ts);
        BlendState as1 = new BlendState();
        as1.setBlendEnabled(true);
        as1.setSourceFunction(BlendState.SourceFunction.SourceAlpha);
        as1.setDestinationFunction(BlendState.DestinationFunction.OneMinusSourceAlpha);
        as1.setTestEnabled(true);
        as1.setTestFunction(BlendState.TestFunction.GreaterThan);
        as1.setEnabled(true);
        this._imposterQuad.setRenderState(as1);
    }

    public void renderImposter() {
        this._tRenderer.render((Spatial)this._targetScene, (Texture)this._texture, 3);
    }

    public Vector3 getWorldUpVector() {
        return this._worldUpVector;
    }

    public void setWorldUpVector(Vector3 worldUpVector) {
        this._worldUpVector = worldUpVector;
    }

    @Override
    public void write(OutputCapsule capsule) throws IOException {
        super.write(capsule);
        capsule.write((Savable)this._texture, "texture", null);
        capsule.write((Savable)this._targetScene, "targetScene", null);
        capsule.write((Savable)this._imposterQuad, "standIn", (Savable)new Quad("ImposterQuad"));
        capsule.write(this._redrawRate, "redrawRate", (double)0.05f);
        capsule.write(this._cameraAngleThreshold, "cameraThreshold", 0.0);
        capsule.write((Savable)this._worldUpVector, "worldUpVector", (Savable)new Vector3(Vector3.UNIT_Y));
    }

    @Override
    public void read(InputCapsule capsule) throws IOException {
        super.read(capsule);
        this._texture = (Texture2D)capsule.readSavable("texture", null);
        this._targetScene = (Node)capsule.readSavable("targetScene", null);
        this._imposterQuad = (Quad)capsule.readSavable("standIn", (Savable)new Quad("ImposterQuad"));
        this._redrawRate = capsule.readFloat("redrawRate", 0.05f);
        this._cameraAngleThreshold = capsule.readFloat("cameraThreshold", 0.0f);
        this._worldUpVector = (Vector3)capsule.readSavable("worldUpVector", (Savable)new Vector3(Vector3.UNIT_Y));
    }

    public Texture getTexture() {
        return this._texture;
    }

    public void setDoUpdate(boolean doUpdate) {
        this._doUpdate = doUpdate;
    }

    public boolean isDoUpdate() {
        return this._doUpdate;
    }
}

