/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.scenegraph.extension;

import com.ardor3d.image.Texture;
import com.ardor3d.math.Matrix3;
import com.ardor3d.math.Vector3;
import com.ardor3d.math.type.ReadOnlyMatrix3;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.renderer.Renderer;
import com.ardor3d.renderer.queue.RenderBucketType;
import com.ardor3d.renderer.state.FogState;
import com.ardor3d.renderer.state.RenderState;
import com.ardor3d.renderer.state.TextureState;
import com.ardor3d.renderer.state.ZBufferState;
import com.ardor3d.scenegraph.Node;
import com.ardor3d.scenegraph.hint.CullHint;
import com.ardor3d.scenegraph.hint.LightCombineMode;
import com.ardor3d.scenegraph.hint.TextureCombineMode;
import com.ardor3d.scenegraph.shape.Quad;
import com.ardor3d.util.export.CapsuleUtils;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.export.Savable;
import java.io.IOException;

public class Skybox
extends Node {
    private float _xExtent;
    private float _yExtent;
    private float _zExtent;
    private Quad[] _skyboxQuads;

    public Skybox() {
    }

    public Skybox(String name, float xExtent, float yExtent, float zExtent) {
        super(name);
        this._xExtent = xExtent;
        this._yExtent = yExtent;
        this._zExtent = zExtent;
        this.initialize();
    }

    public void setTexture(Face face, Texture texture) {
        if (face == null) {
            throw new IllegalArgumentException("Face can not be null.");
        }
        this._skyboxQuads[face.ordinal()].clearRenderState(RenderState.StateType.Texture);
        this.setTexture(face, texture, 0);
    }

    public void setTexture(Face face, Texture texture, int textureUnit) {
        if (face == null) {
            throw new IllegalArgumentException("Face can not be null.");
        }
        TextureState ts = (TextureState)this._skyboxQuads[face.ordinal()].getLocalRenderState(RenderState.StateType.Texture);
        if (ts == null) {
            ts = new TextureState();
        }
        ts.setTexture(texture, textureUnit);
        ts.setEnabled(true);
        texture.setWrap(Texture.WrapMode.EdgeClamp);
        this._skyboxQuads[face.ordinal()].setRenderState(ts);
    }

    public Texture getTexture(Face face) {
        if (face == null) {
            throw new IllegalArgumentException("Face can not be null.");
        }
        return ((TextureState)this._skyboxQuads[face.ordinal()].getLocalRenderState(RenderState.StateType.Texture)).getTexture();
    }

    public void initialize() {
        this._skyboxQuads = new Quad[6];
        this._skyboxQuads[Face.North.ordinal()] = new Quad("north", this._xExtent * 2.0f, this._yExtent * 2.0f);
        this._skyboxQuads[Face.North.ordinal()].setRotation((ReadOnlyMatrix3)new Matrix3().fromAngles(0.0, Math.toRadians(180.0), 0.0));
        this._skyboxQuads[Face.North.ordinal()].setTranslation((ReadOnlyVector3)new Vector3(0.0, 0.0, (double)this._zExtent));
        this._skyboxQuads[Face.South.ordinal()] = new Quad("south", this._xExtent * 2.0f, this._yExtent * 2.0f);
        this._skyboxQuads[Face.South.ordinal()].setTranslation((ReadOnlyVector3)new Vector3(0.0, 0.0, (double)(-this._zExtent)));
        this._skyboxQuads[Face.East.ordinal()] = new Quad("east", this._zExtent * 2.0f, this._yExtent * 2.0f);
        this._skyboxQuads[Face.East.ordinal()].setRotation((ReadOnlyMatrix3)new Matrix3().fromAngles(0.0, Math.toRadians(90.0), 0.0));
        this._skyboxQuads[Face.East.ordinal()].setTranslation((ReadOnlyVector3)new Vector3((double)(-this._xExtent), 0.0, 0.0));
        this._skyboxQuads[Face.West.ordinal()] = new Quad("west", this._zExtent * 2.0f, this._yExtent * 2.0f);
        this._skyboxQuads[Face.West.ordinal()].setRotation((ReadOnlyMatrix3)new Matrix3().fromAngles(0.0, Math.toRadians(270.0), 0.0));
        this._skyboxQuads[Face.West.ordinal()].setTranslation((ReadOnlyVector3)new Vector3((double)this._xExtent, 0.0, 0.0));
        this._skyboxQuads[Face.Up.ordinal()] = new Quad("up", this._xExtent * 2.0f, this._zExtent * 2.0f);
        this._skyboxQuads[Face.Up.ordinal()].setRotation((ReadOnlyMatrix3)new Matrix3().fromAngles(Math.toRadians(90.0), Math.toRadians(270.0), 0.0));
        this._skyboxQuads[Face.Up.ordinal()].setTranslation((ReadOnlyVector3)new Vector3(0.0, (double)this._yExtent, 0.0));
        this._skyboxQuads[Face.Down.ordinal()] = new Quad("down", this._xExtent * 2.0f, this._zExtent * 2.0f);
        this._skyboxQuads[Face.Down.ordinal()].setRotation((ReadOnlyMatrix3)new Matrix3().fromAngles(Math.toRadians(270.0), Math.toRadians(270.0), 0.0));
        this._skyboxQuads[Face.Down.ordinal()].setTranslation((ReadOnlyVector3)new Vector3(0.0, (double)(-this._yExtent), 0.0));
        this.getSceneHints().setLightCombineMode(LightCombineMode.Off);
        this.getSceneHints().setTextureCombineMode(TextureCombineMode.Replace);
        ZBufferState zbuff = new ZBufferState();
        zbuff.setEnabled(false);
        this.setRenderState(zbuff);
        FogState fs = new FogState();
        fs.setEnabled(false);
        this.setRenderState(fs);
        this.getSceneHints().setCullHint(CullHint.Never);
        for (int i = 0; i < 6; ++i) {
            this._skyboxQuads[i].getSceneHints().setTextureCombineMode(TextureCombineMode.Replace);
            this._skyboxQuads[i].getSceneHints().setLightCombineMode(LightCombineMode.Off);
            this._skyboxQuads[i].getSceneHints().setCullHint(CullHint.Never);
            this._skyboxQuads[i].getSceneHints().setRenderBucketType(RenderBucketType.PreBucket);
            this.attachChild(this._skyboxQuads[i]);
        }
    }

    public Quad getFace(Face face) {
        return this._skyboxQuads[face.ordinal()];
    }

    public void preloadTexture(Face face, Renderer r) {
        TextureState ts = (TextureState)this._skyboxQuads[face.ordinal()].getLocalRenderState(RenderState.StateType.Texture);
        if (ts != null) {
            r.applyState(RenderState.StateType.Texture, ts);
        }
    }

    public void preloadTextures(Renderer r) {
        for (int x = 0; x < 6; ++x) {
            TextureState ts = (TextureState)this._skyboxQuads[x].getLocalRenderState(RenderState.StateType.Texture);
            if (ts == null) continue;
            r.applyState(RenderState.StateType.Texture, ts);
        }
    }

    @Override
    public void write(OutputCapsule capsule) throws IOException {
        super.write(capsule);
        capsule.write(this._xExtent, "xExtent", 0.0f);
        capsule.write(this._yExtent, "yExtent", 0.0f);
        capsule.write(this._zExtent, "zExtent", 0.0f);
        capsule.write((Savable[])this._skyboxQuads, "skyboxQuads", null);
    }

    @Override
    public void read(InputCapsule capsule) throws IOException {
        super.read(capsule);
        this._xExtent = capsule.readFloat("xExtent", 0.0f);
        this._yExtent = capsule.readFloat("yExtent", 0.0f);
        this._zExtent = capsule.readFloat("zExtent", 0.0f);
        this._skyboxQuads = (Quad[])CapsuleUtils.asArray((Savable[])capsule.readSavableArray("skyboxQuads", null), Quad.class);
    }

    public static enum Face {
        North,
        South,
        East,
        West,
        Up,
        Down;

    }
}

