/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.scenegraph.extension;

import com.ardor3d.renderer.Renderer;
import com.ardor3d.scenegraph.Node;
import com.ardor3d.scenegraph.Spatial;
import java.util.BitSet;

public class SwitchNode
extends Node {
    protected BitSet _childMask = new BitSet();

    public SwitchNode() {
        this("SwitchNode");
    }

    public SwitchNode(String name) {
        super(name);
        this._childMask.set(0);
    }

    @Override
    public void draw(Renderer r) {
        if (this._children == null) {
            return;
        }
        int max = Math.min(this._childMask.length(), this._children.size());
        for (int i = 0; i < max; ++i) {
            Spatial child;
            if (!this._childMask.get(i) || (child = (Spatial)this._children.get(i)) == null) continue;
            child.onDraw(r);
        }
    }

    @Override
    protected void updateChildren(double time) {
        if (this._children == null) {
            return;
        }
        int max = Math.min(this._childMask.length(), this._children.size());
        for (int i = 0; i < max; ++i) {
            Spatial child;
            if (!this._childMask.get(i) || (child = (Spatial)this._children.get(i)) == null) continue;
            child.updateGeometricState(time, false);
        }
    }

    public void setAllNonVisible() {
        this._childMask.clear();
    }

    public void setAllVisible() {
        this._childMask.set(0, this.getNumberOfChildren());
    }

    public void flipAllVisible() {
        this._childMask.flip(0, this.getNumberOfChildren());
    }

    public boolean getVisible(int bitIndex) {
        return this._childMask.get(bitIndex);
    }

    public BitSet getVisible() {
        return this._childMask;
    }

    public void setVisible(BitSet set) {
        this._childMask = set;
    }

    public void setVisible(int bitIndex, boolean value) {
        this._childMask.set(bitIndex, value);
    }

    public void setVisible(int fromIndex, int toIndex, boolean value) {
        this._childMask.set(fromIndex, toIndex, value);
    }

    public void setSingleVisible(int bitIndex) {
        this._childMask.clear();
        this._childMask.set(bitIndex);
    }

    public int getNextNonVisible(int fromIndex) {
        return this._childMask.nextClearBit(fromIndex);
    }

    public int getNextVisible(int fromIndex) {
        return this._childMask.nextSetBit(fromIndex);
    }

    public void shiftVisibleRight() {
        int nrChildren = this.getNumberOfChildren();
        if (nrChildren == 0) {
            return;
        }
        boolean lastVal = this._childMask.get(nrChildren - 1);
        for (int i = nrChildren - 1; i > 0; --i) {
            this._childMask.set(i, this._childMask.get(i - 1));
        }
        this._childMask.set(0, lastVal);
    }

    public void shiftVisibleLeft() {
        int nrChildren = this.getNumberOfChildren();
        if (nrChildren == 0) {
            return;
        }
        boolean firstVal = this._childMask.get(0);
        for (int i = 0; i < nrChildren - 1; ++i) {
            this._childMask.set(i, this._childMask.get(i + 1));
        }
        this._childMask.set(this.getNumberOfChildren() - 1, firstVal);
    }

    public void flipVisible(int fromIndex, int toIndex) {
        this._childMask.flip(fromIndex, toIndex);
    }

    public void flipVisible(int bitIndex) {
        this._childMask.flip(bitIndex);
    }
}

