/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.scenegraph.hint;

import com.ardor3d.renderer.queue.RenderBucketType;
import com.ardor3d.scenegraph.hint.CullHint;
import com.ardor3d.scenegraph.hint.DataMode;
import com.ardor3d.scenegraph.hint.Hintable;
import com.ardor3d.scenegraph.hint.LightCombineMode;
import com.ardor3d.scenegraph.hint.NormalsMode;
import com.ardor3d.scenegraph.hint.PickingHint;
import com.ardor3d.scenegraph.hint.TextureCombineMode;
import com.ardor3d.scenegraph.hint.TransparencyType;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.export.Savable;
import java.io.IOException;
import java.util.EnumSet;

public class SceneHints
implements Savable {
    protected DataMode _dataMode = DataMode.Inherit;
    protected NormalsMode _normalsMode = NormalsMode.Inherit;
    protected CullHint _cullHint = CullHint.Inherit;
    protected LightCombineMode _lightCombineMode = LightCombineMode.Inherit;
    protected TextureCombineMode _textureCombineMode = TextureCombineMode.Inherit;
    protected RenderBucketType _renderBucketType = RenderBucketType.Inherit;
    protected int _orthoOrder = 0;
    protected final EnumSet<PickingHint> _pickingHints = EnumSet.allOf(PickingHint.class);
    private final Hintable _source;
    private TransparencyType _transpType = TransparencyType.Inherit;
    protected boolean _castsShadows = true;

    public SceneHints(Hintable source) {
        this._source = source;
    }

    public void set(SceneHints sceneHints) {
        this._dataMode = sceneHints._dataMode;
        this._normalsMode = sceneHints._normalsMode;
        this._cullHint = sceneHints._cullHint;
        this._lightCombineMode = sceneHints._lightCombineMode;
        this._textureCombineMode = sceneHints._textureCombineMode;
        this._renderBucketType = sceneHints._renderBucketType;
        this._orthoOrder = sceneHints._orthoOrder;
        this._pickingHints.clear();
        this._pickingHints.addAll(sceneHints._pickingHints);
        this._castsShadows = sceneHints._castsShadows;
        this._transpType = sceneHints._transpType;
    }

    public DataMode getDataMode() {
        if (this._dataMode != DataMode.Inherit) {
            return this._dataMode;
        }
        Hintable parent = this._source.getParentHintable();
        if (parent != null) {
            return parent.getSceneHints().getDataMode();
        }
        return DataMode.Arrays;
    }

    public DataMode getLocalDataMode() {
        return this._dataMode;
    }

    public void setDataMode(DataMode type) {
        this._dataMode = type;
    }

    public NormalsMode getNormalsMode() {
        if (this._normalsMode != NormalsMode.Inherit) {
            return this._normalsMode;
        }
        Hintable parent = this._source.getParentHintable();
        if (parent != null) {
            return parent.getSceneHints().getNormalsMode();
        }
        return NormalsMode.NormalizeIfScaled;
    }

    public NormalsMode getLocalNormalsMode() {
        return this._normalsMode;
    }

    public void setNormalsMode(NormalsMode mode) {
        this._normalsMode = mode;
    }

    public CullHint getCullHint() {
        if (this._cullHint != CullHint.Inherit) {
            return this._cullHint;
        }
        Hintable parent = this._source.getParentHintable();
        if (parent != null) {
            return parent.getSceneHints().getCullHint();
        }
        return CullHint.Dynamic;
    }

    public CullHint getLocalCullHint() {
        return this._cullHint;
    }

    public void setCullHint(CullHint hint) {
        this._cullHint = hint;
    }

    public TextureCombineMode getTextureCombineMode() {
        if (this._textureCombineMode != TextureCombineMode.Inherit) {
            return this._textureCombineMode;
        }
        Hintable parent = this._source.getParentHintable();
        if (parent != null) {
            return parent.getSceneHints().getTextureCombineMode();
        }
        return TextureCombineMode.CombineClosest;
    }

    public TextureCombineMode getLocalTextureCombineMode() {
        return this._textureCombineMode;
    }

    public void setTextureCombineMode(TextureCombineMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("mode can not be null.");
        }
        this._textureCombineMode = mode;
    }

    public LightCombineMode getLightCombineMode() {
        if (this._lightCombineMode != LightCombineMode.Inherit) {
            return this._lightCombineMode;
        }
        Hintable parent = this._source.getParentHintable();
        if (parent != null) {
            return parent.getSceneHints().getLightCombineMode();
        }
        return LightCombineMode.CombineFirst;
    }

    public LightCombineMode getLocalLightCombineMode() {
        return this._lightCombineMode;
    }

    public void setLightCombineMode(LightCombineMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("mode can not be null.");
        }
        this._lightCombineMode = mode;
    }

    public RenderBucketType getRenderBucketType() {
        if (this._renderBucketType != RenderBucketType.Inherit) {
            return this._renderBucketType;
        }
        Hintable parent = this._source.getParentHintable();
        if (parent != null) {
            return parent.getSceneHints().getRenderBucketType();
        }
        return RenderBucketType.Opaque;
    }

    public RenderBucketType getLocalRenderBucketType() {
        return this._renderBucketType;
    }

    public void setRenderBucketType(RenderBucketType renderBucketType) {
        this._renderBucketType = renderBucketType;
    }

    public boolean isPickingHintEnabled(PickingHint pickingHint) {
        return this._pickingHints.contains((Object)pickingHint);
    }

    public void setPickingHint(PickingHint pickingHint, boolean enabled) {
        if (enabled) {
            this._pickingHints.add(pickingHint);
        } else {
            this._pickingHints.remove((Object)pickingHint);
        }
    }

    public void setAllPickingHints(boolean enabled) {
        if (enabled) {
            this._pickingHints.addAll(EnumSet.allOf(PickingHint.class));
        } else {
            this._pickingHints.clear();
        }
    }

    public int getOrthoOrder() {
        return this._orthoOrder;
    }

    public void setOrthoOrder(int orthoOrder) {
        this._orthoOrder = orthoOrder;
    }

    public TransparencyType getTransparencyType() {
        if (this._transpType != TransparencyType.Inherit) {
            return this._transpType;
        }
        Hintable parent = this._source.getParentHintable();
        if (parent != null) {
            return parent.getSceneHints().getTransparencyType();
        }
        return TransparencyType.OnePass;
    }

    public TransparencyType getLocalTransparencyType() {
        return this._transpType;
    }

    public void setTransparencyType(TransparencyType type) {
        this._transpType = type;
    }

    public boolean isCastsShadows() {
        return this._castsShadows;
    }

    public void setCastsShadows(boolean castsShadows) {
        this._castsShadows = castsShadows;
    }

    public Class<? extends SceneHints> getClassTag() {
        return this.getClass();
    }

    public void read(InputCapsule capsule) throws IOException {
        this._orthoOrder = capsule.readInt("orthoOrder", 0);
        this._cullHint = (CullHint)capsule.readEnum("cullMode", CullHint.class, (Enum)CullHint.Inherit);
        String bucketTypeName = capsule.readString("renderBucketType", RenderBucketType.Inherit.name());
        this._renderBucketType = RenderBucketType.getRenderBucketType(bucketTypeName);
        this._lightCombineMode = (LightCombineMode)capsule.readEnum("lightCombineMode", LightCombineMode.class, (Enum)LightCombineMode.Inherit);
        this._textureCombineMode = (TextureCombineMode)capsule.readEnum("textureCombineMode", TextureCombineMode.class, (Enum)TextureCombineMode.Inherit);
        this._normalsMode = (NormalsMode)capsule.readEnum("normalsMode", NormalsMode.class, (Enum)NormalsMode.Inherit);
        this._dataMode = (DataMode)capsule.readEnum("dataMode", DataMode.class, (Enum)DataMode.Inherit);
        this._transpType = (TransparencyType)capsule.readEnum("transpType", TransparencyType.class, (Enum)TransparencyType.Inherit);
        this._castsShadows = capsule.readBoolean("castsShadows", true);
        PickingHint[] pickHints = (PickingHint[])capsule.readEnumArray("pickingHints", PickingHint.class, null);
        this._pickingHints.clear();
        if (pickHints != null) {
            for (PickingHint hint : pickHints) {
                this._pickingHints.add(hint);
            }
        } else {
            for (PickingHint hint : PickingHint.values()) {
                this._pickingHints.add(hint);
            }
        }
    }

    public void write(OutputCapsule capsule) throws IOException {
        capsule.write(this._orthoOrder, "orthoOrder", 0);
        capsule.write((Enum)this._cullHint, "cullMode", (Enum)CullHint.Inherit);
        capsule.write(this._renderBucketType.name(), "renderBucketType", RenderBucketType.Inherit.name());
        capsule.write((Enum)this._lightCombineMode, "lightCombineMode", (Enum)LightCombineMode.Inherit);
        capsule.write((Enum)this._textureCombineMode, "textureCombineMode", (Enum)TextureCombineMode.Inherit);
        capsule.write((Enum)this._normalsMode, "normalsMode", (Enum)NormalsMode.Inherit);
        capsule.write((Enum)this._dataMode, "dataMode", (Enum)DataMode.Inherit);
        capsule.write((Enum[])this._pickingHints.toArray(new PickingHint[0]), "pickingHints");
        capsule.write((Enum)this._transpType, "transpType", (Enum)TransparencyType.Inherit);
        capsule.write(this._castsShadows, "castsShadows", true);
    }
}

