/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.scenegraph.shape;

import com.ardor3d.math.Quaternion;
import com.ardor3d.math.type.ReadOnlyColorRGBA;
import com.ardor3d.scenegraph.Mesh;
import com.ardor3d.scenegraph.Node;
import com.ardor3d.scenegraph.shape.Cylinder;
import com.ardor3d.scenegraph.shape.Pyramid;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import java.io.IOException;

public class Arrow
extends Node {
    protected double _length = 1.0;
    protected double _width = 0.25;
    protected static final Quaternion rotator = new Quaternion().applyRotationX(1.5707963267948966);

    public Arrow() {
    }

    public Arrow(String name) {
        super(name);
    }

    public Arrow(String name, double length, double width) {
        super(name);
        this._length = length;
        this._width = width;
        this.buildArrow();
    }

    public void buildArrow() {
        Cylinder base = new Cylinder("base", 4, 16, this._width * 0.75, this._length);
        base.getMeshData().rotatePoints(rotator);
        base.getMeshData().rotateNormals(rotator);
        this.attachChild(base);
        base.updateModelBound();
        Pyramid tip = new Pyramid("tip", 2.0 * this._width, this._length / 2.0);
        tip.getMeshData().translatePoints(0.0, this._length * 0.75, 0.0);
        this.attachChild(tip);
        tip.updateModelBound();
    }

    public double getLength() {
        return this._length;
    }

    public void setLength(double length) {
        this._length = length;
    }

    public double getWidth() {
        return this._width;
    }

    public void setWidth(double width) {
        this._width = width;
    }

    public void setSolidColor(ReadOnlyColorRGBA color) {
        for (int x = 0; x < this.getNumberOfChildren(); ++x) {
            if (!(this.getChild(x) instanceof Mesh)) continue;
            ((Mesh)this.getChild(x)).setSolidColor(color);
        }
    }

    public void setDefaultColor(ReadOnlyColorRGBA color) {
        for (int x = 0; x < this.getNumberOfChildren(); ++x) {
            if (!(this.getChild(x) instanceof Mesh)) continue;
            ((Mesh)this.getChild(x)).setDefaultColor(color);
        }
    }

    @Override
    public void write(OutputCapsule capsule) throws IOException {
        super.write(capsule);
        capsule.write(this._length, "length", 1.0);
        capsule.write(this._width, "width", 0.25);
    }

    @Override
    public void read(InputCapsule capsule) throws IOException {
        super.read(capsule);
        this._length = capsule.readDouble("length", 1.0);
        this._width = capsule.readDouble("width", 0.25);
    }
}

