/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.scenegraph.shape;

import com.ardor3d.math.ColorRGBA;
import com.ardor3d.math.Matrix3;
import com.ardor3d.math.type.ReadOnlyColorRGBA;
import com.ardor3d.math.type.ReadOnlyMatrix3;
import com.ardor3d.scenegraph.Node;
import com.ardor3d.scenegraph.hint.LightCombineMode;
import com.ardor3d.scenegraph.hint.TextureCombineMode;
import com.ardor3d.scenegraph.shape.Arrow;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import java.io.IOException;

public class AxisRods
extends Node {
    protected static final ColorRGBA xAxisColor = new ColorRGBA(1.0f, 0.0f, 0.0f, 0.4f);
    protected static final ColorRGBA yAxisColor = new ColorRGBA(0.0f, 1.0f, 0.0f, 0.25f);
    protected static final ColorRGBA zAxisColor = new ColorRGBA(0.0f, 0.0f, 1.0f, 0.4f);
    protected double length;
    protected double width;
    protected boolean rightHanded;
    protected Arrow xAxis;
    protected Arrow yAxis;
    protected Arrow zAxis;

    public AxisRods() {
    }

    public AxisRods(String name) {
        this(name, true, 1.0);
    }

    public AxisRods(String name, boolean rightHanded, double baseScale) {
        this(name, rightHanded, baseScale, baseScale * 0.125);
    }

    public AxisRods(String name, boolean rightHanded, double length, double width) {
        super(name);
        this.length = length;
        this.width = width;
        this.rightHanded = rightHanded;
        this.getSceneHints().setLightCombineMode(LightCombineMode.Off);
        this.getSceneHints().setTextureCombineMode(TextureCombineMode.Off);
        this.buildAxis();
    }

    protected void buildAxis() {
        this.xAxis = new Arrow("_xAxis", this.length, this.width);
        this.xAxis.setDefaultColor((ReadOnlyColorRGBA)xAxisColor);
        this.xAxis.setRotation((ReadOnlyMatrix3)new Matrix3().fromAngles(0.0, 0.0, -1.5707963267948966));
        this.xAxis.setTranslation(this.length * 0.5, 0.0, 0.0);
        this.attachChild(this.xAxis);
        this.yAxis = new Arrow("yAxis", this.length, this.width);
        this.yAxis.setDefaultColor((ReadOnlyColorRGBA)yAxisColor);
        this.yAxis.setTranslation(0.0, this.length * 0.5, 0.0);
        this.attachChild(this.yAxis);
        this.zAxis = new Arrow("zAxis", this.length, this.width);
        this.zAxis.setDefaultColor((ReadOnlyColorRGBA)zAxisColor);
        if (this.rightHanded) {
            this.zAxis.setRotation((ReadOnlyMatrix3)new Matrix3().fromAngles(1.5707963267948966, 0.0, 0.0));
            this.zAxis.setTranslation(0.0, 0.0, this.length * 0.5);
        } else {
            this.zAxis.setRotation((ReadOnlyMatrix3)new Matrix3().fromAngles(-1.5707963267948966, 0.0, 0.0));
            this.zAxis.setTranslation(0.0, 0.0, -this.length * 0.5);
        }
        this.attachChild(this.zAxis);
    }

    @Override
    public void write(OutputCapsule capsule) throws IOException {
        super.write(capsule);
        capsule.write(this.length, "length", 1.0);
        capsule.write(this.width, "width", 0.125);
        capsule.write(this.rightHanded, "rightHanded", true);
    }

    @Override
    public void read(InputCapsule capsule) throws IOException {
        super.read(capsule);
        this.length = capsule.readDouble("length", 1.0);
        this.width = capsule.readDouble("width", 0.125);
        this.rightHanded = capsule.readBoolean("rightHanded", true);
        this.buildAxis();
    }

    public double getLength() {
        return this.length;
    }

    public void setLength(double length) {
        this.length = length;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public Arrow getxAxis() {
        return this.xAxis;
    }

    public Arrow getyAxis() {
        return this.yAxis;
    }

    public Arrow getzAxis() {
        return this.zAxis;
    }
}

