/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.scenegraph.shape;

import com.ardor3d.math.Vector3;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.scenegraph.Mesh;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.export.Savable;
import com.ardor3d.util.geom.BufferUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;

public class Box
extends Mesh {
    private double _xExtent;
    private double _yExtent;
    private double _zExtent;
    private final Vector3 _center = new Vector3(0.0, 0.0, 0.0);

    public Box() {
        this("unnamed Box");
    }

    public Box(String name) {
        super(name);
        this.setData(Vector3.ZERO, 0.5, 0.5, 0.5);
    }

    public Box(String name, ReadOnlyVector3 pntA, ReadOnlyVector3 pntB) {
        super(name);
        this.setData(pntA, pntB);
    }

    public Box(String name, ReadOnlyVector3 center, double xExtent, double yExtent, double zExtent) {
        super(name);
        this.setData(center, xExtent, yExtent, zExtent);
    }

    public ReadOnlyVector3 getCenter() {
        return this._center;
    }

    public double getXExtent() {
        return this._xExtent;
    }

    public double getYExtent() {
        return this._yExtent;
    }

    public double getZExtent() {
        return this._zExtent;
    }

    public void setData(ReadOnlyVector3 pntA, ReadOnlyVector3 pntB) {
        this._center.set(pntB).addLocal(pntA).multiplyLocal(0.5);
        double x = Math.abs(pntB.getX() - this._center.getX());
        double y = Math.abs(pntB.getY() - this._center.getY());
        double z = Math.abs(pntB.getZ() - this._center.getZ());
        this.setData((ReadOnlyVector3)this._center, x, y, z);
    }

    public void setData(ReadOnlyVector3 center, double xExtent, double yExtent, double zExtent) {
        if (center != null) {
            this._center.set(center);
        }
        this._xExtent = xExtent;
        this._yExtent = yExtent;
        this._zExtent = zExtent;
        this.setVertexData();
        this.setNormalData();
        this.setTextureData();
        this.setIndexData();
    }

    protected void setVertexData() {
        if (this._meshData.getVertexBuffer() == null) {
            this._meshData.setVertexBuffer(BufferUtils.createVector3Buffer(24));
        }
        Vector3[] vert = this.computeVertices();
        BufferUtils.setInBuffer((ReadOnlyVector3)vert[0], this._meshData.getVertexBuffer(), 0);
        BufferUtils.setInBuffer((ReadOnlyVector3)vert[1], this._meshData.getVertexBuffer(), 1);
        BufferUtils.setInBuffer((ReadOnlyVector3)vert[2], this._meshData.getVertexBuffer(), 2);
        BufferUtils.setInBuffer((ReadOnlyVector3)vert[3], this._meshData.getVertexBuffer(), 3);
        BufferUtils.setInBuffer((ReadOnlyVector3)vert[1], this._meshData.getVertexBuffer(), 4);
        BufferUtils.setInBuffer((ReadOnlyVector3)vert[4], this._meshData.getVertexBuffer(), 5);
        BufferUtils.setInBuffer((ReadOnlyVector3)vert[6], this._meshData.getVertexBuffer(), 6);
        BufferUtils.setInBuffer((ReadOnlyVector3)vert[2], this._meshData.getVertexBuffer(), 7);
        BufferUtils.setInBuffer((ReadOnlyVector3)vert[4], this._meshData.getVertexBuffer(), 8);
        BufferUtils.setInBuffer((ReadOnlyVector3)vert[5], this._meshData.getVertexBuffer(), 9);
        BufferUtils.setInBuffer((ReadOnlyVector3)vert[7], this._meshData.getVertexBuffer(), 10);
        BufferUtils.setInBuffer((ReadOnlyVector3)vert[6], this._meshData.getVertexBuffer(), 11);
        BufferUtils.setInBuffer((ReadOnlyVector3)vert[5], this._meshData.getVertexBuffer(), 12);
        BufferUtils.setInBuffer((ReadOnlyVector3)vert[0], this._meshData.getVertexBuffer(), 13);
        BufferUtils.setInBuffer((ReadOnlyVector3)vert[3], this._meshData.getVertexBuffer(), 14);
        BufferUtils.setInBuffer((ReadOnlyVector3)vert[7], this._meshData.getVertexBuffer(), 15);
        BufferUtils.setInBuffer((ReadOnlyVector3)vert[2], this._meshData.getVertexBuffer(), 16);
        BufferUtils.setInBuffer((ReadOnlyVector3)vert[6], this._meshData.getVertexBuffer(), 17);
        BufferUtils.setInBuffer((ReadOnlyVector3)vert[7], this._meshData.getVertexBuffer(), 18);
        BufferUtils.setInBuffer((ReadOnlyVector3)vert[3], this._meshData.getVertexBuffer(), 19);
        BufferUtils.setInBuffer((ReadOnlyVector3)vert[0], this._meshData.getVertexBuffer(), 20);
        BufferUtils.setInBuffer((ReadOnlyVector3)vert[5], this._meshData.getVertexBuffer(), 21);
        BufferUtils.setInBuffer((ReadOnlyVector3)vert[4], this._meshData.getVertexBuffer(), 22);
        BufferUtils.setInBuffer((ReadOnlyVector3)vert[1], this._meshData.getVertexBuffer(), 23);
    }

    private void setNormalData() {
        if (this._meshData.getNormalBuffer() == null) {
            int i;
            this._meshData.setNormalBuffer(BufferUtils.createVector3Buffer(24));
            for (i = 0; i < 4; ++i) {
                this._meshData.getNormalBuffer().put(0.0f).put(0.0f).put(-1.0f);
            }
            for (i = 0; i < 4; ++i) {
                this._meshData.getNormalBuffer().put(1.0f).put(0.0f).put(0.0f);
            }
            for (i = 0; i < 4; ++i) {
                this._meshData.getNormalBuffer().put(0.0f).put(0.0f).put(1.0f);
            }
            for (i = 0; i < 4; ++i) {
                this._meshData.getNormalBuffer().put(-1.0f).put(0.0f).put(0.0f);
            }
            for (i = 0; i < 4; ++i) {
                this._meshData.getNormalBuffer().put(0.0f).put(1.0f).put(0.0f);
            }
            for (i = 0; i < 4; ++i) {
                this._meshData.getNormalBuffer().put(0.0f).put(-1.0f).put(0.0f);
            }
            this._meshData.getNormalBuffer().rewind();
        }
    }

    private void setTextureData() {
        if (this._meshData.getTextureCoords(0) == null) {
            this._meshData.setTextureBuffer(BufferUtils.createVector2Buffer(24), 0);
            FloatBuffer tex = this._meshData.getTextureBuffer(0);
            for (int i = 0; i < 6; ++i) {
                tex.put(1.0f).put(0.0f);
                tex.put(0.0f).put(0.0f);
                tex.put(0.0f).put(1.0f);
                tex.put(1.0f).put(1.0f);
            }
            tex.rewind();
        }
    }

    private void setIndexData() {
        if (this._meshData.getIndices() == null) {
            byte[] indices = new byte[]{2, 1, 0, 3, 2, 0, 6, 5, 4, 7, 6, 4, 10, 9, 8, 11, 10, 8, 14, 13, 12, 15, 14, 12, 18, 17, 16, 19, 18, 16, 22, 21, 20, 23, 22, 20};
            ByteBuffer buf = BufferUtils.createByteBuffer(indices.length);
            buf.put(indices);
            buf.rewind();
            this._meshData.setIndexBuffer(buf);
        }
    }

    public Box clone() {
        return new Box(this.getName() + "_clone", (ReadOnlyVector3)this._center.clone(), this._xExtent, this._yExtent, this._zExtent);
    }

    public Vector3[] computeVertices() {
        Vector3[] rVal = new Vector3[]{this._center.add(-this._xExtent, -this._yExtent, -this._zExtent, null), this._center.add(this._xExtent, -this._yExtent, -this._zExtent, null), this._center.add(this._xExtent, this._yExtent, -this._zExtent, null), this._center.add(-this._xExtent, this._yExtent, -this._zExtent, null), this._center.add(this._xExtent, -this._yExtent, this._zExtent, null), this._center.add(-this._xExtent, -this._yExtent, this._zExtent, null), this._center.add(this._xExtent, this._yExtent, this._zExtent, null), this._center.add(-this._xExtent, this._yExtent, this._zExtent, null)};
        return rVal;
    }

    @Override
    public void write(OutputCapsule capsule) throws IOException {
        super.write(capsule);
        capsule.write(this._xExtent, "xExtent", 0.0);
        capsule.write(this._yExtent, "yExtent", 0.0);
        capsule.write(this._zExtent, "zExtent", 0.0);
        capsule.write((Savable)this._center, "center", (Savable)new Vector3(Vector3.ZERO));
    }

    @Override
    public void read(InputCapsule capsule) throws IOException {
        super.read(capsule);
        this._xExtent = capsule.readDouble("xExtent", 0.0);
        this._yExtent = capsule.readDouble("yExtent", 0.0);
        this._zExtent = capsule.readDouble("zExtent", 0.0);
        this._center.set((ReadOnlyVector3)((Vector3)capsule.readSavable("center", (Savable)new Vector3(Vector3.ZERO))));
    }
}

