/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.scenegraph.shape;

import com.ardor3d.math.MathUtils;
import com.ardor3d.math.Matrix3;
import com.ardor3d.math.Vector3;
import com.ardor3d.math.type.ReadOnlyMatrix3;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.scenegraph.Mesh;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.geom.BufferUtils;
import java.io.IOException;
import java.nio.FloatBuffer;

public class Capsule
extends Mesh {
    private int axisSamples;
    private int radialSamples;
    private int sphereSamples;
    private double radius;
    private double height;

    public Capsule() {
    }

    public Capsule(String name, int axisSamples, int radialSamples, int sphereSamples, double radius, double height) {
        super(name);
        this.axisSamples = axisSamples;
        this.sphereSamples = sphereSamples;
        this.radialSamples = radialSamples;
        this.radius = radius;
        this.height = height;
        this.recreateBuffers();
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
        this.recreateBuffers();
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
        this.setGeometryData();
    }

    private void recreateBuffers() {
        int sampleLines = 2 * this.sphereSamples - 1 + this.axisSamples;
        int verts = (this.radialSamples + 1) * sampleLines + 2;
        this._meshData.setVertexBuffer(BufferUtils.createVector3Buffer(this._meshData.getVertexBuffer(), verts));
        this._meshData.setNormalBuffer(BufferUtils.createVector3Buffer(this._meshData.getNormalBuffer(), verts));
        this._meshData.setTextureBuffer(BufferUtils.createVector2Buffer(verts), 0);
        int tris = 2 * this.radialSamples * sampleLines;
        if (this._meshData.getIndices() == null || this._meshData.getIndices().getBufferLimit() != 3 * tris) {
            this._meshData.setIndices(BufferUtils.createIndexBufferData(3 * tris, verts - 1));
        }
        this.setGeometryData();
        this.setIndexData();
    }

    private void setGeometryData() {
        double radialFraction;
        Vector3 kRadial;
        double lengthFraction;
        double center;
        int i;
        FloatBuffer verts = this._meshData.getVertexBuffer();
        FloatBuffer norms = this._meshData.getNormalBuffer();
        FloatBuffer texs = this._meshData.getTextureBuffer(0);
        verts.rewind();
        norms.rewind();
        texs.rewind();
        double inverseRadial = 1.0 / (double)this.radialSamples;
        double inverseSphere = 1.0 / (double)this.sphereSamples;
        double halfHeight = 0.5 * this.height;
        double[] sin = new double[this.radialSamples + 1];
        double[] cos = new double[this.radialSamples + 1];
        for (int radialCount = 0; radialCount < this.radialSamples; ++radialCount) {
            double angle = Math.PI * 2 * inverseRadial * (double)radialCount;
            cos[radialCount] = MathUtils.cos((double)angle);
            sin[radialCount] = MathUtils.sin((double)angle);
        }
        sin[this.radialSamples] = sin[0];
        cos[this.radialSamples] = cos[0];
        Vector3 tempA = new Vector3();
        verts.put(0.0f).put((float)(this.radius + halfHeight)).put(0.0f);
        norms.put(0.0f).put(1.0f).put(0.0f);
        texs.put(1.0f).put(1.0f);
        for (i = 0; i < this.sphereSamples; ++i) {
            center = this.radius * (1.0 - (double)(i + 1) * inverseSphere);
            lengthFraction = (center + this.height + this.radius) / (this.height + 2.0 * this.radius);
            double fSliceRadius = Math.sqrt(Math.abs(this.radius * this.radius - center * center));
            for (int j = 0; j <= this.radialSamples; ++j) {
                kRadial = tempA.set(cos[j], 0.0, sin[j]);
                kRadial.multiplyLocal(fSliceRadius);
                verts.put(kRadial.getXf()).put((float)(center + halfHeight)).put(kRadial.getZf());
                kRadial.setY(center);
                kRadial.normalizeLocal();
                norms.put(kRadial.getXf()).put(kRadial.getYf()).put(kRadial.getZf());
                radialFraction = 1.0 - (double)j * inverseRadial;
                texs.put((float)radialFraction).put((float)lengthFraction);
            }
        }
        for (i = 1; i < this.axisSamples; ++i) {
            center = halfHeight - (double)i * this.height / (double)this.axisSamples;
            lengthFraction = (center + halfHeight + this.radius) / (this.height + 2.0 * this.radius);
            for (int j = 0; j <= this.radialSamples; ++j) {
                Vector3 kRadial2 = tempA.set(cos[j], 0.0, sin[j]);
                kRadial2.multiplyLocal(this.radius);
                verts.put(kRadial2.getXf()).put((float)center).put(kRadial2.getZf());
                kRadial2.normalizeLocal();
                norms.put(kRadial2.getXf()).put(kRadial2.getYf()).put(kRadial2.getZf());
                double radialFraction2 = 1.0 - (double)j * inverseRadial;
                texs.put((float)radialFraction2).put((float)lengthFraction);
            }
        }
        for (i = 0; i < this.sphereSamples; ++i) {
            center = (double)i * (this.radius / (double)this.sphereSamples);
            lengthFraction = (this.radius - center) / (this.height + 2.0 * this.radius);
            double fSliceRadius = Math.sqrt(Math.abs(this.radius * this.radius - center * center));
            for (int j = 0; j <= this.radialSamples; ++j) {
                kRadial = tempA.set(cos[j], 0.0, sin[j]);
                kRadial.multiplyLocal(fSliceRadius);
                verts.put(kRadial.getXf()).put((float)(-center - halfHeight)).put(kRadial.getZf());
                kRadial.setY(-center);
                kRadial.normalizeLocal();
                norms.put(kRadial.getXf()).put(kRadial.getYf()).put(kRadial.getZf());
                radialFraction = 1.0 - (double)j * inverseRadial;
                texs.put((float)radialFraction).put((float)lengthFraction);
            }
        }
        verts.put(0.0f).put((float)(-this.radius - halfHeight)).put(0.0f);
        norms.put(0.0f).put(-1.0f).put(0.0f);
        texs.put(0.0f).put(0.0f);
    }

    private void setIndexData() {
        int sample;
        int bottomPlaneStart;
        int topPlaneStart;
        int plane;
        this._meshData.getIndices().rewind();
        for (int samples = 1; samples <= this.radialSamples; ++samples) {
            this._meshData.getIndices().put(samples + 1);
            this._meshData.getIndices().put(samples);
            this._meshData.getIndices().put(0);
        }
        for (int plane2 = 1; plane2 < this.sphereSamples; ++plane2) {
            int topPlaneStart2 = plane2 * (this.radialSamples + 1);
            int bottomPlaneStart2 = (plane2 - 1) * (this.radialSamples + 1);
            for (int sample2 = 1; sample2 <= this.radialSamples; ++sample2) {
                this._meshData.getIndices().put(bottomPlaneStart2 + sample2);
                this._meshData.getIndices().put(bottomPlaneStart2 + sample2 + 1);
                this._meshData.getIndices().put(topPlaneStart2 + sample2);
                this._meshData.getIndices().put(bottomPlaneStart2 + sample2 + 1);
                this._meshData.getIndices().put(topPlaneStart2 + sample2 + 1);
                this._meshData.getIndices().put(topPlaneStart2 + sample2);
            }
        }
        int start = this.sphereSamples * (this.radialSamples + 1);
        for (plane = 0; plane < this.axisSamples; ++plane) {
            topPlaneStart = start + plane * (this.radialSamples + 1);
            bottomPlaneStart = start + (plane - 1) * (this.radialSamples + 1);
            for (sample = 1; sample <= this.radialSamples; ++sample) {
                this._meshData.getIndices().put(bottomPlaneStart + sample);
                this._meshData.getIndices().put(bottomPlaneStart + sample + 1);
                this._meshData.getIndices().put(topPlaneStart + sample);
                this._meshData.getIndices().put(bottomPlaneStart + sample + 1);
                this._meshData.getIndices().put(topPlaneStart + sample + 1);
                this._meshData.getIndices().put(topPlaneStart + sample);
            }
        }
        start += (this.axisSamples - 1) * (this.radialSamples + 1);
        for (plane = 1; plane < this.sphereSamples; ++plane) {
            topPlaneStart = start + plane * (this.radialSamples + 1);
            bottomPlaneStart = start + (plane - 1) * (this.radialSamples + 1);
            for (sample = 1; sample <= this.radialSamples; ++sample) {
                this._meshData.getIndices().put(bottomPlaneStart + sample);
                this._meshData.getIndices().put(bottomPlaneStart + sample + 1);
                this._meshData.getIndices().put(topPlaneStart + sample);
                this._meshData.getIndices().put(bottomPlaneStart + sample + 1);
                this._meshData.getIndices().put(topPlaneStart + sample + 1);
                this._meshData.getIndices().put(topPlaneStart + sample);
            }
        }
        start += (this.sphereSamples - 1) * (this.radialSamples + 1);
        for (int samples = 1; samples <= this.radialSamples; ++samples) {
            this._meshData.getIndices().put(start + samples);
            this._meshData.getIndices().put(start + samples + 1);
            this._meshData.getIndices().put(start + this.radialSamples + 2);
        }
    }

    public void reconstruct(Vector3 top, Vector3 bottom, double radius) {
        Vector3 localTranslation = Vector3.fetchTempInstance();
        Vector3 capsuleUp = Vector3.fetchTempInstance();
        this.height = top.distance((ReadOnlyVector3)bottom);
        this.radius = radius;
        this.setGeometryData();
        localTranslation.set(this._localTransform.getTranslation());
        top.add((ReadOnlyVector3)bottom, localTranslation).multiplyLocal(0.5);
        top.subtract((ReadOnlyVector3)localTranslation, capsuleUp).normalizeLocal();
        Matrix3 rotation = Matrix3.fetchTempInstance();
        rotation.fromStartEndLocal(Vector3.UNIT_Y, (ReadOnlyVector3)capsuleUp);
        this._localTransform.setRotation((ReadOnlyMatrix3)rotation);
        Vector3.releaseTempInstance((Vector3)localTranslation);
        Vector3.releaseTempInstance((Vector3)capsuleUp);
        Matrix3.releaseTempInstance((Matrix3)rotation);
        this.updateWorldTransform(false);
    }

    @Override
    public void write(OutputCapsule capsule) throws IOException {
        super.write(capsule);
        capsule.write(this.axisSamples, "axisSamples", 0);
        capsule.write(this.radialSamples, "radialSamples", 0);
        capsule.write(this.sphereSamples, "sphereSamples", 0);
        capsule.write(this.radius, "radius", 0.0);
        capsule.write(this.height, "height", 0.0);
    }

    @Override
    public void read(InputCapsule capsule) throws IOException {
        super.read(capsule);
        this.axisSamples = capsule.readInt("circleSamples", 0);
        this.radialSamples = capsule.readInt("radialSamples", 0);
        this.sphereSamples = capsule.readInt("sphereSamples", 0);
        this.radius = capsule.readDouble("radius", 0.0);
        this.height = capsule.readDouble("height", 0.0);
    }
}

