/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.scenegraph.shape;

import com.ardor3d.math.MathUtils;
import com.ardor3d.math.Vector3;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.scenegraph.Mesh;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.geom.BufferUtils;
import java.io.IOException;
import java.nio.FloatBuffer;

public class Cylinder
extends Mesh {
    private int _axisSamples;
    private int _radialSamples;
    private double _radius;
    private double _radius2;
    private double _height;
    private boolean _closed;
    private boolean _inverted;

    public Cylinder() {
    }

    public Cylinder(String name, int axisSamples, int radialSamples, double radius, double height) {
        this(name, axisSamples, radialSamples, radius, height, false);
    }

    public Cylinder(String name, int axisSamples, int radialSamples, double radius, double height, boolean closed) {
        this(name, axisSamples, radialSamples, radius, height, closed, false);
    }

    public Cylinder(String name, int axisSamples, int radialSamples, double radius, double height, boolean closed, boolean inverted) {
        super(name);
        this._axisSamples = axisSamples + (closed ? 2 : 0);
        this._radialSamples = radialSamples;
        this.setRadius(radius);
        this._height = height;
        this._closed = closed;
        this._inverted = inverted;
        this.allocateVertices();
    }

    public double getHeight() {
        return this._height;
    }

    public void setHeight(double height) {
        this._height = height;
        this.allocateVertices();
    }

    public double getRadius() {
        return this._radius;
    }

    public void setRadius(double radius) {
        this._radius = radius;
        this._radius2 = radius;
        this.allocateVertices();
    }

    public void setRadius1(double radius) {
        this._radius = radius;
        this.allocateVertices();
    }

    public void setRadius2(double radius) {
        this._radius2 = radius;
        this.allocateVertices();
    }

    public int getAxisSamples() {
        return this._axisSamples;
    }

    public boolean isClosed() {
        return this._closed;
    }

    public boolean isInverted() {
        return this._inverted;
    }

    public int getRadialSamples() {
        return this._radialSamples;
    }

    private void allocateVertices() {
        int verts = this._axisSamples * (this._radialSamples + 1) + (this._closed ? 2 : 0);
        this._meshData.setVertexBuffer(BufferUtils.createVector3Buffer(this._meshData.getVertexBuffer(), verts));
        this._meshData.setNormalBuffer(BufferUtils.createVector3Buffer(this._meshData.getNormalBuffer(), verts));
        this._meshData.setTextureBuffer(BufferUtils.createVector2Buffer(verts), 0);
        int count = ((this._closed ? 2 : 0) + 2 * (this._axisSamples - 1)) * this._radialSamples;
        if (this._meshData.getIndices() == null || this._meshData.getIndices().getBufferLimit() != 3 * count) {
            this._meshData.setIndices(BufferUtils.createIndexBufferData(3 * count, verts - 1));
        }
        this.setGeometryData();
        this.setIndexData();
    }

    private void setGeometryData() {
        double inverseRadial = 1.0 / (double)this._radialSamples;
        double inverseAxisLess = 1.0 / (double)(this._closed ? this._axisSamples - 3 : this._axisSamples - 1);
        double inverseAxisLessTexture = 1.0 / (double)(this._axisSamples - 1);
        double halfHeight = 0.5 * this._height;
        double[] sin = new double[this._radialSamples + 1];
        double[] cos = new double[this._radialSamples + 1];
        for (int radialCount = 0; radialCount < this._radialSamples; ++radialCount) {
            double angle = Math.PI * 2 * inverseRadial * (double)radialCount;
            cos[radialCount] = MathUtils.cos((double)angle);
            sin[radialCount] = MathUtils.sin((double)angle);
        }
        sin[this._radialSamples] = sin[0];
        cos[this._radialSamples] = cos[0];
        Vector3 tempNormal = new Vector3();
        int i = 0;
        for (int axisCount = 0; axisCount < this._axisSamples; ++axisCount) {
            double axisFractionTexture;
            double axisFraction;
            int topBottom = 0;
            if (!this._closed) {
                axisFractionTexture = axisFraction = (double)axisCount * inverseAxisLess;
            } else if (axisCount == 0) {
                topBottom = -1;
                axisFraction = 0.0;
                axisFractionTexture = inverseAxisLessTexture;
            } else if (axisCount == this._axisSamples - 1) {
                topBottom = 1;
                axisFraction = 1.0;
                axisFractionTexture = 1.0 - inverseAxisLessTexture;
            } else {
                axisFraction = (double)(axisCount - 1) * inverseAxisLess;
                axisFractionTexture = (double)axisCount * inverseAxisLessTexture;
            }
            double z = -halfHeight + this._height * axisFraction;
            Vector3 sliceCenter = new Vector3(0.0, 0.0, z);
            int save = i;
            for (int radialCount = 0; radialCount < this._radialSamples; ++radialCount) {
                double radialFraction = (double)radialCount * inverseRadial;
                tempNormal.set(cos[radialCount], sin[radialCount], 0.0);
                if (topBottom == 0) {
                    if (!this._inverted) {
                        this._meshData.getNormalBuffer().put(tempNormal.getXf()).put(tempNormal.getYf()).put(tempNormal.getZf());
                    } else {
                        this._meshData.getNormalBuffer().put(-tempNormal.getXf()).put(-tempNormal.getYf()).put(-tempNormal.getZf());
                    }
                } else {
                    this._meshData.getNormalBuffer().put(0.0f).put(0.0f).put(topBottom * (this._inverted ? -1 : 1));
                }
                tempNormal.multiplyLocal((this._radius - this._radius2) * axisFraction + this._radius2).addLocal((ReadOnlyVector3)sliceCenter);
                this._meshData.getVertexBuffer().put(tempNormal.getXf()).put(tempNormal.getYf()).put(tempNormal.getZf());
                ((FloatBuffer)this._meshData.getTextureCoords(0).getBuffer()).put((float)(this._inverted ? 1.0 - radialFraction : radialFraction)).put((float)axisFractionTexture);
                ++i;
            }
            BufferUtils.copyInternalVector3(this._meshData.getVertexBuffer(), save, i);
            BufferUtils.copyInternalVector3(this._meshData.getNormalBuffer(), save, i);
            ((FloatBuffer)this._meshData.getTextureCoords(0).getBuffer()).put(this._inverted ? 0.0f : 1.0f).put((float)axisFractionTexture);
            ++i;
        }
        if (this._closed) {
            this._meshData.getVertexBuffer().put(0.0f).put(0.0f).put((float)(-halfHeight));
            this._meshData.getNormalBuffer().put(0.0f).put(0.0f).put(-1 * (this._inverted ? -1 : 1));
            ((FloatBuffer)this._meshData.getTextureCoords(0).getBuffer()).put(0.5f).put(0.0f);
            this._meshData.getVertexBuffer().put(0.0f).put(0.0f).put((float)halfHeight);
            this._meshData.getNormalBuffer().put(0.0f).put(0.0f).put(1 * (this._inverted ? -1 : 1));
            ((FloatBuffer)this._meshData.getTextureCoords(0).getBuffer()).put(0.5f).put(1.0f);
        }
    }

    private void setIndexData() {
        this._meshData.getIndices().rewind();
        int axisStart = 0;
        for (int axisCount = 0; axisCount < this._axisSamples - 1; ++axisCount) {
            int i0 = axisStart;
            int i1 = i0 + 1;
            int i2 = axisStart += this._radialSamples + 1;
            int i3 = i2 + 1;
            for (int i = 0; i < this._radialSamples; ++i) {
                if (this._closed && axisCount == 0) {
                    if (!this._inverted) {
                        this._meshData.getIndices().put(i0++);
                        this._meshData.getIndices().put(this._meshData.getVertexCount() - 2);
                        this._meshData.getIndices().put(i1++);
                        continue;
                    }
                    this._meshData.getIndices().put(i0++);
                    this._meshData.getIndices().put(i1++);
                    this._meshData.getIndices().put(this._meshData.getVertexCount() - 2);
                    continue;
                }
                if (this._closed && axisCount == this._axisSamples - 2) {
                    if (!this._inverted) {
                        this._meshData.getIndices().put(i2++);
                        this._meshData.getIndices().put(i3++);
                        this._meshData.getIndices().put(this._meshData.getVertexCount() - 1);
                        continue;
                    }
                    this._meshData.getIndices().put(i2++);
                    this._meshData.getIndices().put(this._meshData.getVertexCount() - 1);
                    this._meshData.getIndices().put(i3++);
                    continue;
                }
                if (!this._inverted) {
                    this._meshData.getIndices().put(i0++);
                    this._meshData.getIndices().put(i1);
                    this._meshData.getIndices().put(i2);
                    this._meshData.getIndices().put(i1++);
                    this._meshData.getIndices().put(i3++);
                    this._meshData.getIndices().put(i2++);
                    continue;
                }
                this._meshData.getIndices().put(i0++);
                this._meshData.getIndices().put(i2);
                this._meshData.getIndices().put(i1);
                this._meshData.getIndices().put(i1++);
                this._meshData.getIndices().put(i2++);
                this._meshData.getIndices().put(i3++);
            }
        }
    }

    @Override
    public void write(OutputCapsule capsule) throws IOException {
        super.write(capsule);
        capsule.write(this._axisSamples, "axisSamples", 0);
        capsule.write(this._radialSamples, "radialSamples", 0);
        capsule.write(this._radius, "radius", 0.0);
        capsule.write(this._radius2, "radius2", 0.0);
        capsule.write(this._height, "height", 0.0);
        capsule.write(this._closed, "closed", false);
        capsule.write(this._inverted, "inverted", false);
    }

    @Override
    public void read(InputCapsule capsule) throws IOException {
        super.read(capsule);
        this._axisSamples = capsule.readInt("axisSamples", 0);
        this._radialSamples = capsule.readInt("radialSamples", 0);
        this._radius = capsule.readDouble("radius", 0.0);
        this._radius2 = capsule.readDouble("radius2", 0.0);
        this._height = capsule.readDouble("height", 0.0);
        this._closed = capsule.readBoolean("closed", false);
        this._inverted = capsule.readBoolean("inverted", false);
    }
}

