/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.scenegraph.shape;

import com.ardor3d.math.MathUtils;
import com.ardor3d.math.Vector2;
import com.ardor3d.math.Vector3;
import com.ardor3d.math.type.ReadOnlyVector2;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.scenegraph.Mesh;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.geom.BufferUtils;
import java.io.IOException;
import java.nio.FloatBuffer;

public class Disk
extends Mesh {
    private int _shellSamples;
    private int _radialSamples;
    private double _radius;

    public Disk() {
    }

    public Disk(String name, int shellSamples, int radialSamples, double radius) {
        super(name);
        this._shellSamples = shellSamples;
        this._radialSamples = radialSamples;
        this._radius = radius;
        int radialless = radialSamples - 1;
        int shellLess = shellSamples - 1;
        int verts = 1 + radialSamples * shellLess;
        this._meshData.setVertexBuffer(BufferUtils.createVector3Buffer(verts));
        this._meshData.setNormalBuffer(BufferUtils.createVector3Buffer(verts));
        this._meshData.setTextureBuffer(BufferUtils.createVector2Buffer(verts), 0);
        int tris = radialSamples * (2 * shellLess - 1);
        this._meshData.setIndices(BufferUtils.createIndexBufferData(3 * tris, verts - 1));
        this.setGeometryData(shellLess);
        this.setIndexData(radialless, shellLess);
    }

    private void setGeometryData(int shellLess) {
        this._meshData.getVertexBuffer().put(0.0f).put(0.0f).put(0.0f);
        for (int x = 0; x < this._meshData.getVertexCount(); ++x) {
            this._meshData.getNormalBuffer().put(0.0f).put(0.0f).put(1.0f);
        }
        ((FloatBuffer)this._meshData.getTextureCoords(0).getBuffer()).put(0.5f).put(0.5f);
        double inverseShellLess = 1.0 / (double)shellLess;
        double inverseRadial = 1.0 / (double)this._radialSamples;
        Vector3 radialFraction = new Vector3();
        Vector2 texCoord = new Vector2();
        for (int radialCount = 0; radialCount < this._radialSamples; ++radialCount) {
            double angle = Math.PI * 2 * inverseRadial * (double)radialCount;
            double cos = MathUtils.cos((double)angle);
            double sin = MathUtils.sin((double)angle);
            Vector3 radial = new Vector3(cos, sin, 0.0);
            for (int shellCount = 1; shellCount < this._shellSamples; ++shellCount) {
                double fraction = inverseShellLess * (double)shellCount;
                radialFraction.set((ReadOnlyVector3)radial).multiplyLocal(fraction);
                int i = shellCount + shellLess * radialCount;
                texCoord.setX(0.5 * (1.0 + radialFraction.getX()));
                texCoord.setY(0.5 * (1.0 + radialFraction.getY()));
                BufferUtils.setInBuffer((ReadOnlyVector2)texCoord, (FloatBuffer)this._meshData.getTextureCoords(0).getBuffer(), i);
                radialFraction.multiplyLocal(this._radius);
                BufferUtils.setInBuffer((ReadOnlyVector3)radialFraction, this._meshData.getVertexBuffer(), i);
            }
        }
    }

    private void setIndexData(int radialless, int shellLess) {
        int radialCount0 = radialless;
        int radialCount1 = 0;
        while (radialCount1 < this._radialSamples) {
            this._meshData.getIndices().put(0);
            this._meshData.getIndices().put(1 + shellLess * radialCount0);
            this._meshData.getIndices().put(1 + shellLess * radialCount1);
            for (int iS = 1; iS < shellLess; ++iS) {
                int i00 = iS + shellLess * radialCount0;
                int i01 = iS + shellLess * radialCount1;
                int i10 = i00 + 1;
                int i11 = i01 + 1;
                this._meshData.getIndices().put(i00);
                this._meshData.getIndices().put(i10);
                this._meshData.getIndices().put(i11);
                this._meshData.getIndices().put(i00);
                this._meshData.getIndices().put(i11);
                this._meshData.getIndices().put(i01);
            }
            radialCount0 = radialCount1++;
        }
    }

    @Override
    public void write(OutputCapsule capsule) throws IOException {
        super.write(capsule);
        capsule.write(this._shellSamples, "shellSamples", 0);
        capsule.write(this._radialSamples, "radialSamples", 0);
        capsule.write(this._radius, "radius", 0.0);
    }

    @Override
    public void read(InputCapsule capsule) throws IOException {
        super.read(capsule);
        this._shellSamples = capsule.readInt("shellSamples", 0);
        this._radialSamples = capsule.readInt("radialSamples", 0);
        this._radius = capsule.readDouble("radius", 0.0);
    }
}

