/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.scenegraph.shape;

import com.ardor3d.math.Vector2;
import com.ardor3d.math.Vector3;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.scenegraph.IndexBufferData;
import com.ardor3d.scenegraph.Mesh;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.geom.BufferUtils;
import java.io.IOException;
import java.nio.FloatBuffer;

public class Dodecahedron
extends Mesh {
    private static final int NUM_POINTS = 20;
    private static final int NUM_TRIS = 36;
    private double _sideLength;

    public Dodecahedron() {
    }

    public Dodecahedron(String name, double sideLength) {
        super(name);
        this._sideLength = sideLength;
        this._meshData.setVertexBuffer(BufferUtils.createVector3Buffer(20));
        this._meshData.setNormalBuffer(BufferUtils.createVector3Buffer(20));
        this._meshData.setTextureBuffer(BufferUtils.createVector2Buffer(20), 0);
        this._meshData.setIndices(BufferUtils.createIndexBufferData(108, 19));
        this.setVertexData();
        this.setNormalData();
        this.setTextureData();
        this.setIndexData();
    }

    private void setIndexData() {
        IndexBufferData<?> indices = this._meshData.getIndices();
        indices.rewind();
        indices.put(0).put(8).put(9);
        indices.put(0).put(9).put(4);
        indices.put(0).put(4).put(16);
        indices.put(0).put(12).put(13);
        indices.put(0).put(13).put(1);
        indices.put(0).put(1).put(8);
        indices.put(0).put(16).put(17);
        indices.put(0).put(17).put(2);
        indices.put(0).put(2).put(12);
        indices.put(8).put(1).put(18);
        indices.put(8).put(18).put(5);
        indices.put(8).put(5).put(9);
        indices.put(12).put(2).put(10);
        indices.put(12).put(10).put(3);
        indices.put(12).put(3).put(13);
        indices.put(16).put(4).put(14);
        indices.put(16).put(14).put(6);
        indices.put(16).put(6).put(17);
        indices.put(9).put(5).put(15);
        indices.put(9).put(15).put(14);
        indices.put(9).put(14).put(4);
        indices.put(6).put(11).put(10);
        indices.put(6).put(10).put(2);
        indices.put(6).put(2).put(17);
        indices.put(3).put(19).put(18);
        indices.put(3).put(18).put(1);
        indices.put(3).put(1).put(13);
        indices.put(7).put(15).put(5);
        indices.put(7).put(5).put(18);
        indices.put(7).put(18).put(19);
        indices.put(7).put(11).put(6);
        indices.put(7).put(6).put(14);
        indices.put(7).put(14).put(15);
        indices.put(7).put(19).put(3);
        indices.put(7).put(3).put(10);
        indices.put(7).put(10).put(11);
    }

    private void setTextureData() {
        Vector2 tex = new Vector2();
        Vector3 vert = new Vector3();
        for (int i = 0; i < 20; ++i) {
            BufferUtils.populateFromBuffer(vert, this._meshData.getVertexBuffer(), i);
            if (Math.abs(vert.getZ()) < this._sideLength) {
                tex.setX(0.5 * (1.0 + Math.atan2(vert.getY(), vert.getX()) * 0.3183098861837907));
            } else {
                tex.setX(0.5);
            }
            tex.setY(Math.acos(vert.getZ() / this._sideLength) * 0.3183098861837907);
            ((FloatBuffer)this._meshData.getTextureCoords(0).getBuffer()).put((float)tex.getX()).put((float)tex.getY());
        }
    }

    private void setNormalData() {
        Vector3 norm = new Vector3();
        for (int i = 0; i < 20; ++i) {
            BufferUtils.populateFromBuffer(norm, this._meshData.getVertexBuffer(), i);
            norm.normalizeLocal();
            BufferUtils.setInBuffer((ReadOnlyVector3)norm, this._meshData.getNormalBuffer(), i);
        }
    }

    private void setVertexData() {
        double fA = 1.0 / Math.sqrt(3.0);
        double fB = Math.sqrt((3.0 - Math.sqrt(5.0)) / 6.0);
        double fC = Math.sqrt((3.0 + Math.sqrt(5.0)) / 6.0);
        fA *= this._sideLength;
        fB *= this._sideLength;
        fC *= this._sideLength;
        FloatBuffer vbuf = this._meshData.getVertexBuffer();
        vbuf.rewind();
        vbuf.put((float)fA).put((float)fA).put((float)fA);
        vbuf.put((float)fA).put((float)fA).put((float)(-fA));
        vbuf.put((float)fA).put((float)(-fA)).put((float)fA);
        vbuf.put((float)fA).put((float)(-fA)).put((float)(-fA));
        vbuf.put((float)(-fA)).put((float)fA).put((float)fA);
        vbuf.put((float)(-fA)).put((float)fA).put((float)(-fA));
        vbuf.put((float)(-fA)).put((float)(-fA)).put((float)fA);
        vbuf.put((float)(-fA)).put((float)(-fA)).put((float)(-fA));
        vbuf.put((float)fB).put((float)fC).put(0.0f);
        vbuf.put((float)(-fB)).put((float)fC).put(0.0f);
        vbuf.put((float)fB).put((float)(-fC)).put(0.0f);
        vbuf.put((float)(-fB)).put((float)(-fC)).put(0.0f);
        vbuf.put((float)fC).put(0.0f).put((float)fB);
        vbuf.put((float)fC).put(0.0f).put((float)(-fB));
        vbuf.put((float)(-fC)).put(0.0f).put((float)fB);
        vbuf.put((float)(-fC)).put(0.0f).put((float)(-fB));
        vbuf.put(0.0f).put((float)fB).put((float)fC);
        vbuf.put(0.0f).put((float)(-fB)).put((float)fC);
        vbuf.put(0.0f).put((float)fB).put((float)(-fC));
        vbuf.put(0.0f).put((float)(-fB)).put((float)(-fC));
    }

    @Override
    public void write(OutputCapsule capsule) throws IOException {
        super.write(capsule);
        capsule.write(this._sideLength, "sideLength", 0.0);
    }

    @Override
    public void read(InputCapsule capsule) throws IOException {
        super.read(capsule);
        this._sideLength = capsule.readInt("sideLength", 0);
    }
}

