/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.scenegraph.shape;

import com.ardor3d.math.MathUtils;
import com.ardor3d.math.Vector3;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.scenegraph.Mesh;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.geom.BufferUtils;
import java.io.IOException;
import java.nio.FloatBuffer;

public class Dome
extends Mesh {
    private int _planes;
    private int _radialSamples;
    private double _radius;

    public Dome() {
    }

    public Dome(String name) {
        super(name);
    }

    public Dome(String name, int planes, int radialSamples, double radius) {
        this(name, new Vector3(0.0, 0.0, 0.0), planes, radialSamples, radius);
    }

    public Dome(String name, Vector3 center, int planes, int radialSamples, double radius) {
        super(name);
        this.setData(center, planes, radialSamples, radius, true, true);
    }

    public Dome(String name, Vector3 center, int planes, int radialSamples, double radius, boolean outsideView) {
        super(name);
        this.setData(center, planes, radialSamples, radius, true, outsideView);
    }

    public void setData(Vector3 center, int planes, int radialSamples, double radius, boolean updateBuffers, boolean outsideView) {
        this._planes = planes;
        this._radialSamples = radialSamples;
        this._radius = radius;
        if (updateBuffers) {
            this.setGeometryData(outsideView, center);
            this.setIndexData();
        }
    }

    private void setGeometryData(boolean outsideView, Vector3 center) {
        Vector3 tempVa = Vector3.fetchTempInstance();
        Vector3 tempVb = Vector3.fetchTempInstance();
        Vector3 tempVc = Vector3.fetchTempInstance();
        int verts = (this._planes - 1) * (this._radialSamples + 1) + 1;
        this._meshData.setVertexBuffer(BufferUtils.createVector3Buffer(verts));
        this._meshData.setNormalBuffer(BufferUtils.createVector3Buffer(verts));
        this._meshData.setTextureBuffer(BufferUtils.createVector2Buffer(verts), 0);
        double fInvRS = 1.0 / (double)this._radialSamples;
        double fYFactor = 1.0 / (double)(this._planes - 1);
        double[] afSin = new double[this._radialSamples];
        double[] afCos = new double[this._radialSamples];
        for (int iR = 0; iR < this._radialSamples; ++iR) {
            double fAngle = Math.PI * 2 * fInvRS * (double)iR;
            afCos[iR] = MathUtils.cos((double)fAngle);
            afSin[iR] = MathUtils.sin((double)fAngle);
        }
        int i = 0;
        for (int iY = 0; iY < this._planes - 1; ++iY) {
            double fYFraction = fYFactor * (double)iY;
            double fY = this._radius * fYFraction;
            Vector3 kSliceCenter = tempVb.set((ReadOnlyVector3)center);
            kSliceCenter.addLocal(0.0, fY, 0.0);
            double fSliceRadius = Math.sqrt(Math.abs(this._radius * this._radius - fY * fY));
            int iSave = i;
            for (int iR = 0; iR < this._radialSamples; ++iR) {
                double fRadialFraction = (double)iR * fInvRS;
                Vector3 kRadial = tempVc.set(afCos[iR], 0.0, afSin[iR]);
                kRadial.multiply(fSliceRadius, tempVa);
                this._meshData.getVertexBuffer().put((float)(kSliceCenter.getX() + tempVa.getX())).put((float)(kSliceCenter.getY() + tempVa.getY())).put((float)(kSliceCenter.getZ() + tempVa.getZ()));
                BufferUtils.populateFromBuffer(tempVa, this._meshData.getVertexBuffer(), i);
                Vector3 kNormal = tempVa.subtractLocal((ReadOnlyVector3)center);
                kNormal.normalizeLocal();
                if (outsideView) {
                    this._meshData.getNormalBuffer().put((float)kNormal.getX()).put((float)kNormal.getY()).put((float)kNormal.getZ());
                } else {
                    this._meshData.getNormalBuffer().put((float)(-kNormal.getX())).put((float)(-kNormal.getY())).put((float)(-kNormal.getZ()));
                }
                ((FloatBuffer)this._meshData.getTextureCoords(0).getBuffer()).put((float)fRadialFraction).put((float)fYFraction);
                ++i;
            }
            BufferUtils.copyInternalVector3(this._meshData.getVertexBuffer(), iSave, i);
            BufferUtils.copyInternalVector3(this._meshData.getNormalBuffer(), iSave, i);
            ((FloatBuffer)this._meshData.getTextureCoords(0).getBuffer()).put(1.0f).put((float)fYFraction);
            ++i;
        }
        this._meshData.getVertexBuffer().put((float)center.getX()).put((float)(center.getY() + this._radius)).put((float)center.getZ());
        if (outsideView) {
            this._meshData.getNormalBuffer().put(0.0f).put(1.0f).put(0.0f);
        } else {
            this._meshData.getNormalBuffer().put(0.0f).put(-1.0f).put(0.0f);
        }
        ((FloatBuffer)this._meshData.getTextureCoords(0).getBuffer()).put(0.5f).put(1.0f);
        Vector3.releaseTempInstance((Vector3)tempVa);
        Vector3.releaseTempInstance((Vector3)tempVb);
        Vector3.releaseTempInstance((Vector3)tempVc);
    }

    private void setIndexData() {
        int verts = (this._planes - 1) * (this._radialSamples + 1) + 1;
        int tris = (this._planes - 2) * this._radialSamples * 2 + this._radialSamples;
        this._meshData.setIndices(BufferUtils.createIndexBufferData(3 * tris, verts - 1));
        for (int plane = 1; plane < this._planes - 1; ++plane) {
            int bottomPlaneStart = (plane - 1) * (this._radialSamples + 1);
            int topPlaneStart = plane * (this._radialSamples + 1);
            for (int sample = 0; sample < this._radialSamples; ++sample) {
                this._meshData.getIndices().put(bottomPlaneStart + sample);
                this._meshData.getIndices().put(topPlaneStart + sample);
                this._meshData.getIndices().put(bottomPlaneStart + sample + 1);
                this._meshData.getIndices().put(bottomPlaneStart + sample + 1);
                this._meshData.getIndices().put(topPlaneStart + sample);
                this._meshData.getIndices().put(topPlaneStart + sample + 1);
            }
        }
        int bottomPlaneStart = (this._planes - 2) * (this._radialSamples + 1);
        for (int samples = 0; samples < this._radialSamples; ++samples) {
            this._meshData.getIndices().put(bottomPlaneStart + samples);
            this._meshData.getIndices().put(this._meshData.getVertexCount() - 1);
            this._meshData.getIndices().put(bottomPlaneStart + samples + 1);
        }
    }

    public int getPlanes() {
        return this._planes;
    }

    public int getRadialSamples() {
        return this._radialSamples;
    }

    public double getRadius() {
        return this._radius;
    }

    @Override
    public void write(OutputCapsule capsule) throws IOException {
        super.write(capsule);
        capsule.write(this._planes, "planes", 0);
        capsule.write(this._radialSamples, "radialSamples", 0);
        capsule.write(this._radius, "radius", 0.0);
    }

    @Override
    public void read(InputCapsule capsule) throws IOException {
        super.read(capsule);
        this._planes = capsule.readInt("planes", 0);
        this._radialSamples = capsule.readInt("radialSamples", 0);
        this._radius = capsule.readDouble("radius", 0.0);
    }
}

