/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.scenegraph.shape;

import com.ardor3d.math.Quaternion;
import com.ardor3d.math.Vector3;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.renderer.IndexMode;
import com.ardor3d.scenegraph.IndexBufferData;
import com.ardor3d.scenegraph.Line;
import com.ardor3d.scenegraph.Mesh;
import com.ardor3d.util.geom.BufferUtils;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;

public class Extrusion
extends Mesh {
    public Extrusion() {
    }

    public Extrusion(String name) {
        super(name);
    }

    public Extrusion(Line shape, List<ReadOnlyVector3> path, ReadOnlyVector3 up) {
        this.updateGeometry(shape, path, up);
    }

    public Extrusion(String name, Line shape, List<ReadOnlyVector3> path, ReadOnlyVector3 up) {
        super(name);
        this.updateGeometry(shape, path, up);
    }

    public void updateGeometry(Line shape, List<ReadOnlyVector3> path, ReadOnlyVector3 up) {
        this.updateGeometry(shape, path, false, up);
    }

    public void updateGeometry(Line shape, List<ReadOnlyVector3> path, boolean closed, ReadOnlyVector3 up) {
        IndexBufferData<?> indices;
        FloatBuffer vertices;
        FloatBuffer shapeBuffer = shape.getMeshData().getVertexBuffer();
        FloatBuffer shapeNormalBuffer = shape.getMeshData().getNormalBuffer();
        int numVertices = path.size() * shapeBuffer.limit();
        if (this._meshData.getVertexBuffer() != null && this._meshData.getVertexBuffer().limit() == numVertices) {
            vertices = this._meshData.getVertexBuffer();
            vertices.rewind();
        } else {
            vertices = BufferUtils.createFloatBuffer(numVertices);
        }
        FloatBuffer normals = null;
        if (shapeNormalBuffer != null) {
            if (this._meshData.getNormalBuffer() != null && this._meshData.getNormalBuffer().limit() == numVertices) {
                normals = this._meshData.getNormalBuffer();
                normals.rewind();
            } else {
                normals = BufferUtils.createFloatBuffer(numVertices);
            }
        }
        int numIndices = (path.size() - 1) * 2 * shapeBuffer.limit();
        if (this._meshData.getIndices() != null && this._meshData.getIndices().limit() == numIndices) {
            indices = this._meshData.getIndices();
            indices.rewind();
        } else {
            indices = BufferUtils.createIndexBufferData(numIndices, numVertices - 1);
        }
        IndexMode indexMode = shape.getMeshData().getIndexMode(0);
        int shapeVertices = shapeBuffer.limit() / 3;
        Vector3 vector = new Vector3();
        Vector3 direction = new Vector3();
        Quaternion rotation = new Quaternion();
        for (int i = 0; i < path.size(); ++i) {
            ReadOnlyVector3 point = path.get(i);
            shapeBuffer.rewind();
            if (shapeNormalBuffer != null) {
                shapeNormalBuffer.rewind();
            }
            int shapeVertice = 0;
            do {
                ReadOnlyVector3 lastPoint;
                ReadOnlyVector3 nextPoint = i < path.size() - 1 ? path.get(i + 1) : (closed ? path.get(0) : null);
                ReadOnlyVector3 readOnlyVector3 = lastPoint = i > 0 ? path.get(i - 1) : null;
                if (nextPoint != null) {
                    direction.set(nextPoint).subtractLocal(point);
                } else {
                    direction.set(point).subtractLocal(lastPoint);
                }
                rotation.lookAt((ReadOnlyVector3)direction, up);
                if (shapeNormalBuffer != null && normals != null) {
                    vector.set((double)shapeNormalBuffer.get(), (double)shapeNormalBuffer.get(), (double)shapeNormalBuffer.get());
                    rotation.apply((ReadOnlyVector3)vector, vector);
                    normals.put(vector.getXf());
                    normals.put(vector.getYf());
                    normals.put(vector.getZf());
                }
                vector.set((double)shapeBuffer.get(), (double)shapeBuffer.get(), (double)shapeBuffer.get());
                rotation.apply((ReadOnlyVector3)vector, vector);
                vector.addLocal(point);
                vertices.put(vector.getXf());
                vertices.put(vector.getYf());
                vertices.put(vector.getZf());
                if (indexMode != IndexMode.Lines || !(shapeVertice & true)) {
                    if (i < path.size() - 1) {
                        if (shapeBuffer.hasRemaining()) {
                            indices.put(i * shapeVertices + shapeVertice);
                            indices.put(i * shapeVertices + shapeVertice + 1);
                            indices.put((i + 1) * shapeVertices + shapeVertice);
                            indices.put((i + 1) * shapeVertices + shapeVertice + 1);
                            indices.put((i + 1) * shapeVertices + shapeVertice);
                            indices.put(i * shapeVertices + shapeVertice + 1);
                        } else if (indexMode == IndexMode.LineLoop) {
                            indices.put(i * shapeVertices + shapeVertice);
                            indices.put(i * shapeVertices + shapeVertice + 1);
                            indices.put((i + 1) * shapeVertices + shapeVertice);
                            indices.put(i * shapeVertices + shapeVertice);
                            indices.put((i - 1) * shapeVertices + shapeVertice + 1);
                            indices.put(i * shapeVertices + shapeVertice + 1);
                        }
                    } else if (closed) {
                        indices.put(i * shapeVertices + shapeVertice);
                        indices.put(i * shapeVertices + shapeVertice + 1);
                        indices.put(0 + shapeVertice);
                        indices.put(0 + shapeVertice + 1);
                        indices.put(0 + shapeVertice);
                        indices.put(i * shapeVertices + shapeVertice + 1);
                    }
                }
                ++shapeVertice;
            } while (shapeBuffer.hasRemaining());
        }
        this._meshData.setVertexBuffer(vertices);
        if (normals != null) {
            this._meshData.setNormalBuffer(normals);
        }
        this._meshData.setIndices(indices);
    }

    public void updateGeometry(Line shape, List<ReadOnlyVector3> points, int segments, ReadOnlyVector3 up) {
        this.updateGeometry(shape, points, segments, false, up);
    }

    public void updateGeometry(Line shape, List<ReadOnlyVector3> points, int segments, boolean closed, ReadOnlyVector3 up) {
        int np = points.size();
        if (closed) {
            np += 3;
        }
        double[][] d = new double[3][np];
        double[] x = new double[np];
        ArrayList<ReadOnlyVector3> path = new ArrayList<ReadOnlyVector3>();
        for (int i = 0; i < np; ++i) {
            ReadOnlyVector3 p = !closed ? points.get(i) : (i == 0 ? points.get(points.size() - 1) : (i >= np - 2 ? points.get(i - np + 2) : points.get(i - 1)));
            x[i] = i;
            d[0][i] = p.getX();
            d[1][i] = p.getY();
            d[2][i] = p.getZ();
        }
        if (np > 1) {
            int i;
            int dim;
            double[][] a = new double[3][np];
            double[] h = new double[np];
            for (int i2 = 1; i2 <= np - 1; ++i2) {
                h[i2] = x[i2] - x[i2 - 1];
            }
            if (np > 2) {
                double[] sub = new double[np - 1];
                double[] diag = new double[np - 1];
                double[] sup = new double[np - 1];
                for (int i3 = 1; i3 <= np - 2; ++i3) {
                    diag[i3] = (h[i3] + h[i3 + 1]) / 3.0;
                    sup[i3] = h[i3 + 1] / 6.0;
                    sub[i3] = h[i3] / 6.0;
                    for (int dim2 = 0; dim2 < 3; ++dim2) {
                        a[dim2][i3] = (d[dim2][i3 + 1] - d[dim2][i3]) / h[i3 + 1] - (d[dim2][i3] - d[dim2][i3 - 1]) / h[i3];
                    }
                }
                for (dim = 0; dim < 3; ++dim) {
                    Extrusion.solveTridiag((double[])sub.clone(), (double[])diag.clone(), (double[])sup.clone(), a[dim], np - 2);
                }
            }
            if (!closed) {
                path.add((ReadOnlyVector3)new Vector3(d[0][0], d[1][0], d[2][0]));
            }
            double[] point = new double[3];
            int n = i = closed ? 2 : 1;
            while (i <= np - 2) {
                for (int j = 1; j <= segments; ++j) {
                    for (dim = 0; dim < 3; ++dim) {
                        double v;
                        double t1 = h[i] * (double)j / (double)segments;
                        double t2 = h[i] - t1;
                        point[dim] = v = ((-a[dim][i - 1] / 6.0 * (t2 + h[i]) * t1 + d[dim][i - 1]) * t2 + (-a[dim][i] / 6.0 * (t1 + h[i]) * t2 + d[dim][i]) * t1) / h[i];
                    }
                    path.add((ReadOnlyVector3)new Vector3(point[0], point[1], point[2]));
                }
                ++i;
            }
        }
        this.updateGeometry(shape, path, closed, up);
    }

    private static void solveTridiag(double[] sub, double[] diag, double[] sup, double[] b, int n) {
        int i;
        for (i = 2; i <= n; ++i) {
            sub[i] = sub[i] / diag[i - 1];
            diag[i] = diag[i] - sub[i] * sup[i - 1];
            b[i] = b[i] - sub[i] * b[i - 1];
        }
        b[n] = b[n] / diag[n];
        for (i = n - 1; i >= 1; --i) {
            b[i] = (b[i] - sup[i] * b[i + 1]) / diag[i];
        }
    }
}

