/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.scenegraph.shape;

import com.ardor3d.math.Vector3;
import com.ardor3d.scenegraph.FloatBufferData;
import com.ardor3d.scenegraph.IndexBufferData;
import com.ardor3d.scenegraph.Mesh;
import com.ardor3d.util.geom.BufferUtils;
import java.nio.FloatBuffer;

public class GeoSphere
extends Mesh {
    private int _maxlevels;
    private boolean _usingIcosahedron = true;
    private TextureMode _textureMode = TextureMode.Original;
    private double _radius;

    public GeoSphere(String name, boolean useIcosahedron, double radius, int maxlevels, TextureMode textureMode) {
        super(name);
        this._maxlevels = maxlevels;
        this._radius = radius;
        this._maxlevels = maxlevels;
        this._usingIcosahedron = useIcosahedron;
        this._textureMode = textureMode;
        this.updateGeometry();
    }

    public GeoSphere() {
    }

    public double getRadius() {
        return this._radius;
    }

    public boolean isUsingIcosahedron() {
        return this._usingIcosahedron;
    }

    public void setTextureMode(TextureMode textureMode) {
        if (textureMode != this._textureMode) {
            this._textureMode = textureMode;
            this.updateGeometry();
        }
    }

    public TextureMode getTextureMode() {
        return this._textureMode;
    }

    private void updateGeometry() {
        Triangle[] old;
        int initialTriangleCount = this._usingIcosahedron ? 20 : 8;
        int initialVertexCount = this._usingIcosahedron ? 12 : 6;
        int tris = initialTriangleCount << (this._maxlevels - 1) * 2;
        int verts = initialTriangleCount * (((1 << this._maxlevels * 2) - 1) / 3 - 1) + initialVertexCount + this.calculateBorderTriangles(this._maxlevels);
        FloatBuffer vertBuf = this._meshData.getVertexBuffer();
        vertBuf = BufferUtils.createVector3Buffer(vertBuf, verts);
        this._meshData.setVertexBuffer(vertBuf);
        this._meshData.setNormalBuffer(BufferUtils.createVector3Buffer(this._meshData.getNormalBuffer(), verts));
        FloatBufferData textureCoords = this._meshData.getTextureCoords(0);
        this._meshData.setTextureCoords(new FloatBufferData(BufferUtils.createVector2Buffer(textureCoords != null ? (FloatBuffer)textureCoords.getBuffer() : null, verts), 2), 0);
        int pos = 0;
        if (this._usingIcosahedron) {
            int[] indices = new int[]{pos + 0, pos + 1, pos + 2, pos + 0, pos + 2, pos + 3, pos + 0, pos + 3, pos + 4, pos + 0, pos + 4, pos + 5, pos + 0, pos + 5, pos + 1, pos + 1, pos + 10, pos + 6, pos + 2, pos + 6, pos + 7, pos + 3, pos + 7, pos + 8, pos + 4, pos + 8, pos + 9, pos + 5, pos + 9, pos + 10, pos + 6, pos + 2, pos + 1, pos + 7, pos + 3, pos + 2, pos + 8, pos + 4, pos + 3, pos + 9, pos + 5, pos + 4, pos + 10, pos + 1, pos + 5, pos + 11, pos + 7, pos + 6, pos + 11, pos + 8, pos + 7, pos + 11, pos + 9, pos + 8, pos + 11, pos + 10, pos + 9, pos + 11, pos + 6, pos + 10};
            double y = 0.4472 * this._radius;
            double a = 0.8944 * this._radius;
            double b = 0.2764 * this._radius;
            double c = 0.7236 * this._radius;
            double d = 0.8507 * this._radius;
            double e = 0.5257 * this._radius;
            ++pos;
            this.put(new Vector3(0.0, this._radius, 0.0));
            ++pos;
            this.put(new Vector3(a, y, 0.0));
            ++pos;
            this.put(new Vector3(b, y, -d));
            ++pos;
            this.put(new Vector3(-c, y, -e));
            ++pos;
            this.put(new Vector3(-c, y, e));
            ++pos;
            this.put(new Vector3(b, y, d));
            ++pos;
            this.put(new Vector3(c, -y, -e));
            ++pos;
            this.put(new Vector3(-b, -y, -d));
            ++pos;
            this.put(new Vector3(-a, -y, 0.0));
            ++pos;
            this.put(new Vector3(-b, -y, d));
            ++pos;
            this.put(new Vector3(c, -y, e));
            ++pos;
            this.put(new Vector3(0.0, -this._radius, 0.0));
            Triangle[] ikosaedron = new Triangle[indices.length / 3];
            for (int i = 0; i < ikosaedron.length; ++i) {
                Triangle triangle = ikosaedron[i] = new Triangle();
                triangle.pt[0] = indices[i * 3];
                triangle.pt[1] = indices[i * 3 + 1];
                triangle.pt[2] = indices[i * 3 + 2];
            }
            old = ikosaedron;
        } else {
            Triangle[] octahedron;
            Vector3 XPLUS = new Vector3(this._radius, 0.0, 0.0);
            Vector3 XMIN = new Vector3(-this._radius, 0.0, 0.0);
            Vector3 YPLUS = new Vector3(0.0, this._radius, 0.0);
            Vector3 YMIN = new Vector3(0.0, -this._radius, 0.0);
            Vector3 ZPLUS = new Vector3(0.0, 0.0, this._radius);
            Vector3 ZMIN = new Vector3(0.0, 0.0, -this._radius);
            int xplus = pos++;
            this.put(XPLUS);
            int xmin = pos++;
            this.put(XMIN);
            int yplus = pos++;
            this.put(YPLUS);
            int ymin = pos++;
            this.put(YMIN);
            int zplus = pos++;
            this.put(ZPLUS);
            int zmin = pos++;
            this.put(ZMIN);
            old = octahedron = new Triangle[]{new Triangle(yplus, zplus, xplus), new Triangle(xmin, zplus, yplus), new Triangle(ymin, zplus, xmin), new Triangle(xplus, zplus, ymin), new Triangle(zmin, yplus, xplus), new Triangle(zmin, xmin, yplus), new Triangle(zmin, ymin, xmin), new Triangle(zmin, xplus, ymin)};
        }
        Vector3 pt0 = new Vector3();
        Vector3 pt1 = new Vector3();
        Vector3 pt2 = new Vector3();
        for (int level = 1; level < this._maxlevels; ++level) {
            int i;
            Triangle[] next = new Triangle[old.length * 4];
            for (i = 0; i < next.length; ++i) {
                next[i] = new Triangle();
            }
            for (i = 0; i < old.length; ++i) {
                int newi = i * 4;
                Triangle oldt = old[i];
                Triangle newt = next[newi];
                BufferUtils.populateFromBuffer(pt0, vertBuf, oldt.pt[0]);
                BufferUtils.populateFromBuffer(pt1, vertBuf, oldt.pt[1]);
                BufferUtils.populateFromBuffer(pt2, vertBuf, oldt.pt[2]);
                Vector3 av = this.createMidpoint(pt0, pt2).normalizeLocal().multiplyLocal(this._radius);
                Vector3 bv = this.createMidpoint(pt0, pt1).normalizeLocal().multiplyLocal(this._radius);
                Vector3 cv = this.createMidpoint(pt1, pt2).normalizeLocal().multiplyLocal(this._radius);
                int a = pos++;
                this.put(av);
                int b = pos++;
                this.put(bv);
                int c = pos++;
                this.put(cv);
                newt.pt[0] = oldt.pt[0];
                newt.pt[1] = b;
                newt.pt[2] = a;
                newt = next[++newi];
                newt.pt[0] = b;
                newt.pt[1] = oldt.pt[1];
                newt.pt[2] = c;
                newt = next[++newi];
                newt.pt[0] = a;
                newt.pt[1] = b;
                newt.pt[2] = c;
                newt = next[++newi];
                newt.pt[0] = a;
                newt.pt[1] = c;
                newt.pt[2] = oldt.pt[2];
            }
            old = next;
        }
        IndexBufferData<?> indexBuffer = BufferUtils.createIndexBufferData(tris * 3, verts - 1);
        this._meshData.setIndices(indexBuffer);
        int carryIntIndex = this._meshData.getVertexBuffer().position() / 3;
        for (Triangle triangle : old) {
            for (int aPt : triangle.pt) {
                double yCenter;
                Vector3 point = new Vector3();
                BufferUtils.populateFromBuffer(point, this._meshData.getVertexBuffer(), aPt);
                if (point.getX() > 0.0 && point.getY() == 0.0 && (yCenter = (double)(this._meshData.getVertexBuffer().get(triangle.pt[0] * 3 + 1) + this._meshData.getVertexBuffer().get(triangle.pt[1] * 3 + 1) + this._meshData.getVertexBuffer().get(triangle.pt[2] * 3 + 1)) / 3.0) > 0.0) {
                    this.put(point, true);
                    indexBuffer.put(carryIntIndex++);
                    continue;
                }
                indexBuffer.put(aPt);
            }
        }
    }

    private void put(Vector3 vec) {
        this.put(vec, false);
    }

    private void put(Vector3 vec, boolean begining) {
        FloatBuffer vertBuf = this._meshData.getVertexBuffer();
        vertBuf.put((float)vec.getX());
        vertBuf.put((float)vec.getY());
        vertBuf.put((float)vec.getZ());
        double length = vec.length();
        FloatBuffer normBuf = this._meshData.getNormalBuffer();
        double xNorm = vec.getX() / length;
        normBuf.put((float)xNorm);
        double yNorm = vec.getY() / length;
        normBuf.put((float)yNorm);
        double zNorm = vec.getZ() / length;
        normBuf.put((float)zNorm);
        FloatBuffer texBuf = (FloatBuffer)this._meshData.getTextureCoords(0).getBuffer();
        if (vec.getX() > 0.0 && vec.getY() == 0.0) {
            if (begining) {
                texBuf.put(0.0f);
            } else {
                texBuf.put(1.0f);
            }
        } else {
            texBuf.put((float)((Math.atan2(yNorm, xNorm) / (Math.PI * 2) + 1.0) % 1.0));
        }
        double vPos = 0.0;
        switch (this._textureMode) {
            case Original: {
                vPos = 0.5 * (zNorm + 1.0);
                break;
            }
            case Projected: {
                vPos = 0.3183098861837907 * (1.5707963267948966 + Math.asin(zNorm));
            }
        }
        texBuf.put((float)vPos);
    }

    private int calculateBorderTriangles(int levels) {
        int current = 108;
        levels -= 4;
        while (levels-- > 0) {
            current = 2 * current + 12;
        }
        return current;
    }

    protected Vector3 createMidpoint(Vector3 a, Vector3 b) {
        return new Vector3((a.getX() + b.getX()) * 0.5, (a.getY() + b.getY()) * 0.5, (a.getZ() + b.getZ()) * 0.5);
    }

    static class Triangle {
        int[] pt = new int[3];

        public Triangle() {
        }

        public Triangle(int pt0, int pt1, int pt2) {
            this.pt[0] = pt0;
            this.pt[1] = pt1;
            this.pt[2] = pt2;
        }
    }

    public static enum TextureMode {
        Original,
        Projected;

    }
}

