/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.scenegraph.shape;

import com.ardor3d.math.Vector3;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.scenegraph.Mesh;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.geom.BufferUtils;
import java.io.IOException;
import java.nio.FloatBuffer;

public class Hexagon
extends Mesh {
    private static final int NUM_POINTS = 7;
    private static final int NUM_TRIS = 6;
    private float _sideLength;

    public Hexagon() {
    }

    public Hexagon(String name, float sideLength) {
        super(name);
        this._sideLength = sideLength;
        this._meshData.setVertexBuffer(BufferUtils.createVector3Buffer(7));
        this._meshData.setNormalBuffer(BufferUtils.createVector3Buffer(7));
        this._meshData.setTextureBuffer(BufferUtils.createVector2Buffer(7), 0);
        this._meshData.setIndices(BufferUtils.createIndexBufferData(18, 6));
        this.setVertexData();
        this.setIndexData();
        this.setTextureData();
        this.setNormalData();
    }

    private void setVertexData() {
        this._meshData.getVertexBuffer().put(-(this._sideLength / 2.0f)).put(this._sideLength * 0.866f).put(0.0f);
        this._meshData.getVertexBuffer().put(this._sideLength / 2.0f).put(this._sideLength * 0.866f).put(0.0f);
        this._meshData.getVertexBuffer().put(this._sideLength).put(0.0f).put(0.0f);
        this._meshData.getVertexBuffer().put(this._sideLength / 2.0f).put(-this._sideLength * 0.866f).put(0.0f);
        this._meshData.getVertexBuffer().put(-(this._sideLength / 2.0f)).put(-this._sideLength * 0.866f).put(0.0f);
        this._meshData.getVertexBuffer().put(-this._sideLength).put(0.0f).put(0.0f);
        this._meshData.getVertexBuffer().put(0.0f).put(0.0f).put(0.0f);
    }

    private void setIndexData() {
        this._meshData.getIndices().rewind();
        this._meshData.getIndices().put(0);
        this._meshData.getIndices().put(6);
        this._meshData.getIndices().put(1);
        this._meshData.getIndices().put(1);
        this._meshData.getIndices().put(6);
        this._meshData.getIndices().put(2);
        this._meshData.getIndices().put(2);
        this._meshData.getIndices().put(6);
        this._meshData.getIndices().put(3);
        this._meshData.getIndices().put(3);
        this._meshData.getIndices().put(6);
        this._meshData.getIndices().put(4);
        this._meshData.getIndices().put(4);
        this._meshData.getIndices().put(6);
        this._meshData.getIndices().put(5);
        this._meshData.getIndices().put(5);
        this._meshData.getIndices().put(6);
        this._meshData.getIndices().put(0);
    }

    private void setTextureData() {
        ((FloatBuffer)this._meshData.getTextureCoords(0).getBuffer()).put(0.25f).put(0.0f);
        ((FloatBuffer)this._meshData.getTextureCoords(0).getBuffer()).put(0.75f).put(0.0f);
        ((FloatBuffer)this._meshData.getTextureCoords(0).getBuffer()).put(1.0f).put(0.5f);
        ((FloatBuffer)this._meshData.getTextureCoords(0).getBuffer()).put(0.75f).put(1.0f);
        ((FloatBuffer)this._meshData.getTextureCoords(0).getBuffer()).put(0.25f).put(1.0f);
        ((FloatBuffer)this._meshData.getTextureCoords(0).getBuffer()).put(0.0f).put(0.5f);
        ((FloatBuffer)this._meshData.getTextureCoords(0).getBuffer()).put(0.5f).put(0.5f);
    }

    private void setNormalData() {
        Vector3 zAxis = new Vector3(0.0, 0.0, 1.0);
        for (int i = 0; i < 7; ++i) {
            BufferUtils.setInBuffer((ReadOnlyVector3)zAxis, this._meshData.getNormalBuffer(), i);
        }
    }

    @Override
    public void write(OutputCapsule capsule) throws IOException {
        super.write(capsule);
        capsule.write(this._sideLength, "sideLength", 0.0f);
    }

    @Override
    public void read(InputCapsule capsule) throws IOException {
        super.read(capsule);
        this._sideLength = capsule.readInt("sideLength", 0);
    }
}

