/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.scenegraph.shape;

import com.ardor3d.math.Vector2;
import com.ardor3d.math.Vector3;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.scenegraph.Mesh;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.geom.BufferUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;

public class Icosahedron
extends Mesh {
    private static final int NUM_POINTS = 12;
    private double _sideLength;

    public Icosahedron() {
    }

    public Icosahedron(String name, double sideLength) {
        super(name);
        this._sideLength = sideLength;
        this._meshData.setVertexBuffer(BufferUtils.createVector3Buffer(12));
        this._meshData.setNormalBuffer(BufferUtils.createVector3Buffer(12));
        this._meshData.setTextureBuffer(BufferUtils.createVector2Buffer(12), 0);
        this.setVertexData();
        this.setNormalData();
        this.setTextureData();
        this.setIndexData();
    }

    private void setIndexData() {
        byte[] indices = new byte[]{0, 8, 4, 0, 5, 10, 2, 4, 9, 2, 11, 5, 1, 6, 8, 1, 10, 7, 3, 9, 6, 3, 7, 11, 0, 10, 8, 1, 8, 10, 2, 9, 11, 3, 11, 9, 4, 2, 0, 5, 0, 2, 6, 1, 3, 7, 3, 1, 8, 6, 4, 9, 4, 6, 10, 5, 7, 11, 7, 5};
        ByteBuffer buf = BufferUtils.createByteBuffer(indices.length);
        buf.put(indices);
        buf.rewind();
        this._meshData.setIndexBuffer(buf);
    }

    private void setTextureData() {
        Vector2 tex = new Vector2();
        Vector3 vert = new Vector3();
        for (int i = 0; i < 12; ++i) {
            BufferUtils.populateFromBuffer(vert, this._meshData.getVertexBuffer(), i);
            if (Math.abs(vert.getZ()) < this._sideLength) {
                tex.setX(0.5 * (1.0 + Math.atan2(vert.getY(), vert.getX()) * 0.3183098861837907));
            } else {
                tex.setX(0.5);
            }
            tex.setY(Math.acos(vert.getZ() / this._sideLength) * 0.3183098861837907);
            ((FloatBuffer)this._meshData.getTextureCoords(0).getBuffer()).put((float)tex.getX()).put((float)tex.getY());
        }
    }

    private void setNormalData() {
        Vector3 norm = new Vector3();
        for (int i = 0; i < 12; ++i) {
            BufferUtils.populateFromBuffer(norm, this._meshData.getVertexBuffer(), i);
            norm.normalizeLocal();
            BufferUtils.setInBuffer((ReadOnlyVector3)norm, this._meshData.getNormalBuffer(), i);
        }
    }

    private void setVertexData() {
        double dGoldenRatio = 0.5 * (1.0 + Math.sqrt(5.0));
        double dInvRoot = 1.0 / Math.sqrt(1.0 + dGoldenRatio * dGoldenRatio);
        float dU = (float)(dGoldenRatio * dInvRoot * this._sideLength);
        float dV = (float)(dInvRoot * this._sideLength);
        FloatBuffer vbuf = this._meshData.getVertexBuffer();
        vbuf.rewind();
        vbuf.put(dU).put(dV).put(0.0f);
        vbuf.put(-dU).put(dV).put(0.0f);
        vbuf.put(dU).put(-dV).put(0.0f);
        vbuf.put(-dU).put(-dV).put(0.0f);
        vbuf.put(dV).put(0.0f).put(dU);
        vbuf.put(dV).put(0.0f).put(-dU);
        vbuf.put(-dV).put(0.0f).put(dU);
        vbuf.put(-dV).put(0.0f).put(-dU);
        vbuf.put(0.0f).put(dU).put(dV);
        vbuf.put(0.0f).put(-dU).put(dV);
        vbuf.put(0.0f).put(dU).put(-dV);
        vbuf.put(0.0f).put(-dU).put(-dV);
    }

    @Override
    public void write(OutputCapsule capsule) throws IOException {
        super.write(capsule);
        capsule.write(this._sideLength, "sideLength", 0.0);
    }

    @Override
    public void read(InputCapsule capsule) throws IOException {
        super.read(capsule);
        this._sideLength = capsule.readInt("sideLength", 0);
    }
}

