/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.scenegraph.shape;

import com.ardor3d.math.Vector3;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.scenegraph.shape.Box;
import java.nio.FloatBuffer;

public class MultiFaceBox
extends Box {
    public MultiFaceBox() {
        this.remap();
    }

    public MultiFaceBox(String name) {
        super(name);
        this.remap();
    }

    public MultiFaceBox(String name, Vector3 min, Vector3 max) {
        super(name, (ReadOnlyVector3)min, (ReadOnlyVector3)max);
        this.remap();
    }

    public MultiFaceBox(String name, Vector3 center, float xExtent, float yExtent, float zExtent) {
        super(name, (ReadOnlyVector3)center, xExtent, yExtent, zExtent);
        this.remap();
    }

    private void remap() {
        FloatBuffer fb = (FloatBuffer)this._meshData.getTextureCoords(0).getBuffer();
        fb.rewind();
        for (int i = 0; i < 6; ++i) {
            float bottom = (float)i / 8.0f;
            float top = (float)(i + 1) / 8.0f;
            float[] tex = new float[]{1.0f, bottom, 0.0f, bottom, 0.0f, top, 1.0f, top};
            fb.put(tex);
        }
    }
}

