/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.scenegraph.shape;

import com.ardor3d.math.Vector2;
import com.ardor3d.math.Vector3;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.scenegraph.IndexBufferData;
import com.ardor3d.scenegraph.Mesh;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.geom.BufferUtils;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.FloatBuffer;

public class Octahedron
extends Mesh {
    private static final int NUM_POINTS = 6;
    private static final int NUM_TRIS = 8;
    private double _sideLength;

    public Octahedron() {
    }

    public Octahedron(String name, double sideLength) {
        super(name);
        this._sideLength = sideLength;
        this._meshData.setVertexBuffer(BufferUtils.createVector3Buffer(6));
        this._meshData.setNormalBuffer(BufferUtils.createVector3Buffer(6));
        this._meshData.setTextureBuffer(BufferUtils.createVector2Buffer(6), 0);
        this._meshData.setIndices(BufferUtils.createIndexBufferData(24, 5));
        this.setVertexData();
        this.setNormalData();
        this.setTextureData();
        this.setIndexData();
    }

    private void setIndexData() {
        IndexBufferData<?> indices = this._meshData.getIndices();
        ((Buffer)indices.getBuffer()).rewind();
        indices.put(4).put(0).put(2);
        indices.put(4).put(2).put(1);
        indices.put(4).put(1).put(3);
        indices.put(4).put(3).put(0);
        indices.put(5).put(2).put(0);
        indices.put(5).put(1).put(2);
        indices.put(5).put(3).put(1);
        indices.put(5).put(0).put(3);
    }

    private void setTextureData() {
        Vector2 tex = new Vector2();
        Vector3 vert = new Vector3();
        for (int i = 0; i < 6; ++i) {
            BufferUtils.populateFromBuffer(vert, this._meshData.getVertexBuffer(), i);
            if (Math.abs(vert.getZ()) < this._sideLength) {
                tex.setX(0.5 * (1.0 + Math.atan2(vert.getY(), vert.getX()) * 0.3183098861837907));
            } else {
                tex.setX(0.5);
            }
            tex.setY(Math.acos(vert.getZ() / this._sideLength) * 0.3183098861837907);
            ((FloatBuffer)this._meshData.getTextureCoords(0).getBuffer()).put((float)tex.getX()).put((float)tex.getY());
        }
    }

    private void setNormalData() {
        Vector3 norm = new Vector3();
        for (int i = 0; i < 6; ++i) {
            BufferUtils.populateFromBuffer(norm, this._meshData.getVertexBuffer(), i);
            norm.normalizeLocal();
            BufferUtils.setInBuffer((ReadOnlyVector3)norm, this._meshData.getNormalBuffer(), i);
        }
    }

    private void setVertexData() {
        float floatSideLength = (float)this._sideLength;
        this._meshData.getVertexBuffer().put(floatSideLength).put(0.0f).put(0.0f);
        this._meshData.getVertexBuffer().put(-floatSideLength).put(0.0f).put(0.0f);
        this._meshData.getVertexBuffer().put(0.0f).put(floatSideLength).put(0.0f);
        this._meshData.getVertexBuffer().put(0.0f).put(-floatSideLength).put(0.0f);
        this._meshData.getVertexBuffer().put(0.0f).put(0.0f).put(floatSideLength);
        this._meshData.getVertexBuffer().put(0.0f).put(0.0f).put(-floatSideLength);
    }

    @Override
    public void write(OutputCapsule capsule) throws IOException {
        super.write(capsule);
        capsule.write(this._sideLength, "sideLength", 0.0);
    }

    @Override
    public void read(InputCapsule capsule) throws IOException {
        super.read(capsule);
        this._sideLength = capsule.readInt("sideLength", 0);
    }
}

