/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.scenegraph.shape;

import com.ardor3d.math.Vector2;
import com.ardor3d.math.Vector3;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.scenegraph.Mesh;
import com.ardor3d.util.export.CapsuleUtils;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.export.Savable;
import com.ardor3d.util.geom.BufferUtils;
import java.io.IOException;
import java.nio.FloatBuffer;

public class OrientedBox
extends Mesh {
    protected Vector3 _center;
    protected Vector3 _xAxis = new Vector3(1.0, 0.0, 0.0);
    protected Vector3 _yAxis = new Vector3(0.0, 1.0, 0.0);
    protected Vector3 _zAxis = new Vector3(0.0, 0.0, 1.0);
    protected Vector3 _extent = new Vector3(0.0, 0.0, 0.0);
    protected Vector2 _texTopRight;
    protected Vector2 _texTopLeft;
    protected Vector2 _texBotRight;
    protected Vector2 _texBotLeft;
    public Vector3[] _vectorStore;
    public boolean _correctCorners;

    public OrientedBox() {
    }

    public OrientedBox(String name) {
        super(name);
        this._vectorStore = new Vector3[8];
        for (int i = 0; i < this._vectorStore.length; ++i) {
            this._vectorStore[i] = new Vector3();
        }
        this._texTopRight = new Vector2(1.0, 1.0);
        this._texTopLeft = new Vector2(1.0, 0.0);
        this._texBotRight = new Vector2(0.0, 1.0);
        this._texBotLeft = new Vector2(0.0, 0.0);
        this._center = new Vector3(0.0, 0.0, 0.0);
        this._correctCorners = false;
        this.computeInformation();
    }

    public void computeInformation() {
        this.setVertexData();
        this.setNormalData();
        this.setTextureData();
        this.setIndexData();
    }

    private void setIndexData() {
        if (this._meshData.getIndices() == null) {
            this._meshData.setIndexBuffer(BufferUtils.createByteBuffer(36));
            for (int i = 0; i < 6; ++i) {
                this._meshData.getIndices().put(i * 4 + 0);
                this._meshData.getIndices().put(i * 4 + 1);
                this._meshData.getIndices().put(i * 4 + 3);
                this._meshData.getIndices().put(i * 4 + 1);
                this._meshData.getIndices().put(i * 4 + 2);
                this._meshData.getIndices().put(i * 4 + 3);
            }
        }
    }

    private void setTextureData() {
        if (this._meshData.getTextureBuffer(0) == null) {
            this._meshData.setTextureBuffer(BufferUtils.createVector2Buffer(24), 0);
            for (int x = 0; x < 6; ++x) {
                ((FloatBuffer)this._meshData.getTextureCoords(0).getBuffer()).put(this._texTopRight.getXf()).put(this._texTopRight.getYf());
                ((FloatBuffer)this._meshData.getTextureCoords(0).getBuffer()).put(this._texTopLeft.getXf()).put(this._texTopLeft.getYf());
                ((FloatBuffer)this._meshData.getTextureCoords(0).getBuffer()).put(this._texBotLeft.getXf()).put(this._texBotLeft.getYf());
                ((FloatBuffer)this._meshData.getTextureCoords(0).getBuffer()).put(this._texBotRight.getXf()).put(this._texBotRight.getYf());
            }
        }
    }

    private void setNormalData() {
        if (this._meshData.getNormalBuffer() == null) {
            this._meshData.setNormalBuffer(BufferUtils.createVector3Buffer(24));
        } else {
            this._meshData.getNormalBuffer().rewind();
        }
        this._meshData.getNormalBuffer().put(this._yAxis.getXf()).put(this._yAxis.getYf()).put(this._yAxis.getZf());
        this._meshData.getNormalBuffer().put(this._yAxis.getXf()).put(this._yAxis.getYf()).put(this._yAxis.getZf());
        this._meshData.getNormalBuffer().put(this._yAxis.getXf()).put(this._yAxis.getYf()).put(this._yAxis.getZf());
        this._meshData.getNormalBuffer().put(this._yAxis.getXf()).put(this._yAxis.getYf()).put(this._yAxis.getZf());
        this._meshData.getNormalBuffer().put(this._xAxis.getXf()).put(this._xAxis.getYf()).put(this._xAxis.getZf());
        this._meshData.getNormalBuffer().put(this._xAxis.getXf()).put(this._xAxis.getYf()).put(this._xAxis.getZf());
        this._meshData.getNormalBuffer().put(this._xAxis.getXf()).put(this._xAxis.getYf()).put(this._xAxis.getZf());
        this._meshData.getNormalBuffer().put(this._xAxis.getXf()).put(this._xAxis.getYf()).put(this._xAxis.getZf());
        this._meshData.getNormalBuffer().put(-this._xAxis.getXf()).put(-this._xAxis.getYf()).put(-this._xAxis.getZf());
        this._meshData.getNormalBuffer().put(-this._xAxis.getXf()).put(-this._xAxis.getYf()).put(-this._xAxis.getZf());
        this._meshData.getNormalBuffer().put(-this._xAxis.getXf()).put(-this._xAxis.getYf()).put(-this._xAxis.getZf());
        this._meshData.getNormalBuffer().put(-this._xAxis.getXf()).put(-this._xAxis.getYf()).put(-this._xAxis.getZf());
        this._meshData.getNormalBuffer().put(-this._yAxis.getXf()).put(-this._yAxis.getYf()).put(-this._yAxis.getZf());
        this._meshData.getNormalBuffer().put(-this._yAxis.getXf()).put(-this._yAxis.getYf()).put(-this._yAxis.getZf());
        this._meshData.getNormalBuffer().put(-this._yAxis.getXf()).put(-this._yAxis.getYf()).put(-this._yAxis.getZf());
        this._meshData.getNormalBuffer().put(-this._yAxis.getXf()).put(-this._yAxis.getYf()).put(-this._yAxis.getZf());
        this._meshData.getNormalBuffer().put(-this._zAxis.getXf()).put(-this._zAxis.getYf()).put(-this._zAxis.getZf());
        this._meshData.getNormalBuffer().put(-this._zAxis.getXf()).put(-this._zAxis.getYf()).put(-this._zAxis.getZf());
        this._meshData.getNormalBuffer().put(-this._zAxis.getXf()).put(-this._zAxis.getYf()).put(-this._zAxis.getZf());
        this._meshData.getNormalBuffer().put(-this._zAxis.getXf()).put(-this._zAxis.getYf()).put(-this._zAxis.getZf());
        this._meshData.getNormalBuffer().put(this._zAxis.getXf()).put(this._zAxis.getYf()).put(this._zAxis.getZf());
        this._meshData.getNormalBuffer().put(this._zAxis.getXf()).put(this._zAxis.getYf()).put(this._zAxis.getZf());
        this._meshData.getNormalBuffer().put(this._zAxis.getXf()).put(this._zAxis.getYf()).put(this._zAxis.getZf());
        this._meshData.getNormalBuffer().put(this._zAxis.getXf()).put(this._zAxis.getYf()).put(this._zAxis.getZf());
    }

    private void setVertexData() {
        this.computeCorners();
        if (this._meshData.getVertexBuffer() == null) {
            this._meshData.setVertexBuffer(BufferUtils.createVector3Buffer(24));
        } else {
            this._meshData.getVertexBuffer().rewind();
        }
        this._meshData.getVertexBuffer().put(this._vectorStore[0].getXf()).put(this._vectorStore[0].getYf()).put(this._vectorStore[0].getZf());
        this._meshData.getVertexBuffer().put(this._vectorStore[1].getXf()).put(this._vectorStore[1].getYf()).put(this._vectorStore[1].getZf());
        this._meshData.getVertexBuffer().put(this._vectorStore[5].getXf()).put(this._vectorStore[5].getYf()).put(this._vectorStore[5].getZf());
        this._meshData.getVertexBuffer().put(this._vectorStore[3].getXf()).put(this._vectorStore[3].getYf()).put(this._vectorStore[3].getZf());
        this._meshData.getVertexBuffer().put(this._vectorStore[0].getXf()).put(this._vectorStore[0].getYf()).put(this._vectorStore[0].getZf());
        this._meshData.getVertexBuffer().put(this._vectorStore[3].getXf()).put(this._vectorStore[3].getYf()).put(this._vectorStore[3].getZf());
        this._meshData.getVertexBuffer().put(this._vectorStore[6].getXf()).put(this._vectorStore[6].getYf()).put(this._vectorStore[6].getZf());
        this._meshData.getVertexBuffer().put(this._vectorStore[2].getXf()).put(this._vectorStore[2].getYf()).put(this._vectorStore[2].getZf());
        this._meshData.getVertexBuffer().put(this._vectorStore[5].getXf()).put(this._vectorStore[5].getYf()).put(this._vectorStore[5].getZf());
        this._meshData.getVertexBuffer().put(this._vectorStore[1].getXf()).put(this._vectorStore[1].getYf()).put(this._vectorStore[1].getZf());
        this._meshData.getVertexBuffer().put(this._vectorStore[4].getXf()).put(this._vectorStore[4].getYf()).put(this._vectorStore[4].getZf());
        this._meshData.getVertexBuffer().put(this._vectorStore[7].getXf()).put(this._vectorStore[7].getYf()).put(this._vectorStore[7].getZf());
        this._meshData.getVertexBuffer().put(this._vectorStore[6].getXf()).put(this._vectorStore[6].getYf()).put(this._vectorStore[6].getZf());
        this._meshData.getVertexBuffer().put(this._vectorStore[7].getXf()).put(this._vectorStore[7].getYf()).put(this._vectorStore[7].getZf());
        this._meshData.getVertexBuffer().put(this._vectorStore[4].getXf()).put(this._vectorStore[4].getYf()).put(this._vectorStore[4].getZf());
        this._meshData.getVertexBuffer().put(this._vectorStore[2].getXf()).put(this._vectorStore[2].getYf()).put(this._vectorStore[2].getZf());
        this._meshData.getVertexBuffer().put(this._vectorStore[3].getXf()).put(this._vectorStore[3].getYf()).put(this._vectorStore[3].getZf());
        this._meshData.getVertexBuffer().put(this._vectorStore[5].getXf()).put(this._vectorStore[5].getYf()).put(this._vectorStore[5].getZf());
        this._meshData.getVertexBuffer().put(this._vectorStore[7].getXf()).put(this._vectorStore[7].getYf()).put(this._vectorStore[7].getZf());
        this._meshData.getVertexBuffer().put(this._vectorStore[6].getXf()).put(this._vectorStore[6].getYf()).put(this._vectorStore[6].getZf());
        this._meshData.getVertexBuffer().put(this._vectorStore[1].getXf()).put(this._vectorStore[1].getYf()).put(this._vectorStore[1].getZf());
        this._meshData.getVertexBuffer().put(this._vectorStore[4].getXf()).put(this._vectorStore[4].getYf()).put(this._vectorStore[4].getZf());
        this._meshData.getVertexBuffer().put(this._vectorStore[2].getXf()).put(this._vectorStore[2].getYf()).put(this._vectorStore[2].getZf());
        this._meshData.getVertexBuffer().put(this._vectorStore[0].getXf()).put(this._vectorStore[0].getYf()).put(this._vectorStore[0].getZf());
    }

    public void computeCorners() {
        this._correctCorners = true;
        Vector3 tempVa = Vector3.fetchTempInstance();
        Vector3 tempVb = Vector3.fetchTempInstance();
        Vector3 tempVc = Vector3.fetchTempInstance();
        tempVa.set((ReadOnlyVector3)this._xAxis).multiplyLocal(this._extent.getX());
        tempVb.set((ReadOnlyVector3)this._yAxis).multiplyLocal(this._extent.getY());
        tempVc.set((ReadOnlyVector3)this._zAxis).multiplyLocal(this._extent.getZ());
        this._vectorStore[0].set((ReadOnlyVector3)this._center).addLocal((ReadOnlyVector3)tempVa).addLocal((ReadOnlyVector3)tempVb).addLocal((ReadOnlyVector3)tempVc);
        this._vectorStore[1].set((ReadOnlyVector3)this._center).addLocal((ReadOnlyVector3)tempVa).subtractLocal((ReadOnlyVector3)tempVb).addLocal((ReadOnlyVector3)tempVc);
        this._vectorStore[2].set((ReadOnlyVector3)this._center).addLocal((ReadOnlyVector3)tempVa).addLocal((ReadOnlyVector3)tempVb).subtractLocal((ReadOnlyVector3)tempVc);
        this._vectorStore[3].set((ReadOnlyVector3)this._center).subtractLocal((ReadOnlyVector3)tempVa).addLocal((ReadOnlyVector3)tempVb).addLocal((ReadOnlyVector3)tempVc);
        this._vectorStore[4].set((ReadOnlyVector3)this._center).addLocal((ReadOnlyVector3)tempVa).subtractLocal((ReadOnlyVector3)tempVb).subtractLocal((ReadOnlyVector3)tempVc);
        this._vectorStore[5].set((ReadOnlyVector3)this._center).subtractLocal((ReadOnlyVector3)tempVa).subtractLocal((ReadOnlyVector3)tempVb).addLocal((ReadOnlyVector3)tempVc);
        this._vectorStore[6].set((ReadOnlyVector3)this._center).subtractLocal((ReadOnlyVector3)tempVa).addLocal((ReadOnlyVector3)tempVb).subtractLocal((ReadOnlyVector3)tempVc);
        this._vectorStore[7].set((ReadOnlyVector3)this._center).subtractLocal((ReadOnlyVector3)tempVa).subtractLocal((ReadOnlyVector3)tempVb).subtractLocal((ReadOnlyVector3)tempVc);
        Vector3.releaseTempInstance((Vector3)tempVa);
        Vector3.releaseTempInstance((Vector3)tempVb);
        Vector3.releaseTempInstance((Vector3)tempVc);
    }

    public Vector3 getCenter() {
        return this._center;
    }

    public void setCenter(Vector3 center) {
        this._center = center;
    }

    public Vector3 getExtent() {
        return this._extent;
    }

    public void setExtent(Vector3 extent) {
        this._extent = extent;
    }

    public Vector3 getxAxis() {
        return this._xAxis;
    }

    public void setXAxis(Vector3 xAxis) {
        this._xAxis = xAxis;
    }

    public Vector3 getYAxis() {
        return this._yAxis;
    }

    public void setYAxis(Vector3 yAxis) {
        this._yAxis = yAxis;
    }

    public Vector3 getZAxis() {
        return this._zAxis;
    }

    public void setZAxis(Vector3 zAxis) {
        this._zAxis = zAxis;
    }

    public boolean isCorrectCorners() {
        return this._correctCorners;
    }

    @Override
    public void write(OutputCapsule capsule) throws IOException {
        super.write(capsule);
        capsule.write((Savable)this._center, "center", (Savable)new Vector3(Vector3.ZERO));
        capsule.write((Savable)this._xAxis, "_xAxis", (Savable)new Vector3(Vector3.UNIT_X));
        capsule.write((Savable)this._yAxis, "yAxis", (Savable)new Vector3(Vector3.UNIT_Y));
        capsule.write((Savable)this._zAxis, "zAxis", (Savable)new Vector3(Vector3.UNIT_Z));
        capsule.write((Savable)this._extent, "extent", (Savable)new Vector3(Vector3.ZERO));
        capsule.write((Savable)this._texTopRight, "texTopRight", (Savable)new Vector2(1.0, 1.0));
        capsule.write((Savable)this._texTopLeft, "texTopLeft", (Savable)new Vector2(1.0, 0.0));
        capsule.write((Savable)this._texBotRight, "texBotRight", (Savable)new Vector2(0.0, 1.0));
        capsule.write((Savable)this._texBotLeft, "texBotLeft", (Savable)new Vector2(0.0, 0.0));
        capsule.write((Savable[])this._vectorStore, "vectorStore", (Savable[])new Vector3[8]);
        capsule.write(this._correctCorners, "correctCorners", false);
    }

    @Override
    public void read(InputCapsule capsule) throws IOException {
        super.read(capsule);
        this._center = (Vector3)capsule.readSavable("center", (Savable)new Vector3(Vector3.ZERO));
        this._xAxis = (Vector3)capsule.readSavable("_xAxis", (Savable)new Vector3(Vector3.UNIT_X));
        this._yAxis = (Vector3)capsule.readSavable("yAxis", (Savable)new Vector3(Vector3.UNIT_Y));
        this._zAxis = (Vector3)capsule.readSavable("zAxis", (Savable)new Vector3(Vector3.UNIT_Z));
        this._extent = (Vector3)capsule.readSavable("extent", (Savable)new Vector3(Vector3.ZERO));
        this._texTopRight = (Vector2)capsule.readSavable("texTopRight", (Savable)new Vector2(1.0, 1.0));
        this._texTopLeft = (Vector2)capsule.readSavable("texTopLeft", (Savable)new Vector2(1.0, 0.0));
        this._texBotRight = (Vector2)capsule.readSavable("texBotRight", (Savable)new Vector2(0.0, 1.0));
        this._texBotLeft = (Vector2)capsule.readSavable("texBotLeft", (Savable)new Vector2(0.0, 0.0));
        this._vectorStore = (Vector3[])CapsuleUtils.asArray((Savable[])capsule.readSavableArray("vectorStore", (Savable[])new Vector3[8]), Vector3.class);
        this._correctCorners = capsule.readBoolean("correctCorners", false);
    }
}

