/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.scenegraph.shape;

import com.ardor3d.math.MathUtils;
import com.ardor3d.math.Vector3;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.scenegraph.IndexBufferData;
import com.ardor3d.scenegraph.Mesh;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.geom.BufferUtils;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.FloatBuffer;

public class PQTorus
extends Mesh {
    private double _p;
    private double _q;
    private double _radius;
    private double _width;
    private int _steps;
    private int _radialSamples;

    public PQTorus() {
    }

    public PQTorus(String name, double p, double q, double radius, double width, int steps, int radialSamples) {
        super(name);
        this._p = p;
        this._q = q;
        this._radius = radius;
        this._width = width;
        this._steps = steps;
        this._radialSamples = radialSamples;
        this.setGeometryData();
        this.setIndexData();
    }

    private void setGeometryData() {
        double THETA_STEP = Math.PI * 2 / (double)this._steps;
        double BETA_STEP = Math.PI * 2 / (double)this._radialSamples;
        Vector3[] toruspoints = new Vector3[this._steps];
        int verts = this._radialSamples * this._steps;
        this._meshData.setVertexBuffer(BufferUtils.createVector3Buffer(verts));
        this._meshData.setNormalBuffer(BufferUtils.createVector3Buffer(verts));
        this._meshData.setTextureBuffer(BufferUtils.createVector2Buffer(verts), 0);
        Vector3 pointB = Vector3.fetchTempInstance();
        Vector3 T = Vector3.fetchTempInstance();
        Vector3 N = Vector3.fetchTempInstance();
        Vector3 B = Vector3.fetchTempInstance();
        Vector3 tempNormA = Vector3.fetchTempInstance();
        Vector3 tempNormB = Vector3.fetchTempInstance();
        double theta = 0.0;
        double beta = 0.0;
        for (int i = 0; i < this._steps; ++i) {
            double circleFraction = (double)i / (double)this._steps;
            double r = 0.5 * (2.0 + MathUtils.sin((double)(this._q * (theta += THETA_STEP)))) * this._radius;
            double x = r * MathUtils.cos((double)(this._p * theta)) * this._radius;
            double y = r * MathUtils.sin((double)(this._p * theta)) * this._radius;
            double z = r * MathUtils.cos((double)(this._q * theta)) * this._radius;
            toruspoints[i] = new Vector3(x, y, z);
            r = 0.5 * (2.0 + MathUtils.sin((double)(this._q * (theta + 0.01)))) * this._radius;
            x = r * MathUtils.cos((double)(this._p * (theta + 0.01))) * this._radius;
            y = r * MathUtils.sin((double)(this._p * (theta + 0.01))) * this._radius;
            z = r * MathUtils.cos((double)(this._q * (theta + 0.01))) * this._radius;
            pointB.set(x, y, z);
            pointB.subtract((ReadOnlyVector3)toruspoints[i], T);
            toruspoints[i].add((ReadOnlyVector3)pointB, N);
            T.cross((ReadOnlyVector3)N, B);
            B.cross((ReadOnlyVector3)T, N);
            N.normalizeLocal();
            B.normalizeLocal();
            beta = 0.0;
            for (int j = 0; j < this._radialSamples; ++j) {
                double cx = MathUtils.cos((double)(beta += BETA_STEP)) * this._width;
                double cy = MathUtils.sin((double)beta) * this._width;
                double radialFraction = (double)j / (double)this._radialSamples;
                tempNormA.setX(cx * N.getX() + cy * B.getX());
                tempNormA.setY(cx * N.getY() + cy * B.getY());
                tempNormA.setZ(cx * N.getZ() + cy * B.getZ());
                tempNormA.normalize(tempNormB);
                tempNormA.addLocal((ReadOnlyVector3)toruspoints[i]);
                this._meshData.getVertexBuffer().put(tempNormA.getXf()).put(tempNormA.getYf()).put(tempNormA.getZf());
                this._meshData.getNormalBuffer().put(tempNormB.getXf()).put(tempNormB.getYf()).put(tempNormB.getZf());
                ((FloatBuffer)this._meshData.getTextureCoords(0).getBuffer()).put((float)radialFraction).put((float)circleFraction);
            }
        }
        Vector3.releaseTempInstance((Vector3)tempNormA);
        Vector3.releaseTempInstance((Vector3)tempNormB);
        Vector3.releaseTempInstance((Vector3)T);
        Vector3.releaseTempInstance((Vector3)N);
        Vector3.releaseTempInstance((Vector3)B);
        Vector3.releaseTempInstance((Vector3)pointB);
    }

    private void setIndexData() {
        int i;
        IndexBufferData<?> indices = BufferUtils.createIndexBufferData(6 * this._meshData.getVertexCount(), this._meshData.getVertexCount() - 1);
        for (i = this._radialSamples; i < this._meshData.getVertexCount() + this._radialSamples; ++i) {
            indices.put(i);
            indices.put(i - this._radialSamples);
            indices.put(i + 1);
            indices.put(i + 1);
            indices.put(i - this._radialSamples);
            indices.put(i - this._radialSamples + 1);
        }
        int len = indices.getBufferCapacity();
        for (i = 0; i < len; ++i) {
            int ind = indices.get(i);
            if (ind < 0) {
                indices.put(i, ind += this._meshData.getVertexCount());
            }
            if (ind < this._meshData.getVertexCount()) continue;
            indices.put(i, ind -= this._meshData.getVertexCount());
        }
        ((Buffer)indices.getBuffer()).rewind();
        this._meshData.setIndices(indices);
    }

    @Override
    public void write(OutputCapsule capsule) throws IOException {
        super.write(capsule);
        capsule.write(this._p, "p", 0.0);
        capsule.write(this._q, "q", 0.0);
        capsule.write(this._radius, "radius", 0.0);
        capsule.write(this._width, "width", 0.0);
        capsule.write(this._steps, "steps", 0);
        capsule.write(this._radialSamples, "radialSamples", 0);
    }

    @Override
    public void read(InputCapsule capsule) throws IOException {
        super.read(capsule);
        this._p = capsule.readDouble("p", 0.0);
        this._q = capsule.readDouble("q", 0.0);
        this._radius = capsule.readDouble("radius", 0.0);
        this._width = capsule.readDouble("width", 0.0);
        this._steps = capsule.readInt("steps", 0);
        this._radialSamples = capsule.readInt("radialSamples", 0);
    }
}

