/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.scenegraph.shape;

import com.ardor3d.math.Vector3;
import com.ardor3d.scenegraph.IndexBufferData;
import com.ardor3d.scenegraph.Mesh;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.geom.BufferUtils;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.FloatBuffer;

public class Pyramid
extends Mesh {
    private double _height;
    private double _width;

    public Pyramid() {
    }

    public Pyramid(String name, double width, double height) {
        super(name);
        this._width = width;
        this._height = height;
        this.setVertexData();
        this.setNormalData();
        this.setTextureData();
        this.setIndexData();
    }

    private void setVertexData() {
        Vector3 peak = new Vector3(0.0, this._height / 2.0, 0.0);
        Vector3 vert0 = new Vector3(-this._width / 2.0, -this._height / 2.0, -this._width / 2.0);
        Vector3 vert1 = new Vector3(this._width / 2.0, -this._height / 2.0, -this._width / 2.0);
        Vector3 vert2 = new Vector3(this._width / 2.0, -this._height / 2.0, this._width / 2.0);
        Vector3 vert3 = new Vector3(-this._width / 2.0, -this._height / 2.0, this._width / 2.0);
        FloatBuffer verts = BufferUtils.createVector3Buffer(16);
        verts.put(vert3.getXf()).put(vert3.getYf()).put(vert3.getZf());
        verts.put(vert2.getXf()).put(vert2.getYf()).put(vert2.getZf());
        verts.put(vert1.getXf()).put(vert1.getYf()).put(vert1.getZf());
        verts.put(vert0.getXf()).put(vert0.getYf()).put(vert0.getZf());
        verts.put(vert0.getXf()).put(vert0.getYf()).put(vert0.getZf());
        verts.put(vert1.getXf()).put(vert1.getYf()).put(vert1.getZf());
        verts.put(peak.getXf()).put(peak.getYf()).put(peak.getZf());
        verts.put(vert1.getXf()).put(vert1.getYf()).put(vert1.getZf());
        verts.put(vert2.getXf()).put(vert2.getYf()).put(vert2.getZf());
        verts.put(peak.getXf()).put(peak.getYf()).put(peak.getZf());
        verts.put(vert2.getXf()).put(vert2.getYf()).put(vert2.getZf());
        verts.put(vert3.getXf()).put(vert3.getYf()).put(vert3.getZf());
        verts.put(peak.getXf()).put(peak.getYf()).put(peak.getZf());
        verts.put(vert3.getXf()).put(vert3.getYf()).put(vert3.getZf());
        verts.put(vert0.getXf()).put(vert0.getYf()).put(vert0.getZf());
        verts.put(peak.getXf()).put(peak.getYf()).put(peak.getZf());
        verts.rewind();
        this._meshData.setVertexBuffer(verts);
    }

    private void setNormalData() {
        FloatBuffer norms = BufferUtils.createVector3Buffer(16);
        norms.put(0.0f).put(-1.0f).put(0.0f);
        norms.put(0.0f).put(-1.0f).put(0.0f);
        norms.put(0.0f).put(-1.0f).put(0.0f);
        norms.put(0.0f).put(-1.0f).put(0.0f);
        norms.put(0.0f).put(0.70710677f).put(-0.70710677f);
        norms.put(0.0f).put(0.70710677f).put(-0.70710677f);
        norms.put(0.0f).put(0.70710677f).put(-0.70710677f);
        norms.put(0.70710677f).put(0.70710677f).put(0.0f);
        norms.put(0.70710677f).put(0.70710677f).put(0.0f);
        norms.put(0.70710677f).put(0.70710677f).put(0.0f);
        norms.put(0.0f).put(0.70710677f).put(0.70710677f);
        norms.put(0.0f).put(0.70710677f).put(0.70710677f);
        norms.put(0.0f).put(0.70710677f).put(0.70710677f);
        norms.put(-0.70710677f).put(0.70710677f).put(0.0f);
        norms.put(-0.70710677f).put(0.70710677f).put(0.0f);
        norms.put(-0.70710677f).put(0.70710677f).put(0.0f);
        norms.rewind();
        this._meshData.setNormalBuffer(norms);
    }

    private void setTextureData() {
        FloatBuffer texCoords = BufferUtils.createVector2Buffer(16);
        texCoords.put(1.0f).put(0.0f);
        texCoords.put(0.0f).put(0.0f);
        texCoords.put(0.0f).put(1.0f);
        texCoords.put(1.0f).put(1.0f);
        texCoords.put(1.0f).put(0.0f);
        texCoords.put(0.75f).put(0.0f);
        texCoords.put(0.5f).put(1.0f);
        texCoords.put(0.75f).put(0.0f);
        texCoords.put(0.5f).put(0.0f);
        texCoords.put(0.5f).put(1.0f);
        texCoords.put(0.5f).put(0.0f);
        texCoords.put(0.25f).put(0.0f);
        texCoords.put(0.5f).put(1.0f);
        texCoords.put(0.25f).put(0.0f);
        texCoords.put(0.0f).put(0.0f);
        texCoords.put(0.5f).put(1.0f);
        texCoords.rewind();
        this._meshData.setTextureBuffer(texCoords, 0);
    }

    private void setIndexData() {
        IndexBufferData<?> indices = BufferUtils.createIndexBufferData(18, 15);
        indices.put(3).put(2).put(1);
        indices.put(3).put(1).put(0);
        indices.put(6).put(5).put(4);
        indices.put(9).put(8).put(7);
        indices.put(12).put(11).put(10);
        indices.put(15).put(14).put(13);
        ((Buffer)indices.getBuffer()).rewind();
        this._meshData.setIndices(indices);
    }

    @Override
    public void write(OutputCapsule capsule) throws IOException {
        super.write(capsule);
        capsule.write(this._height, "height", 0.0);
        capsule.write(this._width, "width", 0.0);
    }

    @Override
    public void read(InputCapsule capsule) throws IOException {
        super.read(capsule);
        this._height = capsule.readDouble("height", 0.0);
        this._width = capsule.readDouble("width", 0.0);
    }
}

