/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.scenegraph.shape;

import com.ardor3d.scenegraph.Mesh;
import com.ardor3d.util.geom.BufferUtils;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;

public class Quad
extends Mesh {
    protected double _width = 0.0;
    protected double _height = 0.0;

    public Quad() {
    }

    public Quad(String name) {
        this(name, 1.0, 1.0);
    }

    public Quad(String name, double width, double height) {
        super(name);
        this.initialize(width, height);
    }

    public void resize(double width, double height) {
        this._width = width;
        this._height = height;
        this._meshData.getVertexBuffer().clear();
        this._meshData.getVertexBuffer().put((float)(-width / 2.0)).put((float)(height / 2.0)).put(0.0f);
        this._meshData.getVertexBuffer().put((float)(-width / 2.0)).put((float)(-height / 2.0)).put(0.0f);
        this._meshData.getVertexBuffer().put((float)(width / 2.0)).put((float)(-height / 2.0)).put(0.0f);
        this._meshData.getVertexBuffer().put((float)(width / 2.0)).put((float)(height / 2.0)).put(0.0f);
    }

    private void initialize(double width, double height) {
        int verts = 4;
        this._meshData.setVertexBuffer(BufferUtils.createVector3Buffer(4));
        this._meshData.setNormalBuffer(BufferUtils.createVector3Buffer(4));
        FloatBuffer tbuf = BufferUtils.createVector2Buffer(4);
        this._meshData.setTextureBuffer(tbuf, 0);
        this._meshData.getNormalBuffer().put(0.0f).put(0.0f).put(1.0f);
        this._meshData.getNormalBuffer().put(0.0f).put(0.0f).put(1.0f);
        this._meshData.getNormalBuffer().put(0.0f).put(0.0f).put(1.0f);
        this._meshData.getNormalBuffer().put(0.0f).put(0.0f).put(1.0f);
        tbuf.put(0.0f).put(1.0f);
        tbuf.put(0.0f).put(0.0f);
        tbuf.put(1.0f).put(0.0f);
        tbuf.put(1.0f).put(1.0f);
        byte[] indices = new byte[]{0, 1, 2, 0, 2, 3};
        ByteBuffer buf = BufferUtils.createByteBuffer(indices.length);
        buf.put(indices);
        buf.rewind();
        this._meshData.setIndexBuffer(buf);
        this.resize(width, height);
    }

    public double getWidth() {
        return this._width;
    }

    public double getHeight() {
        return this._height;
    }
}

