/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.scenegraph.shape;

import com.ardor3d.math.Vector3;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.scenegraph.IndexBufferData;
import com.ardor3d.scenegraph.Mesh;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.export.Savable;
import com.ardor3d.util.geom.BufferUtils;
import java.io.IOException;
import java.nio.FloatBuffer;

public class RoundedBox
extends Mesh {
    private final Vector3 _extent = new Vector3(0.5, 0.5, 0.5);
    private final Vector3 _border = new Vector3(0.05, 0.05, 0.05);
    private final Vector3 _slope = new Vector3(0.02, 0.02, 0.02);

    public RoundedBox(String name) {
        super(name);
        this.setData();
    }

    public RoundedBox(String name, Vector3 extent) {
        super(name);
        extent.subtract((ReadOnlyVector3)this._slope, this._extent);
        this.setData();
    }

    public RoundedBox(String name, Vector3 extent, Vector3 border, Vector3 slope) {
        super(name);
        this._border.set((ReadOnlyVector3)border);
        this._slope.set((ReadOnlyVector3)slope);
        extent.subtract((ReadOnlyVector3)this._slope, this._extent);
        this.setData();
    }

    private void setData() {
        this.setVertexAndNormalData();
        this.setTextureData();
        this.setIndexData();
    }

    private void put(FloatBuffer fb, FloatBuffer nb, Vector3 vec) {
        fb.put((float)vec.getX()).put((float)vec.getY()).put((float)vec.getZ());
        Vector3 v = vec.normalize(Vector3.fetchTempInstance());
        nb.put((float)v.getX()).put((float)v.getY()).put((float)v.getZ());
        Vector3.releaseTempInstance((Vector3)v);
    }

    private void setVertexAndNormalData() {
        this._meshData.setVertexBuffer(BufferUtils.createVector3Buffer(this._meshData.getVertexBuffer(), 48));
        this._meshData.setNormalBuffer(BufferUtils.createVector3Buffer(48));
        Vector3[] vert = this.computeVertices();
        FloatBuffer vb = this._meshData.getVertexBuffer();
        FloatBuffer nb = this._meshData.getNormalBuffer();
        this.put(vb, nb, vert[0]);
        this.put(vb, nb, vert[1]);
        this.put(vb, nb, vert[2]);
        this.put(vb, nb, vert[3]);
        this.put(vb, nb, vert[8]);
        this.put(vb, nb, vert[9]);
        this.put(vb, nb, vert[10]);
        this.put(vb, nb, vert[11]);
        this.put(vb, nb, vert[1]);
        this.put(vb, nb, vert[0]);
        this.put(vb, nb, vert[5]);
        this.put(vb, nb, vert[4]);
        this.put(vb, nb, vert[13]);
        this.put(vb, nb, vert[12]);
        this.put(vb, nb, vert[15]);
        this.put(vb, nb, vert[14]);
        this.put(vb, nb, vert[3]);
        this.put(vb, nb, vert[1]);
        this.put(vb, nb, vert[7]);
        this.put(vb, nb, vert[5]);
        this.put(vb, nb, vert[17]);
        this.put(vb, nb, vert[16]);
        this.put(vb, nb, vert[19]);
        this.put(vb, nb, vert[18]);
        this.put(vb, nb, vert[2]);
        this.put(vb, nb, vert[3]);
        this.put(vb, nb, vert[6]);
        this.put(vb, nb, vert[7]);
        this.put(vb, nb, vert[20]);
        this.put(vb, nb, vert[21]);
        this.put(vb, nb, vert[22]);
        this.put(vb, nb, vert[23]);
        this.put(vb, nb, vert[0]);
        this.put(vb, nb, vert[2]);
        this.put(vb, nb, vert[4]);
        this.put(vb, nb, vert[6]);
        this.put(vb, nb, vert[24]);
        this.put(vb, nb, vert[25]);
        this.put(vb, nb, vert[26]);
        this.put(vb, nb, vert[27]);
        this.put(vb, nb, vert[5]);
        this.put(vb, nb, vert[4]);
        this.put(vb, nb, vert[7]);
        this.put(vb, nb, vert[6]);
        this.put(vb, nb, vert[29]);
        this.put(vb, nb, vert[28]);
        this.put(vb, nb, vert[31]);
        this.put(vb, nb, vert[30]);
    }

    private void setTextureData() {
        if (this._meshData.getTextureCoords(0) == null) {
            this._meshData.setTextureBuffer(BufferUtils.createVector2Buffer(48), 0);
            FloatBuffer tex = (FloatBuffer)this._meshData.getTextureCoords(0).getBuffer();
            double[][] ratio = new double[][]{{0.5 * this._border.getX() / (this._extent.getX() + this._slope.getX()), 0.5 * this._border.getZ() / (this._extent.getZ() + this._slope.getZ())}, {0.5 * this._border.getX() / (this._extent.getX() + this._slope.getX()), 0.5 * this._border.getY() / (this._extent.getY() + this._slope.getY())}, {0.5 * this._border.getZ() / (this._extent.getZ() + this._slope.getZ()), 0.5 * this._border.getY() / (this._extent.getY() + this._slope.getY())}, {0.5 * this._border.getX() / (this._extent.getX() + this._slope.getX()), 0.5 * this._border.getY() / (this._extent.getY() + this._slope.getY())}, {0.5 * this._border.getZ() / (this._extent.getZ() + this._slope.getZ()), 0.5 * this._border.getY() / (this._extent.getY() + this._slope.getY())}, {0.5 * this._border.getX() / (this._extent.getX() + this._slope.getX()), 0.5 * this._border.getZ() / (this._extent.getZ() + this._slope.getZ())}};
            for (int i = 0; i < 6; ++i) {
                tex.put(1.0f).put(0.0f);
                tex.put(0.0f).put(0.0f);
                tex.put(1.0f).put(1.0f);
                tex.put(0.0f).put(1.0f);
                tex.put((float)(1.0 - ratio[i][0])).put((float)(0.0 + ratio[i][1]));
                tex.put((float)(0.0 + ratio[i][0])).put((float)(0.0 + ratio[i][1]));
                tex.put((float)(1.0 - ratio[i][0])).put((float)(1.0 - ratio[i][1]));
                tex.put((float)(0.0 + ratio[i][0])).put((float)(1.0 - ratio[i][1]));
            }
        }
    }

    private void setIndexData() {
        if (this._meshData.getIndices() == null) {
            IndexBufferData<?> buff = BufferUtils.createIndexBufferData(180, 47);
            int[] data = new int[]{0, 4, 1, 1, 4, 5, 1, 5, 3, 3, 5, 7, 3, 7, 2, 2, 7, 6, 2, 6, 0, 0, 6, 4, 4, 6, 5, 5, 6, 7};
            for (int i = 0; i < 6; ++i) {
                for (int n = 0; n < 30; ++n) {
                    buff.put(30 * i + n, 8 * i + data[n]);
                }
            }
            this._meshData.setIndices(buff);
        }
    }

    public Vector3[] computeVertices() {
        return new Vector3[]{new Vector3(-this._extent.getX(), -this._extent.getY(), this._extent.getZ()), new Vector3(this._extent.getX(), -this._extent.getY(), this._extent.getZ()), new Vector3(-this._extent.getX(), -this._extent.getY(), -this._extent.getZ()), new Vector3(this._extent.getX(), -this._extent.getY(), -this._extent.getZ()), new Vector3(-this._extent.getX(), this._extent.getY(), this._extent.getZ()), new Vector3(this._extent.getX(), this._extent.getY(), this._extent.getZ()), new Vector3(-this._extent.getX(), this._extent.getY(), -this._extent.getZ()), new Vector3(this._extent.getX(), this._extent.getY(), -this._extent.getZ()), new Vector3(-this._extent.getX() + this._border.getX(), -this._extent.getY() - this._slope.getY(), this._extent.getZ() - this._border.getZ()), new Vector3(this._extent.getX() - this._border.getX(), -this._extent.getY() - this._slope.getY(), this._extent.getZ() - this._border.getZ()), new Vector3(-this._extent.getX() + this._border.getX(), -this._extent.getY() - this._slope.getY(), -this._extent.getZ() + this._border.getZ()), new Vector3(this._extent.getX() - this._border.getX(), -this._extent.getY() - this._slope.getY(), -this._extent.getZ() + this._border.getZ()), new Vector3(-this._extent.getX() + this._border.getX(), -this._extent.getY() + this._border.getY(), this._extent.getZ() + this._slope.getZ()), new Vector3(this._extent.getX() - this._border.getX(), -this._extent.getY() + this._border.getY(), this._extent.getZ() + this._slope.getZ()), new Vector3(-this._extent.getX() + this._border.getX(), this._extent.getY() - this._border.getY(), this._extent.getZ() + this._slope.getZ()), new Vector3(this._extent.getX() - this._border.getX(), this._extent.getY() - this._border.getY(), this._extent.getZ() + this._slope.getZ()), new Vector3(this._extent.getX() + this._slope.getX(), -this._extent.getY() + this._border.getY(), this._extent.getZ() - this._border.getZ()), new Vector3(this._extent.getX() + this._slope.getX(), -this._extent.getY() + this._border.getY(), -this._extent.getZ() + this._border.getZ()), new Vector3(this._extent.getX() + this._slope.getX(), this._extent.getY() - this._border.getY(), this._extent.getZ() - this._border.getZ()), new Vector3(this._extent.getX() + this._slope.getX(), this._extent.getY() - this._border.getY(), -this._extent.getZ() + this._border.getZ()), new Vector3(-this._extent.getX() + this._border.getX(), -this._extent.getY() + this._border.getY(), -this._extent.getZ() - this._slope.getZ()), new Vector3(this._extent.getX() - this._border.getX(), -this._extent.getY() + this._border.getY(), -this._extent.getZ() - this._slope.getZ()), new Vector3(-this._extent.getX() + this._border.getX(), this._extent.getY() - this._border.getY(), -this._extent.getZ() - this._slope.getZ()), new Vector3(this._extent.getX() - this._border.getX(), this._extent.getY() - this._border.getY(), -this._extent.getZ() - this._slope.getZ()), new Vector3(-this._extent.getX() - this._slope.getX(), -this._extent.getY() + this._border.getY(), this._extent.getZ() - this._border.getZ()), new Vector3(-this._extent.getX() - this._slope.getX(), -this._extent.getY() + this._border.getY(), -this._extent.getZ() + this._border.getZ()), new Vector3(-this._extent.getX() - this._slope.getX(), this._extent.getY() - this._border.getY(), this._extent.getZ() - this._border.getZ()), new Vector3(-this._extent.getX() - this._slope.getX(), this._extent.getY() - this._border.getY(), -this._extent.getZ() + this._border.getZ()), new Vector3(-this._extent.getX() + this._border.getX(), this._extent.getY() + this._slope.getY(), this._extent.getZ() - this._border.getZ()), new Vector3(this._extent.getX() - this._border.getX(), this._extent.getY() + this._slope.getY(), this._extent.getZ() - this._border.getZ()), new Vector3(-this._extent.getX() + this._border.getX(), this._extent.getY() + this._slope.getY(), -this._extent.getZ() + this._border.getZ()), new Vector3(this._extent.getX() - this._border.getX(), this._extent.getY() + this._slope.getY(), -this._extent.getZ() + this._border.getZ())};
    }

    public RoundedBox clone() {
        return new RoundedBox(this.getName() + "_clone", this._extent.clone(), this._border.clone(), this._slope.clone());
    }

    @Override
    public void write(OutputCapsule capsule) throws IOException {
        super.write(capsule);
        capsule.write((Savable)this._extent, "extent", (Savable)new Vector3(Vector3.ZERO));
        capsule.write((Savable)this._border, "border", (Savable)new Vector3(Vector3.ZERO));
        capsule.write((Savable)this._slope, "slope", (Savable)new Vector3(Vector3.ZERO));
    }

    @Override
    public void read(InputCapsule capsule) throws IOException {
        super.read(capsule);
        this._extent.set((ReadOnlyVector3)((Vector3)capsule.readSavable("extent", (Savable)new Vector3(Vector3.ZERO))));
        this._border.set((ReadOnlyVector3)((Vector3)capsule.readSavable("border", (Savable)new Vector3(Vector3.ZERO))));
        this._slope.set((ReadOnlyVector3)((Vector3)capsule.readSavable("slope", (Savable)new Vector3(Vector3.ZERO))));
    }
}

