/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.scenegraph.shape;

import com.ardor3d.math.MathUtils;
import com.ardor3d.math.Vector3;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.scenegraph.FloatBufferData;
import com.ardor3d.scenegraph.Mesh;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.export.Savable;
import com.ardor3d.util.geom.BufferUtils;
import java.io.IOException;
import java.nio.FloatBuffer;

public class Sphere
extends Mesh {
    protected int _zSamples;
    protected int _radialSamples;
    public double _radius;
    public final Vector3 _center = new Vector3();
    protected TextureMode _textureMode = TextureMode.Linear;
    protected boolean _viewInside = false;

    public Sphere() {
    }

    public Sphere(String name) {
        super(name);
    }

    public Sphere(String name, int zSamples, int radialSamples, double radius) {
        this(name, (ReadOnlyVector3)new Vector3(0.0, 0.0, 0.0), zSamples, radialSamples, radius);
    }

    public Sphere(String name, ReadOnlyVector3 center, int zSamples, int radialSamples, double radius) {
        super(name);
        this.setData(center, zSamples, radialSamples, radius);
    }

    public Sphere(String name, ReadOnlyVector3 center, int zSamples, int radialSamples, double radius, TextureMode textureMode) {
        super(name);
        this._textureMode = textureMode;
        this.setData(center, zSamples, radialSamples, radius);
    }

    public void setData(ReadOnlyVector3 center, int zSamples, int radialSamples, double radius) {
        this._center.set(center);
        this._zSamples = zSamples;
        this._radialSamples = radialSamples;
        this._radius = radius;
        this.setGeometryData();
        this.setIndexData();
    }

    private void setGeometryData() {
        int verts = (this._zSamples - 2) * (this._radialSamples + 1) + 2;
        FloatBufferData vertsData = this._meshData.getVertexCoords();
        if (vertsData == null) {
            this._meshData.setVertexBuffer(BufferUtils.createVector3Buffer(verts));
        } else {
            vertsData.setBuffer(BufferUtils.createVector3Buffer((FloatBuffer)vertsData.getBuffer(), verts));
        }
        FloatBufferData normsData = this._meshData.getNormalCoords();
        if (normsData == null) {
            this._meshData.setNormalBuffer(BufferUtils.createVector3Buffer(verts));
        } else {
            normsData.setBuffer(BufferUtils.createVector3Buffer((FloatBuffer)normsData.getBuffer(), verts));
        }
        FloatBufferData texData = this._meshData.getTextureCoords(0);
        if (texData == null) {
            this._meshData.setTextureBuffer(BufferUtils.createVector2Buffer(verts), 0);
        } else {
            texData.setBuffer(BufferUtils.createVector2Buffer((FloatBuffer)texData.getBuffer(), verts));
        }
        double fInvRS = 1.0 / (double)this._radialSamples;
        double fZFactor = 2.0 / (double)(this._zSamples - 1);
        double[] afSin = new double[this._radialSamples + 1];
        double[] afCos = new double[this._radialSamples + 1];
        for (int iR = 0; iR < this._radialSamples; ++iR) {
            double fAngle = Math.PI * 2 * fInvRS * (double)iR;
            afCos[iR] = MathUtils.cos((double)fAngle);
            afSin[iR] = MathUtils.sin((double)fAngle);
        }
        afSin[this._radialSamples] = afSin[0];
        afCos[this._radialSamples] = afCos[0];
        int i = 0;
        Vector3 tempVa = Vector3.fetchTempInstance();
        Vector3 tempVb = Vector3.fetchTempInstance();
        Vector3 tempVc = Vector3.fetchTempInstance();
        for (int iZ = 1; iZ < this._zSamples - 1; ++iZ) {
            double fAFraction = 1.5707963267948966 * (-1.0 + fZFactor * (double)iZ);
            double fZFraction = MathUtils.sin((double)fAFraction);
            double fZ = this._radius * fZFraction;
            Vector3 kSliceCenter = tempVb.set((ReadOnlyVector3)this._center);
            kSliceCenter.setZ(kSliceCenter.getZ() + fZ);
            double fSliceRadius = Math.sqrt(Math.abs(this._radius * this._radius - fZ * fZ));
            int iSave = i;
            for (int iR = 0; iR < this._radialSamples; ++iR) {
                double fRadialFraction = (double)iR * fInvRS;
                Vector3 kRadial = tempVc.set(afCos[iR], afSin[iR], 0.0);
                kRadial.multiply(fSliceRadius, tempVa);
                this._meshData.getVertexBuffer().put((float)(kSliceCenter.getX() + tempVa.getX())).put((float)(kSliceCenter.getY() + tempVa.getY())).put((float)(kSliceCenter.getZ() + tempVa.getZ()));
                BufferUtils.populateFromBuffer(tempVa, this._meshData.getVertexBuffer(), i);
                Vector3 kNormal = tempVa.subtractLocal((ReadOnlyVector3)this._center);
                kNormal.normalizeLocal();
                if (!this._viewInside) {
                    this._meshData.getNormalBuffer().put(kNormal.getXf()).put(kNormal.getYf()).put(kNormal.getZf());
                } else {
                    this._meshData.getNormalBuffer().put(-kNormal.getXf()).put(-kNormal.getYf()).put(-kNormal.getZf());
                }
                if (this._textureMode == TextureMode.Linear) {
                    ((FloatBuffer)this._meshData.getTextureCoords(0).getBuffer()).put((float)fRadialFraction).put((float)(0.5 * (fZFraction + 1.0)));
                } else if (this._textureMode == TextureMode.Projected) {
                    ((FloatBuffer)this._meshData.getTextureCoords(0).getBuffer()).put((float)fRadialFraction).put((float)(0.3183098861837907 * (1.5707963267948966 + Math.asin(fZFraction))));
                } else if (this._textureMode == TextureMode.Polar) {
                    double r = (1.5707963267948966 - Math.abs(fAFraction)) / Math.PI;
                    double u = r * afCos[iR] + 0.5;
                    double v = r * afSin[iR] + 0.5;
                    ((FloatBuffer)this._meshData.getTextureCoords(0).getBuffer()).put((float)u).put((float)v);
                }
                ++i;
            }
            BufferUtils.copyInternalVector3(this._meshData.getVertexBuffer(), iSave, i);
            BufferUtils.copyInternalVector3(this._meshData.getNormalBuffer(), iSave, i);
            if (this._textureMode == TextureMode.Linear) {
                ((FloatBuffer)this._meshData.getTextureCoords(0).getBuffer()).put(1.0f).put((float)(0.5 * (fZFraction + 1.0)));
            } else if (this._textureMode == TextureMode.Projected) {
                ((FloatBuffer)this._meshData.getTextureCoords(0).getBuffer()).put(1.0f).put((float)(0.3183098861837907 * (1.5707963267948966 + Math.asin(fZFraction))));
            } else if (this._textureMode == TextureMode.Polar) {
                float r = (float)((1.5707963267948966 - Math.abs(fAFraction)) / Math.PI);
                ((FloatBuffer)this._meshData.getTextureCoords(0).getBuffer()).put(r + 0.5f).put(0.5f);
            }
            ++i;
        }
        this._meshData.getVertexBuffer().position(i * 3);
        this._meshData.getVertexBuffer().put(this._center.getXf()).put(this._center.getYf()).put((float)(this._center.getZ() - this._radius));
        this._meshData.getNormalBuffer().position(i * 3);
        if (!this._viewInside) {
            this._meshData.getNormalBuffer().put(0.0f).put(0.0f).put(-1.0f);
        } else {
            this._meshData.getNormalBuffer().put(0.0f).put(0.0f).put(1.0f);
        }
        ((FloatBuffer)this._meshData.getTextureCoords(0).getBuffer()).position(i * 2);
        if (this._textureMode == TextureMode.Polar) {
            ((FloatBuffer)this._meshData.getTextureCoords(0).getBuffer()).put(0.5f).put(0.5f);
        } else {
            ((FloatBuffer)this._meshData.getTextureCoords(0).getBuffer()).put(0.5f).put(0.0f);
        }
        ++i;
        this._meshData.getVertexBuffer().put(this._center.getXf()).put(this._center.getYf()).put((float)(this._center.getZ() + this._radius));
        if (!this._viewInside) {
            this._meshData.getNormalBuffer().put(0.0f).put(0.0f).put(1.0f);
        } else {
            this._meshData.getNormalBuffer().put(0.0f).put(0.0f).put(-1.0f);
        }
        if (this._textureMode == TextureMode.Polar) {
            ((FloatBuffer)this._meshData.getTextureCoords(0).getBuffer()).put(0.5f).put(0.5f);
        } else {
            ((FloatBuffer)this._meshData.getTextureCoords(0).getBuffer()).put(0.5f).put(1.0f);
        }
        Vector3.releaseTempInstance((Vector3)tempVa);
        Vector3.releaseTempInstance((Vector3)tempVb);
        Vector3.releaseTempInstance((Vector3)tempVc);
    }

    private void setIndexData() {
        int verts = (this._zSamples - 2) * (this._radialSamples + 1) + 2;
        int tris = 2 * (this._zSamples - 2) * this._radialSamples;
        this._meshData.setIndices(BufferUtils.createIndexBufferData(3 * tris, verts - 1));
        int iZStart = 0;
        for (int iZ = 0; iZ < this._zSamples - 3; ++iZ) {
            int i0 = iZStart;
            int i1 = i0 + 1;
            int i2 = iZStart += this._radialSamples + 1;
            int i3 = i2 + 1;
            for (int i = 0; i < this._radialSamples; ++i) {
                if (!this._viewInside) {
                    this._meshData.getIndices().put(i0++);
                    this._meshData.getIndices().put(i1);
                    this._meshData.getIndices().put(i2);
                    this._meshData.getIndices().put(i1++);
                    this._meshData.getIndices().put(i3++);
                    this._meshData.getIndices().put(i2++);
                    continue;
                }
                this._meshData.getIndices().put(i0++);
                this._meshData.getIndices().put(i2);
                this._meshData.getIndices().put(i1);
                this._meshData.getIndices().put(i1++);
                this._meshData.getIndices().put(i2++);
                this._meshData.getIndices().put(i3++);
            }
        }
        for (int i = 0; i < this._radialSamples; ++i) {
            if (!this._viewInside) {
                this._meshData.getIndices().put(i);
                this._meshData.getIndices().put(this._meshData.getVertexCount() - 2);
                this._meshData.getIndices().put(i + 1);
                continue;
            }
            this._meshData.getIndices().put(i);
            this._meshData.getIndices().put(i + 1);
            this._meshData.getIndices().put(this._meshData.getVertexCount() - 2);
        }
        int iOffset = (this._zSamples - 3) * (this._radialSamples + 1);
        for (int i = 0; i < this._radialSamples; ++i) {
            if (!this._viewInside) {
                this._meshData.getIndices().put(i + iOffset);
                this._meshData.getIndices().put(i + 1 + iOffset);
                this._meshData.getIndices().put(this._meshData.getVertexCount() - 1);
                continue;
            }
            this._meshData.getIndices().put(i + iOffset);
            this._meshData.getIndices().put(this._meshData.getVertexCount() - 1);
            this._meshData.getIndices().put(i + 1 + iOffset);
        }
    }

    public Vector3 getCenter() {
        return this._center;
    }

    public boolean isViewFromInside() {
        return this._viewInside;
    }

    public void setViewFromInside(boolean viewInside) {
        if (viewInside != this._viewInside) {
            this._viewInside = viewInside;
            this.setGeometryData();
            this.setIndexData();
        }
    }

    public TextureMode getTextureMode() {
        return this._textureMode;
    }

    public void setTextureMode(TextureMode textureMode) {
        this._textureMode = textureMode;
        this.setGeometryData();
        this.setIndexData();
    }

    public double getRadius() {
        return this._radius;
    }

    @Override
    public void write(OutputCapsule capsule) throws IOException {
        super.write(capsule);
        capsule.write(this._zSamples, "zSamples", 0);
        capsule.write(this._radialSamples, "radialSamples", 0);
        capsule.write(this._radius, "radius", 0.0);
        capsule.write((Savable)this._center, "center", (Savable)new Vector3(Vector3.ZERO));
        capsule.write((Enum)this._textureMode, "textureMode", (Enum)TextureMode.Linear);
        capsule.write(this._viewInside, "viewInside", false);
    }

    @Override
    public void read(InputCapsule capsule) throws IOException {
        super.read(capsule);
        this._zSamples = capsule.readInt("zSamples", 0);
        this._radialSamples = capsule.readInt("radialSamples", 0);
        this._radius = capsule.readDouble("radius", 0.0);
        this._center.set((ReadOnlyVector3)((Vector3)capsule.readSavable("center", (Savable)new Vector3(Vector3.ZERO))));
        this._textureMode = (TextureMode)capsule.readEnum("textureMode", TextureMode.class, (Enum)TextureMode.Linear);
        this._viewInside = capsule.readBoolean("viewInside", false);
    }

    public static enum TextureMode {
        Linear,
        Projected,
        Polar;

    }
}

