/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.scenegraph.shape;

import com.ardor3d.math.Vector3;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.renderer.IndexMode;
import com.ardor3d.scenegraph.FloatBufferData;
import com.ardor3d.scenegraph.Mesh;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.export.Savable;
import com.ardor3d.util.geom.BufferUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;

public class StripBox
extends Mesh {
    public double _xExtent;
    public double _yExtent;
    public double _zExtent;
    public final Vector3 _center = new Vector3(0.0, 0.0, 0.0);

    public StripBox() {
        super("temp");
    }

    public StripBox(String name) {
        super(name);
    }

    public StripBox(String name, Vector3 min, Vector3 max) {
        super(name);
        this.setData(min, max);
    }

    public StripBox(String name, Vector3 center, double xExtent, double yExtent, double zExtent) {
        super(name);
        this.setData(center, xExtent, yExtent, zExtent);
    }

    public void setData(Vector3 minPoint, Vector3 maxPoint) {
        this._center.set((ReadOnlyVector3)maxPoint).addLocal((ReadOnlyVector3)minPoint).multiplyLocal(0.5);
        double x = maxPoint.getX() - this._center.getX();
        double y = maxPoint.getY() - this._center.getY();
        double z = maxPoint.getZ() - this._center.getZ();
        this.setData(this._center, x, y, z);
    }

    public void setData(Vector3 center, double xExtent, double yExtent, double zExtent) {
        if (center != null) {
            this._center.set((ReadOnlyVector3)center);
        }
        this._xExtent = xExtent;
        this._yExtent = yExtent;
        this._zExtent = zExtent;
        this.setVertexData();
        this.setNormalData();
        this.setTextureData();
        this.setIndexData();
    }

    private void setVertexData() {
        this._meshData.setVertexBuffer(BufferUtils.createVector3Buffer(this._meshData.getVertexBuffer(), 8));
        Vector3[] vert = this.computeVertices();
        this._meshData.getVertexBuffer().clear();
        this._meshData.getVertexBuffer().put(vert[0].getXf()).put(vert[0].getYf()).put(vert[0].getZf());
        this._meshData.getVertexBuffer().put(vert[1].getXf()).put(vert[1].getYf()).put(vert[1].getZf());
        this._meshData.getVertexBuffer().put(vert[2].getXf()).put(vert[2].getYf()).put(vert[2].getZf());
        this._meshData.getVertexBuffer().put(vert[3].getXf()).put(vert[3].getYf()).put(vert[3].getZf());
        this._meshData.getVertexBuffer().put(vert[4].getXf()).put(vert[4].getYf()).put(vert[4].getZf());
        this._meshData.getVertexBuffer().put(vert[5].getXf()).put(vert[5].getYf()).put(vert[5].getZf());
        this._meshData.getVertexBuffer().put(vert[6].getXf()).put(vert[6].getYf()).put(vert[6].getZf());
        this._meshData.getVertexBuffer().put(vert[7].getXf()).put(vert[7].getYf()).put(vert[7].getZf());
    }

    private void setNormalData() {
        Vector3[] vert = this.computeVertices();
        this._meshData.setNormalBuffer(BufferUtils.createVector3Buffer(this._meshData.getNormalBuffer(), 8));
        Vector3 norm = new Vector3();
        this._meshData.getNormalBuffer().clear();
        for (int i = 0; i < 8; ++i) {
            norm.set((ReadOnlyVector3)vert[i]).normalizeLocal();
            this._meshData.getNormalBuffer().put(norm.getXf()).put(norm.getYf()).put(norm.getZf());
        }
    }

    private void setTextureData() {
        if (this._meshData.getTextureCoords(0) == null) {
            this._meshData.setTextureCoords(new FloatBufferData(BufferUtils.createVector2Buffer(8), 2), 0);
            FloatBuffer tex = (FloatBuffer)this._meshData.getTextureCoords(0).getBuffer();
            tex.put(1.0f).put(0.0f);
            tex.put(0.0f).put(0.0f);
            tex.put(0.0f).put(1.0f);
            tex.put(1.0f).put(1.0f);
            tex.put(1.0f).put(0.0f);
            tex.put(0.0f).put(0.0f);
            tex.put(1.0f).put(1.0f);
            tex.put(0.0f).put(1.0f);
        }
    }

    private void setIndexData() {
        this._meshData.setIndexMode(IndexMode.TriangleStrip);
        if (this._meshData.getIndices() == null) {
            byte[] indices = new byte[]{2, 3, 6, 7, 5, 3, 0, 2, 1, 6, 4, 5, 1, 0};
            ByteBuffer buf = BufferUtils.createByteBuffer(indices.length);
            buf.put(indices);
            buf.rewind();
            this._meshData.setIndexBuffer(buf);
        }
    }

    public StripBox clone() {
        return new StripBox(this.getName() + "_clone", this._center.clone(), this._xExtent, this._yExtent, this._zExtent);
    }

    public Vector3[] computeVertices() {
        Vector3[] akEAxis = new Vector3[]{Vector3.UNIT_X.multiply(this._xExtent, Vector3.fetchTempInstance()), Vector3.UNIT_Y.multiply(this._yExtent, Vector3.fetchTempInstance()), Vector3.UNIT_Z.multiply(this._zExtent, Vector3.fetchTempInstance())};
        Vector3[] rVal = new Vector3[]{this._center.subtract((ReadOnlyVector3)akEAxis[0], new Vector3()).subtractLocal((ReadOnlyVector3)akEAxis[1]).subtractLocal((ReadOnlyVector3)akEAxis[2]), this._center.add((ReadOnlyVector3)akEAxis[0], new Vector3()).subtractLocal((ReadOnlyVector3)akEAxis[1]).subtractLocal((ReadOnlyVector3)akEAxis[2]), this._center.add((ReadOnlyVector3)akEAxis[0], new Vector3()).addLocal((ReadOnlyVector3)akEAxis[1]).subtractLocal((ReadOnlyVector3)akEAxis[2]), this._center.subtract((ReadOnlyVector3)akEAxis[0], new Vector3()).addLocal((ReadOnlyVector3)akEAxis[1]).subtractLocal((ReadOnlyVector3)akEAxis[2]), this._center.add((ReadOnlyVector3)akEAxis[0], new Vector3()).subtractLocal((ReadOnlyVector3)akEAxis[1]).addLocal((ReadOnlyVector3)akEAxis[2]), this._center.subtract((ReadOnlyVector3)akEAxis[0], new Vector3()).subtractLocal((ReadOnlyVector3)akEAxis[1]).addLocal((ReadOnlyVector3)akEAxis[2]), this._center.add((ReadOnlyVector3)akEAxis[0], new Vector3()).addLocal((ReadOnlyVector3)akEAxis[1]).addLocal((ReadOnlyVector3)akEAxis[2]), this._center.subtract((ReadOnlyVector3)akEAxis[0], new Vector3()).addLocal((ReadOnlyVector3)akEAxis[1]).addLocal((ReadOnlyVector3)akEAxis[2])};
        for (Vector3 axis : akEAxis) {
            Vector3.releaseTempInstance((Vector3)axis);
        }
        return rVal;
    }

    public Vector3 getCenter() {
        return this._center;
    }

    @Override
    public void write(OutputCapsule capsule) throws IOException {
        super.write(capsule);
        capsule.write(this._xExtent, "xExtent", 0.0);
        capsule.write(this._yExtent, "yExtent", 0.0);
        capsule.write(this._zExtent, "zExtent", 0.0);
        capsule.write((Savable)this._center, "center", (Savable)new Vector3(Vector3.ZERO));
    }

    @Override
    public void read(InputCapsule capsule) throws IOException {
        super.read(capsule);
        this._xExtent = capsule.readDouble("xExtent", 0.0);
        this._yExtent = capsule.readDouble("yExtent", 0.0);
        this._zExtent = capsule.readDouble("zExtent", 0.0);
        this._center.set((ReadOnlyVector3)((Vector3)capsule.readSavable("center", (Savable)new Vector3(Vector3.ZERO))));
    }
}

