/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.scenegraph.shape;

import com.ardor3d.math.MathUtils;
import com.ardor3d.math.Vector3;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.scenegraph.Mesh;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.geom.BufferUtils;
import java.io.IOException;
import java.nio.FloatBuffer;

public class Torus
extends Mesh {
    protected int _circleSamples;
    protected int _radialSamples;
    protected double _tubeRadius;
    protected double _centerRadius;
    protected boolean _viewInside;

    public Torus() {
    }

    public Torus(String name, int circleSamples, int radialSamples, double tubeRadius, double centerRadius) {
        super(name);
        this._circleSamples = circleSamples;
        this._radialSamples = radialSamples;
        this._tubeRadius = tubeRadius;
        this._centerRadius = centerRadius;
        this.setGeometryData();
        this.setIndexData();
    }

    private void setGeometryData() {
        int verts = (this._circleSamples + 1) * (this._radialSamples + 1);
        this._meshData.setVertexBuffer(BufferUtils.createVector3Buffer(verts));
        this._meshData.setNormalBuffer(BufferUtils.createVector3Buffer(verts));
        this._meshData.setTextureBuffer(BufferUtils.createVector2Buffer(verts), 0);
        double inverseCircleSamples = 1.0 / (double)this._circleSamples;
        double inverseRadialSamples = 1.0 / (double)this._radialSamples;
        int i = 0;
        Vector3 radialAxis = new Vector3();
        Vector3 torusMiddle = new Vector3();
        Vector3 tempNormal = new Vector3();
        for (int circleCount = 0; circleCount < this._circleSamples; ++circleCount) {
            double circleFraction = (double)circleCount * inverseCircleSamples;
            double theta = Math.PI * 2 * circleFraction;
            double cosTheta = MathUtils.cos((double)theta);
            double sinTheta = MathUtils.sin((double)theta);
            radialAxis.set(cosTheta, sinTheta, 0.0);
            radialAxis.multiply(this._centerRadius, torusMiddle);
            int iSave = i;
            for (int radialCount = 0; radialCount < this._radialSamples; ++radialCount) {
                double radialFraction = (double)radialCount * inverseRadialSamples;
                double phi = Math.PI * 2 * radialFraction;
                double cosPhi = MathUtils.cos((double)phi);
                double sinPhi = MathUtils.sin((double)phi);
                tempNormal.set((ReadOnlyVector3)radialAxis).multiplyLocal(cosPhi);
                tempNormal.setZ(tempNormal.getZ() + sinPhi);
                tempNormal.normalizeLocal();
                if (!this._viewInside) {
                    this._meshData.getNormalBuffer().put((float)tempNormal.getX()).put((float)tempNormal.getY()).put((float)tempNormal.getZ());
                } else {
                    this._meshData.getNormalBuffer().put((float)(-tempNormal.getX())).put((float)(-tempNormal.getY())).put((float)(-tempNormal.getZ()));
                }
                tempNormal.multiplyLocal(this._tubeRadius).addLocal((ReadOnlyVector3)torusMiddle);
                this._meshData.getVertexBuffer().put((float)tempNormal.getX()).put((float)tempNormal.getY()).put((float)tempNormal.getZ());
                ((FloatBuffer)this._meshData.getTextureCoords(0).getBuffer()).put((float)radialFraction).put((float)circleFraction);
                ++i;
            }
            BufferUtils.copyInternalVector3(this._meshData.getVertexBuffer(), iSave, i);
            BufferUtils.copyInternalVector3(this._meshData.getNormalBuffer(), iSave, i);
            ((FloatBuffer)this._meshData.getTextureCoords(0).getBuffer()).put(1.0f).put((float)circleFraction);
            ++i;
        }
        int iR = 0;
        while (iR <= this._radialSamples) {
            BufferUtils.copyInternalVector3(this._meshData.getVertexBuffer(), iR, i);
            BufferUtils.copyInternalVector3(this._meshData.getNormalBuffer(), iR, i);
            BufferUtils.copyInternalVector2((FloatBuffer)this._meshData.getTextureCoords(0).getBuffer(), iR, i);
            ((FloatBuffer)this._meshData.getTextureCoords(0).getBuffer()).put(i * 2 + 1, 1.0f);
            ++iR;
            ++i;
        }
    }

    private void setIndexData() {
        int verts = (this._circleSamples + 1) * (this._radialSamples + 1);
        int tris = 2 * this._circleSamples * this._radialSamples;
        this._meshData.setIndices(BufferUtils.createIndexBufferData(3 * tris, verts - 1));
        int connectionStart = 0;
        for (int circleCount = 0; circleCount < this._circleSamples; ++circleCount) {
            int i0 = connectionStart;
            int i1 = i0 + 1;
            int i2 = connectionStart += this._radialSamples + 1;
            int i3 = i2 + 1;
            for (int i = 0; i < this._radialSamples; ++i) {
                if (!this._viewInside) {
                    this._meshData.getIndices().put(i0++);
                    this._meshData.getIndices().put(i2);
                    this._meshData.getIndices().put(i1);
                    this._meshData.getIndices().put(i1++);
                    this._meshData.getIndices().put(i2++);
                    this._meshData.getIndices().put(i3++);
                    continue;
                }
                this._meshData.getIndices().put(i0++);
                this._meshData.getIndices().put(i1);
                this._meshData.getIndices().put(i2);
                this._meshData.getIndices().put(i1++);
                this._meshData.getIndices().put(i3++);
                this._meshData.getIndices().put(i2++);
            }
        }
    }

    public boolean isViewFromInside() {
        return this._viewInside;
    }

    public void setViewFromInside(boolean viewInside) {
        if (viewInside != this._viewInside) {
            this._viewInside = viewInside;
            this.setGeometryData();
            this.setIndexData();
        }
    }

    @Override
    public void write(OutputCapsule capsule) throws IOException {
        super.write(capsule);
        capsule.write(this._circleSamples, "circleSamples", 0);
        capsule.write(this._radialSamples, "radialSamples", 0);
        capsule.write(this._tubeRadius, "tubeRadius", 0.0);
        capsule.write(this._centerRadius, "centerRadius", 0.0);
        capsule.write(this._viewInside, "viewInside", false);
    }

    @Override
    public void read(InputCapsule capsule) throws IOException {
        super.read(capsule);
        this._circleSamples = capsule.readInt("circleSamples", 0);
        this._radialSamples = capsule.readInt("radialSamples", 0);
        this._tubeRadius = capsule.readDouble("tubeRadius", 0.0);
        this._centerRadius = capsule.readDouble("centerRadius", 0.0);
        this._viewInside = capsule.readBoolean("viewInside", false);
    }
}

