/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.scenegraph.shape;

import com.ardor3d.math.MathUtils;
import com.ardor3d.scenegraph.Mesh;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.geom.BufferUtils;
import java.io.IOException;
import java.nio.FloatBuffer;

public class Tube
extends Mesh {
    private int _axisSamples;
    private int _radialSamples;
    private double _outerRadius;
    private double _innerRadius;
    private double _height;
    protected boolean _viewInside;

    public Tube() {
    }

    public Tube(String name, double outerRadius, double innerRadius, double height, int axisSamples, int radialSamples) {
        super(name);
        this._outerRadius = outerRadius;
        this._innerRadius = innerRadius;
        this._height = height;
        this._axisSamples = axisSamples;
        this._radialSamples = radialSamples;
        this.allocateVertices();
    }

    public Tube(String name, double outerRadius, double innerRadius, double height) {
        this(name, outerRadius, innerRadius, height, 2, 20);
    }

    private void allocateVertices() {
        int verts = 2 * (this._axisSamples + 1) * (this._radialSamples + 1) + this._radialSamples * 4;
        this._meshData.setVertexBuffer(BufferUtils.createVector3Buffer(this._meshData.getVertexBuffer(), verts));
        this._meshData.setNormalBuffer(BufferUtils.createVector3Buffer(this._meshData.getNormalBuffer(), verts));
        this._meshData.setTextureBuffer(BufferUtils.createVector2Buffer(this._meshData.getTextureBuffer(0), verts), 0);
        int tris = 4 * this._radialSamples * (1 + this._axisSamples);
        if (this._meshData.getIndices() == null || this._meshData.getIndices().getBufferLimit() != 3 * tris) {
            this._meshData.setIndices(BufferUtils.createIndexBufferData(3 * tris, verts - 1));
        }
        this.setGeometryData();
        this.setIndexData();
    }

    public int getAxisSamples() {
        return this._axisSamples;
    }

    public void setAxisSamples(int axisSamples) {
        this._axisSamples = axisSamples;
        this.allocateVertices();
    }

    public int getRadialSamples() {
        return this._radialSamples;
    }

    public void setRadialSamples(int radialSamples) {
        this._radialSamples = radialSamples;
        this.allocateVertices();
    }

    public double getOuterRadius() {
        return this._outerRadius;
    }

    public void setOuterRadius(double outerRadius) {
        this._outerRadius = outerRadius;
        this.allocateVertices();
    }

    public double getInnerRadius() {
        return this._innerRadius;
    }

    public void setInnerRadius(double innerRadius) {
        this._innerRadius = innerRadius;
        this.allocateVertices();
    }

    public double getHeight() {
        return this._height;
    }

    public void setHeight(double height) {
        this._height = height;
        this.allocateVertices();
    }

    private void setGeometryData() {
        int radialCount;
        this._meshData.getVertexBuffer().rewind();
        this._meshData.getNormalBuffer().rewind();
        ((FloatBuffer)this._meshData.getTextureCoords(0).getBuffer()).rewind();
        double inverseRadial = 1.0 / (double)this._radialSamples;
        double axisStep = this._height / (double)this._axisSamples;
        double axisTextureStep = 1.0 / (double)this._axisSamples;
        double halfHeight = 0.5 * this._height;
        double innerOuterRatio = this._innerRadius / this._outerRadius;
        double[] sin = new double[this._radialSamples];
        double[] cos = new double[this._radialSamples];
        for (radialCount = 0; radialCount < this._radialSamples; ++radialCount) {
            double angle = Math.PI * 2 * inverseRadial * (double)radialCount;
            cos[radialCount] = MathUtils.cos((double)angle);
            sin[radialCount] = MathUtils.sin((double)angle);
        }
        for (radialCount = 0; radialCount < this._radialSamples + 1; ++radialCount) {
            for (int axisCount = 0; axisCount < this._axisSamples + 1; ++axisCount) {
                this._meshData.getVertexBuffer().put((float)(cos[radialCount % this._radialSamples] * this._outerRadius)).put((float)(axisStep * (double)axisCount - halfHeight)).put((float)(sin[radialCount % this._radialSamples] * this._outerRadius));
                if (this._viewInside) {
                    this._meshData.getNormalBuffer().put((float)cos[radialCount % this._radialSamples]).put(0.0f).put((float)sin[radialCount % this._radialSamples]);
                } else {
                    this._meshData.getNormalBuffer().put((float)(-cos[radialCount % this._radialSamples])).put(0.0f).put((float)(-sin[radialCount % this._radialSamples]));
                }
                ((FloatBuffer)this._meshData.getTextureCoords(0).getBuffer()).put((float)((double)radialCount * inverseRadial)).put((float)(axisTextureStep * (double)axisCount));
            }
        }
        for (radialCount = 0; radialCount < this._radialSamples + 1; ++radialCount) {
            for (int axisCount = 0; axisCount < this._axisSamples + 1; ++axisCount) {
                this._meshData.getVertexBuffer().put((float)(cos[radialCount % this._radialSamples] * this._innerRadius)).put((float)(axisStep * (double)axisCount - halfHeight)).put((float)(sin[radialCount % this._radialSamples] * this._innerRadius));
                if (this._viewInside) {
                    this._meshData.getNormalBuffer().put((float)(-cos[radialCount % this._radialSamples])).put(0.0f).put((float)(-sin[radialCount % this._radialSamples]));
                } else {
                    this._meshData.getNormalBuffer().put((float)cos[radialCount % this._radialSamples]).put(0.0f).put((float)sin[radialCount % this._radialSamples]);
                }
                ((FloatBuffer)this._meshData.getTextureCoords(0).getBuffer()).put((float)((double)radialCount * inverseRadial)).put((float)(axisTextureStep * (double)axisCount));
            }
        }
        for (radialCount = 0; radialCount < this._radialSamples; ++radialCount) {
            this._meshData.getVertexBuffer().put((float)(cos[radialCount] * this._outerRadius)).put((float)(-halfHeight)).put((float)(sin[radialCount] * this._outerRadius));
            this._meshData.getVertexBuffer().put((float)(cos[radialCount] * this._innerRadius)).put((float)(-halfHeight)).put((float)(sin[radialCount] * this._innerRadius));
            if (this._viewInside) {
                this._meshData.getNormalBuffer().put(0.0f).put(1.0f).put(0.0f);
                this._meshData.getNormalBuffer().put(0.0f).put(1.0f).put(0.0f);
            } else {
                this._meshData.getNormalBuffer().put(0.0f).put(-1.0f).put(0.0f);
                this._meshData.getNormalBuffer().put(0.0f).put(-1.0f).put(0.0f);
            }
            ((FloatBuffer)this._meshData.getTextureCoords(0).getBuffer()).put((float)(0.5 + 0.5 * cos[radialCount])).put((float)(0.5 + 0.5 * sin[radialCount]));
            ((FloatBuffer)this._meshData.getTextureCoords(0).getBuffer()).put((float)(0.5 + innerOuterRatio * 0.5 * cos[radialCount])).put((float)(0.5 + innerOuterRatio * 0.5 * sin[radialCount]));
        }
        for (radialCount = 0; radialCount < this._radialSamples; ++radialCount) {
            this._meshData.getVertexBuffer().put((float)(cos[radialCount] * this._outerRadius)).put((float)halfHeight).put((float)(sin[radialCount] * this._outerRadius));
            this._meshData.getVertexBuffer().put((float)(cos[radialCount] * this._innerRadius)).put((float)halfHeight).put((float)(sin[radialCount] * this._innerRadius));
            if (this._viewInside) {
                this._meshData.getNormalBuffer().put(0.0f).put(-1.0f).put(0.0f);
                this._meshData.getNormalBuffer().put(0.0f).put(-1.0f).put(0.0f);
            } else {
                this._meshData.getNormalBuffer().put(0.0f).put(1.0f).put(0.0f);
                this._meshData.getNormalBuffer().put(0.0f).put(1.0f).put(0.0f);
            }
            ((FloatBuffer)this._meshData.getTextureCoords(0).getBuffer()).put((float)(0.5 + 0.5 * cos[radialCount])).put((float)(0.5 + 0.5 * sin[radialCount]));
            ((FloatBuffer)this._meshData.getTextureCoords(0).getBuffer()).put((float)(0.5 + innerOuterRatio * 0.5 * cos[radialCount])).put((float)(0.5 + innerOuterRatio * 0.5 * sin[radialCount]));
        }
    }

    private void setIndexData() {
        int index3;
        int index2;
        int index1;
        int index0;
        int index32;
        int index22;
        int index12;
        int index02;
        int axisCount;
        int radialCount;
        this._meshData.getIndices().rewind();
        int outerCylinder = (this._axisSamples + 1) * (this._radialSamples + 1);
        int bottomEdge = 2 * outerCylinder;
        int topEdge = bottomEdge + 2 * this._radialSamples;
        for (radialCount = 0; radialCount < this._radialSamples; ++radialCount) {
            for (axisCount = 0; axisCount < this._axisSamples; ++axisCount) {
                index02 = axisCount + (this._axisSamples + 1) * radialCount;
                index12 = index02 + 1;
                index22 = index02 + (this._axisSamples + 1);
                index32 = index22 + 1;
                if (this._viewInside) {
                    this._meshData.getIndices().put(index02).put(index12).put(index22);
                    this._meshData.getIndices().put(index12).put(index32).put(index22);
                    continue;
                }
                this._meshData.getIndices().put(index02).put(index22).put(index12);
                this._meshData.getIndices().put(index12).put(index22).put(index32);
            }
        }
        for (radialCount = 0; radialCount < this._radialSamples; ++radialCount) {
            for (axisCount = 0; axisCount < this._axisSamples; ++axisCount) {
                index02 = outerCylinder + axisCount + (this._axisSamples + 1) * radialCount;
                index12 = index02 + 1;
                index22 = index02 + (this._axisSamples + 1);
                index32 = index22 + 1;
                if (this._viewInside) {
                    this._meshData.getIndices().put(index02).put(index22).put(index12);
                    this._meshData.getIndices().put(index12).put(index22).put(index32);
                    continue;
                }
                this._meshData.getIndices().put(index02).put(index12).put(index22);
                this._meshData.getIndices().put(index12).put(index32).put(index22);
            }
        }
        for (radialCount = 0; radialCount < this._radialSamples; ++radialCount) {
            index0 = bottomEdge + 2 * radialCount;
            index1 = index0 + 1;
            index2 = bottomEdge + 2 * ((radialCount + 1) % this._radialSamples);
            index3 = index2 + 1;
            if (this._viewInside) {
                this._meshData.getIndices().put(index0).put(index2).put(index1);
                this._meshData.getIndices().put(index1).put(index2).put(index3);
                continue;
            }
            this._meshData.getIndices().put(index0).put(index1).put(index2);
            this._meshData.getIndices().put(index1).put(index3).put(index2);
        }
        for (radialCount = 0; radialCount < this._radialSamples; ++radialCount) {
            index0 = topEdge + 2 * radialCount;
            index1 = index0 + 1;
            index2 = topEdge + 2 * ((radialCount + 1) % this._radialSamples);
            index3 = index2 + 1;
            if (this._viewInside) {
                this._meshData.getIndices().put(index0).put(index1).put(index2);
                this._meshData.getIndices().put(index1).put(index3).put(index2);
                continue;
            }
            this._meshData.getIndices().put(index0).put(index2).put(index1);
            this._meshData.getIndices().put(index1).put(index2).put(index3);
        }
    }

    public boolean isViewFromInside() {
        return this._viewInside;
    }

    public void setViewFromInside(boolean viewInside) {
        if (viewInside != this._viewInside) {
            this._viewInside = viewInside;
            this.setGeometryData();
            this.setIndexData();
        }
    }

    @Override
    public void write(OutputCapsule capsule) throws IOException {
        super.write(capsule);
        capsule.write(this.getAxisSamples(), "axisSamples", 0);
        capsule.write(this.getRadialSamples(), "radialSamples", 0);
        capsule.write(this.getOuterRadius(), "outerRadius", 0.0);
        capsule.write(this.getInnerRadius(), "innerRadius", 0.0);
        capsule.write(this.getHeight(), "height", 0.0);
        capsule.write(this._viewInside, "viewInside", false);
    }

    @Override
    public void read(InputCapsule capsule) throws IOException {
        super.read(capsule);
        this.setAxisSamples(capsule.readInt("axisSamples", 0));
        this.setRadialSamples(capsule.readInt("radialSamples", 0));
        this.setOuterRadius(capsule.readDouble("outerRadius", 0.0));
        this.setInnerRadius(capsule.readDouble("innerRadius", 0.0));
        this.setHeight(capsule.readDouble("height", 0.0));
        this._viewInside = capsule.readBoolean("viewInside", false);
    }
}

