/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.spline;

import com.ardor3d.math.Vector3;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.spline.Curve;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ArcLengthTable {
    private static final Logger LOGGER = Logger.getLogger(ArcLengthTable.class.getName());
    private Map<Integer, List<ArcLengthEntry>> _lookupTable;
    private final Curve _curve;

    public ArcLengthTable(Curve curve) {
        if (null == curve) {
            throw new IllegalArgumentException("curve was null!");
        }
        this._curve = curve;
    }

    public double getLength(int index) {
        if (null == this._lookupTable) {
            throw new IllegalStateException("You must generate the look up table before calling this method! see generate()");
        }
        List<ArcLengthEntry> entries = this._lookupTable.get(index);
        if (null == entries) {
            throw new IllegalArgumentException("entries was null, the index parameter was invalid. index=" + index);
        }
        ArcLengthEntry arcLength = entries.get(entries.size() - 1);
        return arcLength.getLength();
    }

    public double getDelta(int index, double distance) {
        double delta;
        if (null == this._lookupTable) {
            throw new IllegalStateException("You must generate the look up table before calling this method! see generate()");
        }
        Object previous = null;
        ArcLengthEntry next = null;
        List<ArcLengthEntry> entries = this._lookupTable.get(index);
        if (null == entries) {
            throw new IllegalArgumentException("entries was null, the index parameter was invalid. index=" + index);
        }
        for (ArcLengthEntry entry : entries) {
            if (entry.getLength() <= distance) {
                previous = entry;
            }
            if (!(entry.getLength() >= distance)) continue;
            next = entry;
            break;
        }
        if (null == previous) {
            throw new IllegalArgumentException("previous was null, either the index or distance parameters were invalid. index=" + index + ", distance=" + distance);
        }
        if (null == next) {
            int newIndex = index + 1 >= this._lookupTable.size() ? 1 : index + 1;
            delta = this.getDelta(newIndex, distance - ((ArcLengthEntry)previous).getLength()) + ((ArcLengthEntry)previous).getDelta();
        } else if (previous.equals(next)) {
            delta = ((ArcLengthEntry)previous).getDelta();
        } else {
            double d0 = ((ArcLengthEntry)previous).getDelta();
            double d1 = next.getDelta();
            double l0 = ((ArcLengthEntry)previous).getLength();
            double l1 = next.getLength();
            delta = d0 + (distance - l0) / (l1 - l0) * (d1 - d0);
        }
        return delta;
    }

    public void generate(int step, boolean reverse) {
        if (step <= 0) {
            throw new IllegalArgumentException("step must be > 0! step=" + step);
        }
        this._lookupTable = new HashMap<Integer, List<ArcLengthEntry>>();
        Vector3 target = Vector3.fetchTempInstance();
        Vector3 previous = Vector3.fetchTempInstance();
        int loopStart = reverse ? this._curve.getControlPointCount() - 2 : 1;
        double tStep = 1.0 / (double)step;
        int i = loopStart;
        while (this.continueLoop(i, reverse)) {
            int endIndex;
            int startIndex = i;
            double t = 0.0;
            double length = 0.0;
            previous.set(this._curve.getControlPoints().get(i));
            ArrayList<ArcLengthEntry> entries = new ArrayList<ArcLengthEntry>();
            entries.add(new ArcLengthEntry(0.0, 0.0));
            int n = endIndex = reverse ? startIndex - 1 : startIndex + 1;
            do {
                if ((t += tStep) > 1.0) {
                    t = 1.0;
                }
                this._curve.interpolate(startIndex, endIndex, t, target);
                previous.set((ReadOnlyVector3)target);
                entries.add(new ArcLengthEntry(t, length += previous.distance((ReadOnlyVector3)target)));
            } while (t != 1.0);
            this._lookupTable.put(i, entries);
            i = this.updateCounter(i, reverse);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("look up table = " + this._lookupTable);
        }
        Vector3.releaseTempInstance((Vector3)target);
        Vector3.releaseTempInstance((Vector3)previous);
    }

    private boolean continueLoop(int i, boolean reverse) {
        return reverse ? i > 0 : i < this._curve.getControlPointCount() - 2;
    }

    private int updateCounter(int i, boolean reverse) {
        return reverse ? i - 1 : i + 1;
    }

    private static class ArcLengthEntry
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final double _delta;
        private final double _length;

        public ArcLengthEntry(double delta, double length) {
            this._delta = delta;
            this._length = length;
        }

        public double getDelta() {
            return this._delta;
        }

        public double getLength() {
            return this._length;
        }

        public String toString() {
            return "ArcLengthEntry[length=" + this._length + ", delta=" + this._delta + ']';
        }
    }
}

