/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.spline;

import com.ardor3d.math.Vector3;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.spline.Spline;

public class CatmullRomSpline
implements Spline {
    @Override
    public Vector3 interpolate(ReadOnlyVector3 p0, ReadOnlyVector3 p1, ReadOnlyVector3 p2, ReadOnlyVector3 p3, double t) {
        return this.interpolate(p0, p1, p2, p3, t, new Vector3());
    }

    @Override
    public Vector3 interpolate(ReadOnlyVector3 p0, ReadOnlyVector3 p1, ReadOnlyVector3 p2, ReadOnlyVector3 p3, double t, Vector3 result) {
        if (null != result && null != p0 && null != p1 && null != p2 && null != p3) {
            if (t <= 0.0) {
                result.set(p1);
            } else if (t >= 1.0) {
                result.set(p2);
            } else {
                double t2 = t * t;
                double t3 = t2 * t;
                result.setX(0.5 * (2.0 * p1.getX() + (-p0.getX() + p2.getX()) * t + (2.0 * p0.getX() - 5.0 * p1.getX() + 4.0 * p2.getX() - p3.getX()) * t2 + (-p0.getX() + 3.0 * p1.getX() - 3.0 * p2.getX() + p3.getX()) * t3));
                result.setY(0.5 * (2.0 * p1.getY() + (-p0.getY() + p2.getY()) * t + (2.0 * p0.getY() - 5.0 * p1.getY() + 4.0 * p2.getY() - p3.getY()) * t2 + (-p0.getY() + 3.0 * p1.getY() - 3.0 * p2.getY() + p3.getY()) * t3));
                result.setZ(0.5 * (2.0 * p1.getZ() + (-p0.getZ() + p2.getZ()) * t + (2.0 * p0.getZ() - 5.0 * p1.getZ() + 4.0 * p2.getZ() - p3.getZ()) * t2 + (-p0.getZ() + 3.0 * p1.getZ() - 3.0 * p2.getZ() + p3.getZ()) * t3));
            }
        }
        return result;
    }
}

