/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.spline;

import com.ardor3d.math.Vector3;
import com.ardor3d.math.type.ReadOnlyColorRGBA;
import com.ardor3d.math.type.ReadOnlyVector2;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.renderer.IndexMode;
import com.ardor3d.scenegraph.Line;
import com.ardor3d.scenegraph.Point;
import com.ardor3d.spline.Spline;
import java.util.List;

public class Curve {
    private List<ReadOnlyVector3> _controlPoints;
    private Spline _spline;

    public Curve(List<ReadOnlyVector3> controlPoints, Spline spline) {
        this.setControlPoints(controlPoints);
        this.setSpline(spline);
    }

    public Point toRenderablePoint(int steps) {
        return this.toRenderablePoint(1, this.getControlPointCount() - 2, steps);
    }

    public Point toRenderablePoint(int start, int end, int steps) {
        Vector3[] points = this.toVector3(start, end, steps);
        return new Point("point", (ReadOnlyVector3[])points, null, null, null);
    }

    public Line toRenderableLine(int steps) {
        return this.toRenderableLine(1, this.getControlPointCount() - 2, steps);
    }

    public Line toRenderableLine(int start, int end, int steps) {
        Vector3[] vertex = this.toVector3(start, end, steps);
        ReadOnlyVector3[] normal = null;
        ReadOnlyColorRGBA[] color = null;
        ReadOnlyVector2[] texture = null;
        Line line = new Line("curve", (ReadOnlyVector3[])vertex, normal, color, texture);
        line.getMeshData().setIndexMode(IndexMode.LineStrip);
        return line;
    }

    public double getApproximateLength(int steps) {
        return this.getApproximateLength(1, this.getControlPointCount() - 2, steps);
    }

    public double getApproximateLength(int start, int end, int steps) {
        double length = 0.0;
        Vector3[] vectors = this.toVector3(start, end, steps);
        for (int i = 0; i < vectors.length - 1; ++i) {
            length += vectors[i].distance((ReadOnlyVector3)vectors[i + 1]);
        }
        return length;
    }

    public ReadOnlyVector3 interpolate(int start, int end, double t) {
        return this.interpolate(start, end, t, new Vector3());
    }

    public ReadOnlyVector3 interpolate(int start, int end, double t, Vector3 result) {
        if (start <= 0) {
            throw new IllegalArgumentException("start must be > 0! start=" + start);
        }
        if (end >= this.getControlPointCount() - 1) {
            throw new IllegalArgumentException("end must be < " + (this.getControlPointCount() - 1) + "! end=" + end);
        }
        List<ReadOnlyVector3> points = this.getControlPoints();
        return this.getSpline().interpolate(points.get(start - 1), points.get(start), points.get(end), points.get(end + 1), t, result);
    }

    public int getControlPointCount() {
        return this.getControlPoints().size();
    }

    public void setControlPoints(List<ReadOnlyVector3> controlPoints) {
        if (null == controlPoints) {
            throw new IllegalArgumentException("controlPoints can not be null!");
        }
        if (controlPoints.size() < 4) {
            throw new IllegalArgumentException("controlPoints must contain at least 4 elements for this class to work!");
        }
        this._controlPoints = controlPoints;
    }

    public List<ReadOnlyVector3> getControlPoints() {
        assert (null != this._controlPoints) : "_controlPoints was null, it must be set before use!";
        assert (this._controlPoints.size() >= 4) : "_controlPoints contained less than 4 elements, it must be contain at least 4 for this class to work!";
        return this._controlPoints;
    }

    public void setSpline(Spline spline) {
        if (null == spline) {
            throw new IllegalArgumentException("spline can not be null!");
        }
        this._spline = spline;
    }

    public Spline getSpline() {
        assert (null != this._spline) : "_spline was null, it must be set before use!";
        return this._spline;
    }

    private Vector3[] toVector3(int start, int end, int steps) {
        if (start <= 0) {
            throw new IllegalArgumentException("start must be > 0! start=" + start);
        }
        if (end >= this.getControlPointCount() - 1) {
            throw new IllegalArgumentException("end must be < " + (this.getControlPointCount() - 1) + "! end=" + end);
        }
        if (start >= end) {
            throw new IllegalArgumentException("start must be < end! start=" + start + ", end=" + end);
        }
        if (steps <= 1) {
            throw new IllegalArgumentException("steps must be >= 1! steps=" + steps);
        }
        List<ReadOnlyVector3> controlPoints = this.getControlPoints();
        int count = (end - start) * steps;
        Vector3[] vectors = new Vector3[count];
        int index = start;
        for (int i = 0; i < count; ++i) {
            int is = i % steps;
            if (0 == is && i >= steps) {
                ++index;
            }
            double t = (double)is / ((double)steps - 1.0);
            int p0 = index - 1;
            int p1 = index;
            int p2 = index + 1;
            int p3 = index + 2;
            vectors[i] = this.getSpline().interpolate(controlPoints.get(p0), controlPoints.get(p1), controlPoints.get(p2), controlPoints.get(p3), t);
        }
        return vectors;
    }
}

