/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.ui.text;

import com.ardor3d.annotation.SavableFactory;
import com.ardor3d.image.Texture;
import com.ardor3d.image.TextureStoreFormat;
import com.ardor3d.renderer.queue.RenderBucketType;
import com.ardor3d.renderer.state.BlendState;
import com.ardor3d.renderer.state.TextureState;
import com.ardor3d.renderer.state.ZBufferState;
import com.ardor3d.scenegraph.Spatial;
import com.ardor3d.util.TextureKey;
import com.ardor3d.util.TextureManager;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.export.Savable;
import com.ardor3d.util.resource.ResourceSource;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BMFont
implements Savable {
    private static Logger logger = Logger.getLogger(BMFont.class.getName());
    private final Map<Integer, Char> _charMap = new HashMap<Integer, Char>();
    private final Map<Integer, Map<Integer, Integer>> _kernMap = new HashMap<Integer, Map<Integer, Integer>>();
    private String _styleName;
    private final ArrayList<Page> _pages = new ArrayList();
    private Texture _pageTexture;
    private RenderStateSetter _blendStateSetter = null;
    private RenderStateSetter _alphaStateSetter = null;
    private boolean _useMipMaps;
    private int _maxCharAdv;
    private Common _common = null;
    private Info _info = null;

    public BMFont() {
    }

    public BMFont(ResourceSource source, boolean useMipMaps) throws IOException {
        this._useMipMaps = useMipMaps;
        this.parseFontFile(source);
        this.initialize(source);
    }

    public void applyRenderStatesTo(Spatial spatial, boolean useBlend) {
        if (useBlend) {
            if (this._blendStateSetter == null) {
                this._blendStateSetter = new RenderStateSetter(this._pageTexture, true);
            }
            this._blendStateSetter.applyTo(spatial);
        } else {
            if (this._alphaStateSetter == null) {
                this._alphaStateSetter = new RenderStateSetter(this._pageTexture, false);
            }
            this._alphaStateSetter.applyTo(spatial);
        }
    }

    public String getStyleName() {
        return this._styleName;
    }

    public int getSize() {
        return Math.abs(this._info.size);
    }

    public int getLineHeight() {
        return this._common.lineHeight;
    }

    public int getBaseHeight() {
        return this._common.base;
    }

    public int getTextureWidth() {
        return this._common.scaleW;
    }

    public int getTextureHeight() {
        return this._common.scaleH;
    }

    public Char getChar(int chr) {
        Char retVal = this._charMap.get(chr);
        if (retVal == null && (retVal = this._charMap.get(chr = 63)) == null) {
            Iterator<Char> it = this._charMap.values().iterator();
            retVal = it.next();
        }
        return retVal;
    }

    public int getKerning(int chr, int nextChr) {
        Integer amt;
        Map<Integer, Integer> map = this._kernMap.get(chr);
        if (map != null && (amt = map.get(nextChr)) != null) {
            return amt;
        }
        return 0;
    }

    public int getMaxCharAdvance() {
        return this._maxCharAdv;
    }

    public int getOutlineWidth() {
        return this._info.outline;
    }

    public Info getInfo() {
        return this._info;
    }

    public void writeXML(OutputStream outputStream) throws IOException {
        StringBuilder xml = new StringBuilder();
        xml.append("<?xml version=\"1.0\"?>\n");
        xml.append("<font>\n");
        xml.append(this.generateInfoXML());
        xml.append(this.generateCommonXML());
        xml.append(this.generatePagesXML());
        xml.append(this.generateCharsXML());
        xml.append(this.generateKerningsXML());
        xml.append("</font>");
        outputStream.write(xml.toString().getBytes());
        outputStream.flush();
    }

    private String generateInfoXML() {
        int i;
        StringBuilder xml = new StringBuilder();
        xml.append("  <info face=\"");
        xml.append(this._info.face);
        xml.append("\" size=\"");
        xml.append(this._info.size);
        xml.append("\" bold=\"");
        xml.append(this._info.bold ? "1" : "0");
        xml.append("\" italic=\"");
        xml.append(this._info.italic ? "1" : "0");
        xml.append("\" charset=\"");
        xml.append(this._info.charset);
        xml.append("\" unicode=\"");
        xml.append(this._info.unicode ? "1" : "0");
        xml.append("\" stretchH=\"");
        xml.append(this._info.stretchH);
        xml.append("\" smooth=\"");
        xml.append(this._info.smooth ? "1" : "0");
        xml.append("\" aa=\"");
        xml.append(this._info.aa ? "1" : "0");
        xml.append("\" padding=\"");
        for (i = 0; i < this._info.padding.length; ++i) {
            xml.append(this._info.padding[i]);
            if (i >= this._info.padding.length - 1) continue;
            xml.append(',');
        }
        xml.append("\" spacing=\"");
        for (i = 0; i < this._info.spacing.length; ++i) {
            xml.append(this._info.spacing[i]);
            if (i >= this._info.spacing.length - 1) continue;
            xml.append(',');
        }
        xml.append("\" outline=\"");
        xml.append(this._info.outline);
        xml.append("\"/>\n");
        return xml.toString();
    }

    private String generateCommonXML() {
        StringBuilder xml = new StringBuilder();
        xml.append("  <common lineHeight=\"");
        xml.append(this._common.lineHeight);
        xml.append("\" base=\"");
        xml.append(this._common.base);
        xml.append("\" scaleW=\"");
        xml.append(this._common.scaleW);
        xml.append("\" scaleH=\"");
        xml.append(this._common.scaleH);
        xml.append("\" pages=\"");
        xml.append(this._common.pages);
        xml.append("\" packed=\"");
        xml.append(this._common.packed ? "1" : "0");
        xml.append("\" alphaChnl=\"");
        xml.append(this._common.alphaChnl);
        xml.append("\" redChnl=\"");
        xml.append(this._common.redChnl);
        xml.append("\" greenChnl=\"");
        xml.append(this._common.greenChnl);
        xml.append("\" blueChnl=\"");
        xml.append(this._common.blueChnl);
        xml.append("\"/>\n");
        return xml.toString();
    }

    private String generatePagesXML() {
        StringBuilder xml = new StringBuilder();
        xml.append("  <pages>\n");
        for (Page page : this._pages) {
            xml.append("    <page id=\"");
            xml.append(page.id);
            xml.append("\" file=\"");
            xml.append(page.file);
            xml.append("\" />\n");
        }
        xml.append("  </pages>\n");
        return xml.toString();
    }

    private String generateCharsXML() {
        StringBuilder xml = new StringBuilder();
        xml.append("  <chars count=\"");
        xml.append(this._charMap.size());
        xml.append("\">\n");
        for (Integer key : this._charMap.keySet()) {
            Char character = this._charMap.get(key);
            xml.append("    <char id=\"");
            xml.append(character.id);
            xml.append("\" x=\"");
            xml.append(character.x);
            xml.append("\" y=\"");
            xml.append(character.y);
            xml.append("\" width=\"");
            xml.append(character.width);
            xml.append("\" height=\"");
            xml.append(character.height);
            xml.append("\" xoffset=\"");
            xml.append(character.xoffset);
            xml.append("\" yoffset=\"");
            xml.append(character.yoffset);
            xml.append("\" xadvance=\"");
            xml.append(character.xadvance);
            xml.append("\" page=\"");
            xml.append(character.page);
            xml.append("\" chnl=\"");
            xml.append(character.chnl);
            xml.append("\" />\n");
        }
        xml.append("  </chars>\n");
        return xml.toString();
    }

    private String generateKerningsXML() {
        StringBuilder xml = new StringBuilder();
        int count = 0;
        for (Integer first : this._kernMap.keySet()) {
            Map<Integer, Integer> amtHash = this._kernMap.get(first);
            for (Integer second : amtHash.keySet()) {
                Integer amount = amtHash.get(second);
                xml.append("    <kerning first=\"");
                xml.append(first);
                xml.append("\" second=\"");
                xml.append(second);
                xml.append("\" amount=\"");
                xml.append(amount);
                xml.append("\" />\n");
                ++count;
            }
        }
        String xmlString = "  <kernings count=\"" + count + "\">\n" + xml.toString() + "  </kernings>\n";
        return xmlString;
    }

    protected void initialize(ResourceSource source) throws MalformedURLException {
        this._styleName = this._info.face + "-" + this._info.size;
        this._styleName = this._info.bold ? this._styleName + "-bold" : this._styleName + "-medium";
        this._styleName = this._info.italic ? this._styleName + "-italic" : this._styleName + "-regular";
        if (this._pages.size() > 0) {
            Page page = this._pages.get(0);
            ResourceSource texSrc = source.getRelativeSource("./" + page.file);
            Texture.MagnificationFilter magFilter = Texture.MagnificationFilter.Bilinear;
            Texture.MinificationFilter minFilter = Texture.MinificationFilter.BilinearNoMipMaps;
            if (this._useMipMaps) {
                minFilter = Texture.MinificationFilter.Trilinear;
            }
            TextureKey tkey = TextureKey.getKey(texSrc, false, TextureStoreFormat.GuessNoCompressedFormat, minFilter);
            this._pageTexture = TextureManager.loadFromKey(tkey, null, null);
            this._pageTexture.setMagnificationFilter(magFilter);
            this._pageTexture.setLodBias(-1.0f);
            if (this._useMipMaps) {
                this._pageTexture.setAnisotropicFilterPercent(1.0f);
            }
        }
    }

    public Texture getPageTexture() {
        return this._pageTexture;
    }

    public List<Integer> getMappedChars() {
        return new ArrayList<Integer>(this._charMap.keySet());
    }

    public Map<Integer, Integer> getKerningsForCharacter(int val) {
        return this._kernMap.get(val);
    }

    public Map<Integer, Map<Integer, Integer>> getKerningMap() {
        return this._kernMap;
    }

    protected void parseFontFile(ResourceSource source) throws IOException {
        this._maxCharAdv = 0;
        this._charMap.clear();
        this._pages.clear();
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(source.openStream());
            doc.getDocumentElement().normalize();
            this.recurse(doc.getElementsByTagName("font").item(0));
        }
        catch (Throwable t) {
            IOException ex = new IOException("Error loading font file " + source.toString());
            ex.initCause(t);
            throw ex;
        }
    }

    private void recurse(Node node) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            this.processNode(child);
            this.recurse(child);
        }
    }

    private void processNode(Node node) {
        String tagName = node.getNodeName();
        if (tagName != null) {
            if (tagName.equals("info")) {
                this.processInfoNode(node);
            } else if (tagName.equals("common")) {
                this.processCommonNode(node);
            } else if (tagName.equals("page")) {
                this.processPageNode(node);
            } else if (tagName.equals("char")) {
                this.processCharNode(node);
            } else if (tagName.equals("kerning")) {
                this.procesKerningNode(node);
            }
        }
    }

    private void processInfoNode(Node node) {
        NamedNodeMap attribs = node.getAttributes();
        this._info = new Info();
        this._info.face = this.getStringAttrib("face", attribs);
        this._info.size = this.getIntAttrib("size", attribs);
        this._info.bold = this.getBoolAttrib("bold", attribs);
        this._info.italic = this.getBoolAttrib("italic", attribs);
        this._info.charset = this.getStringAttrib("charset", attribs);
        this._info.unicode = this.getBoolAttrib("unicode", attribs);
        this._info.stretchH = this.getIntAttrib("stretchH", attribs);
        this._info.smooth = this.getBoolAttrib("smooth", attribs);
        this._info.aa = this.getBoolAttrib("aa", attribs);
        this._info.padding = this.getIntArrayAttrib("padding", attribs);
        this._info.spacing = this.getIntArrayAttrib("spacing", attribs);
        this._info.outline = this.getIntAttrib("outline", attribs);
    }

    private void processCommonNode(Node node) {
        NamedNodeMap attribs = node.getAttributes();
        this._common = new Common();
        this._common.lineHeight = this.getIntAttrib("lineHeight", attribs);
        this._common.base = this.getIntAttrib("base", attribs);
        this._common.scaleW = this.getIntAttrib("scaleW", attribs);
        this._common.scaleH = this.getIntAttrib("scaleH", attribs);
        this._common.pages = this.getIntAttrib("pages", attribs);
        this._common.packed = this.getBoolAttrib("packed", attribs);
        this._common.alphaChnl = this.getIntAttrib("alphaChnl", attribs);
        this._common.redChnl = this.getIntAttrib("redChnl", attribs);
        this._common.greenChnl = this.getIntAttrib("greenChnl", attribs);
        this._common.blueChnl = this.getIntAttrib("blueChnl", attribs);
    }

    private void processCharNode(Node node) {
        NamedNodeMap attribs = node.getAttributes();
        Char c = new Char();
        c.id = this.getIntAttrib("id", attribs);
        c.x = this.getIntAttrib("x", attribs);
        c.y = this.getIntAttrib("y", attribs);
        c.width = this.getIntAttrib("width", attribs);
        c.height = this.getIntAttrib("height", attribs);
        c.xoffset = this.getIntAttrib("xoffset", attribs);
        c.yoffset = this.getIntAttrib("yoffset", attribs);
        c.xadvance = this.getIntAttrib("xadvance", attribs);
        c.page = this.getIntAttrib("page", attribs);
        c.chnl = this.getIntAttrib("chnl", attribs);
        this._charMap.put(c.id, c);
        if (c.xadvance > this._maxCharAdv) {
            this._maxCharAdv = c.xadvance;
        }
    }

    private void processPageNode(Node node) {
        NamedNodeMap attribs = node.getAttributes();
        Page page = new Page();
        page.id = this.getIntAttrib("id", attribs);
        page.file = this.getStringAttrib("file", attribs);
        this._pages.add(page);
        if (this._pages.size() > 1) {
            logger.warning("multiple pages defined in font description file, but only a single page is supported.");
        }
    }

    private void procesKerningNode(Node node) {
        NamedNodeMap attribs = node.getAttributes();
        int first = this.getIntAttrib("first", attribs);
        int second = this.getIntAttrib("second", attribs);
        int amount = this.getIntAttrib("amount", attribs);
        Map<Integer, Integer> amtHash = this._kernMap.get(first);
        if (amtHash == null) {
            amtHash = new HashMap<Integer, Integer>();
            this._kernMap.put(first, amtHash);
        }
        amtHash.put(second, amount);
    }

    int getIntAttrib(String name, NamedNodeMap attribs) {
        Node node = attribs.getNamedItem(name);
        return Integer.parseInt(node.getNodeValue());
    }

    String getStringAttrib(String name, NamedNodeMap attribs) {
        Node node = attribs.getNamedItem(name);
        return node.getNodeValue();
    }

    boolean getBoolAttrib(String name, NamedNodeMap attribs) {
        Node node = attribs.getNamedItem(name);
        return Integer.parseInt(node.getNodeValue()) == 1;
    }

    int[] getIntArrayAttrib(String name, NamedNodeMap attribs) {
        Node node = attribs.getNamedItem(name);
        String str = node.getNodeValue();
        StringTokenizer strtok = new StringTokenizer(str, ",");
        int sz = strtok.countTokens();
        int[] retVal = new int[sz];
        for (int i = 0; i < sz; ++i) {
            retVal[i] = Integer.parseInt(strtok.nextToken());
        }
        return retVal;
    }

    public void write(OutputCapsule capsule) throws IOException {
        this._pageTexture.setStoreImage(true);
        capsule.write(this._useMipMaps, "useMipMaps", false);
        capsule.write(this._styleName, "styleName", null);
        capsule.write((Savable)this._pageTexture, "pageTexture", null);
        capsule.write((Savable)this._info, "info", null);
        capsule.write((Savable)this._common, "common", null);
        capsule.writeSavableList(this._pages, "pages", this._pages);
        capsule.writeSavableList(new ArrayList<Char>(this._charMap.values()), "charMap", null);
        ArrayList<Kerning> kernings = new ArrayList<Kerning>();
        for (Integer first : this._kernMap.keySet()) {
            Map<Integer, Integer> amtHash = this._kernMap.get(first);
            for (Integer second : amtHash.keySet()) {
                Integer amount = amtHash.get(second);
                kernings.add(new Kerning(first, second, amount));
            }
        }
        capsule.writeSavableList(kernings, "kernings", kernings);
    }

    public void read(InputCapsule capsule) throws IOException {
        this._useMipMaps = capsule.readBoolean("useMipMaps", false);
        this._styleName = capsule.readString("styleName", null);
        this._pageTexture = (Texture)capsule.readSavable("pageTexture", null);
        this._pageTexture = TextureManager.loadFromImage(this._pageTexture.getImage(), this._pageTexture.getMinificationFilter());
        this._info = (Info)capsule.readSavable("info", (Savable)this._info);
        this._common = (Common)capsule.readSavable("common", (Savable)this._common);
        this._pages.clear();
        List pages = capsule.readSavableList("pages", new ArrayList());
        for (Object savable : pages) {
            this._pages.add((Page)savable);
            if (this._pages.size() <= 1) continue;
            logger.warning("multiple pages defined in font description file, but only a single page is supported.");
        }
        this._charMap.clear();
        List chars = capsule.readSavableList("charMap", new ArrayList());
        for (Savable savable : chars) {
            Char c = (Char)savable;
            this._charMap.put(c.id, c);
            if (c.xadvance <= this._maxCharAdv) continue;
            this._maxCharAdv = c.xadvance;
        }
        this._kernMap.clear();
        List kernings = capsule.readSavableList("kernings", new ArrayList());
        for (Savable savable : kernings) {
            Kerning k = (Kerning)savable;
            Map<Integer, Integer> amtHash = this._kernMap.get(k.first);
            if (amtHash == null) {
                amtHash = new HashMap<Integer, Integer>();
                this._kernMap.put(k.first, amtHash);
            }
            amtHash.put(k.second, k.amount);
            this._kernMap.put(k.first, amtHash);
        }
    }

    public Class<?> getClassTag() {
        return this.getClass();
    }

    public class RenderStateSetter {
        public TextureState textureState = new TextureState();
        public BlendState blendState;
        public ZBufferState zBuffState;
        float _blendDisabledTestRef = 0.3f;
        float _blendEnabledTestRef = 0.02f;
        boolean _useBlend;

        RenderStateSetter(Texture texture, boolean useBlend) {
            this.textureState.setTexture(texture);
            this.blendState = new BlendState();
            this.blendState.setSourceFunction(BlendState.SourceFunction.SourceAlpha);
            this.blendState.setDestinationFunction(BlendState.DestinationFunction.OneMinusSourceAlpha);
            this.blendState.setTestEnabled(true);
            this.blendState.setTestFunction(BlendState.TestFunction.GreaterThan);
            this.zBuffState = new ZBufferState();
            this.zBuffState.setFunction(ZBufferState.TestFunction.LessThanOrEqualTo);
            this.setUseBlend(useBlend);
        }

        void applyTo(Spatial spatial) {
            spatial.setRenderState(this.textureState);
            spatial.setRenderState(this.blendState);
            spatial.setRenderState(this.zBuffState);
            if (this._useBlend) {
                spatial.getSceneHints().setRenderBucketType(RenderBucketType.Transparent);
            } else {
                spatial.getSceneHints().setRenderBucketType(RenderBucketType.Opaque);
            }
        }

        void setUseBlend(boolean blend) {
            this._useBlend = blend;
            if (!this._useBlend) {
                this.blendState.setBlendEnabled(false);
                this.blendState.setReference(this._blendDisabledTestRef);
                this.zBuffState.setWritable(true);
            } else {
                this.blendState.setBlendEnabled(true);
                this.blendState.setReference(this._blendEnabledTestRef);
                this.zBuffState.setWritable(false);
            }
        }
    }

    @SavableFactory(factoryMethod="create")
    public static class Kerning
    implements Savable {
        public int first;
        public int second;
        public int amount;

        public Kerning() {
        }

        public Kerning(int first, int second, int amount) {
            this.first = first;
            this.second = second;
            this.amount = amount;
        }

        public static Kerning create() {
            return new Kerning();
        }

        public void write(OutputCapsule capsule) throws IOException {
            capsule.write(this.first, "fist", 0);
            capsule.write(this.second, "second", 0);
            capsule.write(this.amount, "amount", 0);
        }

        public void read(InputCapsule capsule) throws IOException {
            this.first = capsule.readInt("first", 0);
            this.second = capsule.readInt("second", 0);
            this.amount = capsule.readInt("amount", 0);
        }

        public Class<?> getClassTag() {
            return this.getClass();
        }
    }

    @SavableFactory(factoryMethod="create")
    public static class Char
    implements Savable {
        public int id;
        public int x;
        public int y;
        public int width;
        public int height;
        public int xoffset;
        public int yoffset;
        public int xadvance;
        public int page;
        public int chnl;

        public static Char create() {
            return new Char();
        }

        public void write(OutputCapsule capsule) throws IOException {
            capsule.write(this.id, "id", 0);
            capsule.write(this.x, "x", 0);
            capsule.write(this.y, "y", 0);
            capsule.write(this.width, "width", 0);
            capsule.write(this.height, "height", 0);
            capsule.write(this.xoffset, "xoffset", 0);
            capsule.write(this.yoffset, "yoffset", 0);
            capsule.write(this.xadvance, "xadvance", 0);
            capsule.write(this.page, "page", 0);
            capsule.write(this.chnl, "chnl", 0);
        }

        public void read(InputCapsule capsule) throws IOException {
            this.id = capsule.readInt("id", 0);
            this.x = capsule.readInt("x", 0);
            this.y = capsule.readInt("y", 0);
            this.width = capsule.readInt("width", 0);
            this.height = capsule.readInt("height", 0);
            this.xoffset = capsule.readInt("xoffset", 0);
            this.yoffset = capsule.readInt("yoffset", 0);
            this.xadvance = capsule.readInt("xadvance", 0);
            this.page = capsule.readInt("page", 0);
            this.chnl = capsule.readInt("chnl", 0);
        }

        public Class<?> getClassTag() {
            return this.getClass();
        }
    }

    @SavableFactory(factoryMethod="create")
    public static class Page
    implements Savable {
        public int id;
        public String file;

        public static Page create() {
            return new Page();
        }

        public void write(OutputCapsule capsule) throws IOException {
            capsule.write(this.id, "id", 0);
            capsule.write(this.file, "file", null);
        }

        public void read(InputCapsule capsule) throws IOException {
            this.id = capsule.readInt("id", 0);
            this.file = capsule.readString("file", null);
        }

        public Class<?> getClassTag() {
            return this.getClass();
        }
    }

    @SavableFactory(factoryMethod="create")
    public static class Common
    implements Savable {
        public int lineHeight;
        public int base;
        public int scaleW;
        public int scaleH;
        public int pages;
        public boolean packed;
        public int alphaChnl;
        public int redChnl;
        public int greenChnl;
        public int blueChnl;

        public static Common create() {
            return new Common();
        }

        public void write(OutputCapsule capsule) throws IOException {
            capsule.write(this.lineHeight, "lineHeight", 0);
            capsule.write(this.base, "base", 0);
            capsule.write(this.scaleW, "scaleW", 1);
            capsule.write(this.scaleH, "scaleH", 1);
            capsule.write(this.pages, "pages", 0);
            capsule.write(this.packed, "packed", false);
            capsule.write(this.alphaChnl, "alphaChnl", 0);
            capsule.write(this.redChnl, "redChnl", 0);
            capsule.write(this.greenChnl, "greenChnl", 0);
            capsule.write(this.blueChnl, "blueChnl", 0);
        }

        public void read(InputCapsule capsule) throws IOException {
            this.lineHeight = capsule.readInt("lineHeight", 0);
            this.base = capsule.readInt("base", 0);
            this.scaleW = capsule.readInt("scaleW", 0);
            this.scaleH = capsule.readInt("scaleH", 0);
            this.pages = capsule.readInt("pages", 0);
            this.packed = capsule.readBoolean("packed", false);
            this.alphaChnl = capsule.readInt("alphaChnl", 0);
            this.redChnl = capsule.readInt("redChnl", 0);
            this.greenChnl = capsule.readInt("greenChnl", 0);
            this.blueChnl = capsule.readInt("blueChnl", 0);
        }

        public Class<?> getClassTag() {
            return this.getClass();
        }
    }

    @SavableFactory(factoryMethod="create")
    public static class Info
    implements Savable {
        public String face;
        public int size;
        public boolean bold;
        public boolean italic;
        public String charset;
        public boolean unicode;
        public int stretchH;
        public boolean smooth;
        public boolean aa;
        public int[] padding;
        public int[] spacing;
        public int outline;

        public static Info create() {
            return new Info();
        }

        public void write(OutputCapsule capsule) throws IOException {
            capsule.write(this.face, "face", null);
            capsule.write(this.size, "size", 0);
            capsule.write(this.bold, "bold", false);
            capsule.write(this.italic, "italic", false);
            capsule.write(this.charset, "charset", null);
            capsule.write(this.unicode, "unicode", false);
            capsule.write(this.stretchH, "stretchH", 0);
            capsule.write(this.smooth, "smooth", false);
            capsule.write(this.aa, "aa", false);
            capsule.write(this.padding, "padding", null);
            capsule.write(this.spacing, "spacing", null);
            capsule.write(this.outline, "outline", 0);
        }

        public void read(InputCapsule capsule) throws IOException {
            this.face = capsule.readString("face", null);
            this.size = capsule.readInt("size", 0);
            this.bold = capsule.readBoolean("bold", false);
            this.italic = capsule.readBoolean("italic", false);
            this.charset = capsule.readString("charset", null);
            this.unicode = capsule.readBoolean("unicode", false);
            this.stretchH = capsule.readInt("stretchH", 0);
            this.smooth = capsule.readBoolean("smooth", false);
            this.aa = capsule.readBoolean("aa", false);
            this.padding = capsule.readIntArray("padding", null);
            this.spacing = capsule.readIntArray("spacing", null);
            this.outline = capsule.readInt("outline", 0);
        }

        public Class<?> getClassTag() {
            return this.getClass();
        }
    }
}

