/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.ui.text;

import com.ardor3d.annotation.SavableFactory;
import com.ardor3d.math.ColorRGBA;
import com.ardor3d.math.Matrix3;
import com.ardor3d.math.Vector2;
import com.ardor3d.math.Vector3;
import com.ardor3d.math.type.ReadOnlyColorRGBA;
import com.ardor3d.math.type.ReadOnlyMatrix3;
import com.ardor3d.math.type.ReadOnlyVector2;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.renderer.Camera;
import com.ardor3d.renderer.IndexMode;
import com.ardor3d.renderer.Renderer;
import com.ardor3d.scenegraph.Mesh;
import com.ardor3d.scenegraph.hint.CullHint;
import com.ardor3d.scenegraph.hint.LightCombineMode;
import com.ardor3d.scenegraph.hint.TextureCombineMode;
import com.ardor3d.ui.text.BMFont;
import com.ardor3d.util.geom.BufferUtils;
import java.nio.FloatBuffer;

@SavableFactory(factoryMethod="initSavable")
public class BMText
extends Mesh {
    protected BMFont _font;
    protected String _textString;
    private final int _tabSize = 4;
    protected double _fontScale = 1.0;
    protected boolean _autoRotate = true;
    protected int _lines = 1;
    protected final Vector2 _size = new Vector2();
    protected float[] _lineWidths = new float[64];
    protected ColorRGBA _textClr = new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
    protected ColorRGBA _tempClr = new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
    protected AutoScale _autoScale = AutoScale.CapScreenSize;
    protected AutoFade _autoFade = AutoFade.FixedPixelSize;
    protected int _fixedPixelAlphaThresh = 14;
    protected float _screenSizeAlphaFalloff = 0.7f;
    protected final Vector2 _distanceAlphaRange = new Vector2(50.0, 75.0);
    protected boolean _useBlend;
    protected Justify _justify;
    protected int _spacing = 0;
    protected Align _align;
    protected final Vector2 _alignOffset = new Vector2();
    protected final Vector2 _fixedOffset = new Vector2();
    protected final Vector3 _look = new Vector3();
    protected final Vector3 _left = new Vector3();
    protected final Matrix3 _rot = new Matrix3();

    public static BMText initSavable() {
        return new BMText();
    }

    protected BMText() {
    }

    public BMText(String sName, String text, BMFont font) {
        this(sName, text, font, Align.SouthWest);
    }

    public BMText(String sName, String text, BMFont font, Align align) {
        this(sName, text, font, align, Justify.Left);
    }

    public BMText(String sName, String text, BMFont font, Align align, Justify justify) {
        this(sName, text, font, align, justify, true);
    }

    public BMText(String sName, String text, BMFont font, Align align, Justify justify, boolean useBlend) {
        super(sName);
        this._font = font;
        this._align = align;
        this._justify = justify;
        this._spacing = 0;
        this._useBlend = useBlend;
        if (this._font.getOutlineWidth() > 1) {
            this._spacing = this._font.getOutlineWidth() - 1;
        }
        this.setModelBound(null);
        this.getSceneHints().setCullHint(CullHint.Never);
        this.getSceneHints().setAllPickingHints(false);
        this.getSceneHints().setLightCombineMode(LightCombineMode.Off);
        this.getSceneHints().setTextureCombineMode(TextureCombineMode.Replace);
        this.getMeshData().setIndexMode(IndexMode.Triangles);
        this.setText(text);
        this._font.applyRenderStatesTo(this, useBlend);
    }

    public void setTextColor(ReadOnlyColorRGBA clr) {
        this._textClr.set(clr);
        this.setDefaultColor((ReadOnlyColorRGBA)this._textClr);
    }

    public void setTextColor(float r, float g, float b, float a) {
        this._textClr.set(r, g, b, a);
        this.setDefaultColor((ReadOnlyColorRGBA)this._textClr);
    }

    public void setFontScale(double scale) {
        this._fontScale = scale;
        if (this._autoScale == AutoScale.Off) {
            double unit = 1.0 / (double)this._font.getSize();
            double s = unit * this._fontScale;
            this.setScale(s, s, -s);
        }
    }

    public double getFontScale() {
        return this._fontScale;
    }

    public void setAutoScale(AutoScale autoScale) {
        this._autoScale = autoScale;
        this.setFontScale(this._fontScale);
    }

    public AutoScale getAutoScale() {
        return this._autoScale;
    }

    public void setAutoFade(AutoFade autoFade) {
        this._autoFade = autoFade;
    }

    public AutoFade getAutoFade() {
        return this._autoFade;
    }

    public void setAutoFadeFixedPixelSize(int pixelSize) {
        this._fixedPixelAlphaThresh = pixelSize;
    }

    public int getAutoFadeFixedPixelSize() {
        return this._fixedPixelAlphaThresh;
    }

    public void setAutoFadeFalloff(float factor) {
        this._screenSizeAlphaFalloff = factor;
    }

    public void setAutoFadeDistanceRange(double nearOpaque, double farTransparent) {
        this._distanceAlphaRange.set(nearOpaque, farTransparent);
    }

    public void setAutoRotate(boolean doAutoTransform) {
        this._autoRotate = doAutoTransform;
    }

    public boolean getAutoRotate() {
        return this._autoRotate;
    }

    @Override
    public synchronized void draw(Renderer r) {
        if (this._textString.length() > 0) {
            Camera cam = Camera.getCurrentCamera();
            if (this._autoScale != AutoScale.Off || this._autoFade != AutoFade.Off) {
                this.updateScaleAndAlpha(cam, r);
            }
            this.correctTransform(cam);
            super.draw(r);
        }
    }

    public void correctTransform(Camera cam) {
        this.updateWorldTransform(false);
        if (this._autoRotate) {
            this._look.set(cam.getDirection());
            this._left.set(cam.getLeft()).negateLocal();
            this._rot.fromAxes((ReadOnlyVector3)this._left, (ReadOnlyVector3)this._look, cam.getUp());
            this._worldTransform.setRotation((ReadOnlyMatrix3)this._rot);
        }
        this._worldTransform.setScale(this._localTransform.getScale());
    }

    public void updateScaleAndAlpha(Camera cam, Renderer r) {
        this._look.set(cam.getLocation());
        this._look.negateLocal().addLocal(this._worldTransform.getTranslation());
        double zDepth = cam.getDirection().dot((ReadOnlyVector3)this._look);
        if (zDepth > cam.getFrustumFar() || zDepth < cam.getFrustumNear()) {
            return;
        }
        double heightAtZ = cam.getProjectionMode() == Camera.ProjectionMode.Parallel ? cam.getFrustumTop() : zDepth * cam.getFrustumTop() / cam.getFrustumNear();
        double screenHeight = cam.getHeight();
        double pixelRatio = heightAtZ / screenHeight;
        double capSize = 1.0 / (this._fontScale * (double)this._font.getSize());
        double depthScale = 2.0 * pixelRatio;
        if (this._autoScale != AutoScale.Off) {
            double finalScale = depthScale;
            if (this._autoScale == AutoScale.CapScreenSize && finalScale > capSize) {
                finalScale = capSize;
            }
            this.setScale(finalScale *= this._fontScale, finalScale, -finalScale);
        }
        switch (this._autoFade) {
            case Off: {
                break;
            }
            case DistanceRange: {
                this.distanceAlphaFade((ReadOnlyVector2)this._distanceAlphaRange, this._look.length());
                break;
            }
            case FixedPixelSize: {
                this.screenSizeCapAlphaFade(1.0 / (double)this._fixedPixelAlphaThresh, depthScale, this._screenSizeAlphaFalloff);
                break;
            }
            case CapScreenSize: {
                this.screenSizeCapAlphaFade(capSize, depthScale, this._screenSizeAlphaFalloff);
            }
        }
    }

    protected void screenSizeCapAlphaFade(double capSize, double depthScale, float alphaFallof) {
        if (capSize < depthScale) {
            float unit = (float)((depthScale - capSize) / capSize);
            float f = alphaFallof - unit;
            f = f < 0.0f ? 0.0f : f / alphaFallof;
            float alpha = this._textClr.getAlpha() * f;
            this._tempClr.set((ReadOnlyColorRGBA)this._textClr);
            this._tempClr.setAlpha(alpha);
            this.setDefaultColor((ReadOnlyColorRGBA)this._tempClr);
        } else {
            this.setDefaultColor((ReadOnlyColorRGBA)this._textClr);
        }
    }

    protected void distanceAlphaFade(ReadOnlyVector2 range, double distance) {
        float alpha = 1.0f;
        if (distance > range.getY()) {
            alpha = 0.0f;
        } else if (distance > range.getX()) {
            float a = (float)(distance - range.getX());
            float r = (float)(range.getY() - range.getX());
            alpha = 1.0f - a / r;
        }
        this._tempClr.set((ReadOnlyColorRGBA)this._textClr);
        this._tempClr.setAlpha(this._textClr.getAlpha() * alpha);
        this.setDefaultColor((ReadOnlyColorRGBA)this._tempClr);
    }

    public float getWidth() {
        return this._size.getXf() * this._worldTransform.getScale().getXf();
    }

    public float getHeight() {
        return this._size.getYf() * this._worldTransform.getScale().getYf();
    }

    protected void addToLineSizes(float sizeX, int lineIndex) {
        if (lineIndex >= this._lineWidths.length) {
            float[] newLineSizes = new float[this._lineWidths.length * 2];
            System.arraycopy(this._lineWidths, 0, newLineSizes, 0, this._lineWidths.length);
            this._lineWidths = newLineSizes;
        }
        this._lineWidths[lineIndex] = sizeX;
    }

    protected void calculateSize(String text) {
        this._size.set(0.0, 0.0);
        float cursorX = 0.0f;
        float cursorY = 0.0f;
        float lineHeight = this._font.getLineHeight();
        this._lines = 0;
        this._lineWidths[0] = 0.0f;
        int strLen = this._textString.length();
        for (int i = 0; i < strLen; ++i) {
            char charVal = this._textString.charAt(i);
            if (charVal == '\n') {
                this.addToLineSizes(cursorX, this._lines);
                ++this._lines;
                if ((double)cursorX > this._size.getX()) {
                    this._size.setX((double)cursorX);
                }
                cursorX = 0.0f;
                cursorY = (float)this._lines * lineHeight;
                continue;
            }
            if (charVal == '\t') {
                float tabStop = 4 * this._font.getMaxCharAdvance();
                float stops = 1.0f + (float)Math.floor(cursorX / tabStop);
                cursorX = stops * tabStop;
                continue;
            }
            BMFont.Char chr = this._font.getChar(charVal);
            int nextVal = 0;
            if (i < strLen - 1) {
                nextVal = this._textString.charAt(i + 1);
            }
            int kern = this._font.getKerning(charVal, nextVal);
            cursorX += (float)(chr.xadvance + kern + this._spacing);
        }
        this.addToLineSizes(cursorX, this._lines);
        if ((double)cursorX > this._size.getX()) {
            this._size.setX((double)cursorX);
        }
        this._size.setY((double)(cursorY + lineHeight));
        ++this._lines;
    }

    protected void calculateAlignmentOffset() {
        this._alignOffset.set(0.0, 0.0);
        if (this._align != null) {
            this._alignOffset.setX(this._size.getX() * (double)this._align.horizontal);
            this._alignOffset.setY(this._size.getY() * (double)this._align.vertical);
        }
    }

    protected void checkBuffers(String text) {
        int chunkSize = 20;
        int vertices = 6 * text.length();
        int chunks = 1 + vertices / 20;
        int required = chunks * 20;
        FloatBuffer vertexBuffer = this.getMeshData().getVertexBuffer();
        FloatBuffer texCrdBuffer = this.getMeshData().getTextureBuffer(0);
        if (vertexBuffer == null || vertexBuffer.capacity() < required * 3) {
            vertexBuffer = BufferUtils.createVector3Buffer(required);
            texCrdBuffer = BufferUtils.createVector2Buffer(required);
            this.getMeshData().setVertexBuffer(vertexBuffer);
            this.getMeshData().setTextureBuffer(texCrdBuffer, 0);
        }
        vertexBuffer.limit(vertices * 3).rewind();
        texCrdBuffer.limit(vertices * 2).rewind();
    }

    protected float getJustificationXOffset(int lineIndex) {
        float cursorX = 0.0f;
        switch (this._justify) {
            case Left: {
                cursorX = 0.0f;
                break;
            }
            case Center: {
                cursorX = 0.5f * (this._size.getXf() - this._lineWidths[lineIndex]);
                break;
            }
            case Right: {
                cursorX = this._size.getXf() - this._lineWidths[lineIndex];
            }
        }
        return cursorX;
    }

    public BMFont getFont() {
        return this._font;
    }

    public void setFont(BMFont font) {
        this._font = font;
        this._font.applyRenderStatesTo(this, this._useBlend);
        this.setFontScale(this._fontScale);
        this.setText(this._textString);
    }

    public void setUseBlend(boolean useBlend) {
        this._useBlend = useBlend;
        this._font.applyRenderStatesTo(this, this._useBlend);
    }

    public boolean getUseBlend() {
        return this._useBlend;
    }

    public synchronized void setText(String text) {
        this._textString = text == null ? "" : text;
        this.checkBuffers(this._textString);
        this.calculateSize(this._textString);
        this.calculateAlignmentOffset();
        FloatBuffer vertices = this.getMeshData().getVertexBuffer();
        FloatBuffer texCrds = this.getMeshData().getTextureBuffer(0);
        float txW = this._font.getTextureWidth();
        float txH = this._font.getTextureHeight();
        int lineIndex = 0;
        float cursorX = this.getJustificationXOffset(lineIndex);
        float cursorY = 0.0f;
        float lineHeight = this._font.getLineHeight();
        float alignX = this._size.getXf() * this._align.horizontal;
        float alignY = this._size.getYf() * this._align.vertical;
        alignX = Math.round(alignX);
        alignY = Math.round(alignY);
        alignX = (float)((double)alignX + this._fixedOffset.getX());
        alignY = (float)((double)alignY + this._fixedOffset.getY());
        int strLen = this._textString.length();
        for (int i = 0; i < strLen; ++i) {
            char charVal = this._textString.charAt(i);
            if (charVal == '\n') {
                cursorX = this.getJustificationXOffset(++lineIndex);
                cursorY += lineHeight;
                this.addEmptyCharacter(vertices, texCrds);
                continue;
            }
            if (charVal == '\t') {
                float tabStop = 4 * this._font.getMaxCharAdvance();
                float stops = 1.0f + (float)Math.floor(cursorX / tabStop);
                cursorX = stops * tabStop;
                this.addEmptyCharacter(vertices, texCrds);
                continue;
            }
            BMFont.Char chr = this._font.getChar(charVal);
            float l = alignX + cursorX + (float)chr.xoffset;
            float t = alignY + cursorY + (float)chr.yoffset;
            float r = alignX + cursorX + (float)chr.xoffset + (float)chr.width;
            float b = alignY + cursorY + (float)chr.yoffset + (float)chr.height;
            vertices.put(l).put(0.0f).put(t);
            vertices.put(l).put(0.0f).put(b);
            vertices.put(r).put(0.0f).put(t);
            vertices.put(r).put(0.0f).put(t);
            vertices.put(l).put(0.0f).put(b);
            vertices.put(r).put(0.0f).put(b);
            l = (float)chr.x / txW;
            t = (float)chr.y / txH;
            r = (float)(chr.x + chr.width) / txW;
            b = (float)(chr.y + chr.height) / txH;
            texCrds.put(l).put(t);
            texCrds.put(l).put(b);
            texCrds.put(r).put(t);
            texCrds.put(r).put(t);
            texCrds.put(l).put(b);
            texCrds.put(r).put(b);
            int nextVal = 0;
            if (i < strLen - 1) {
                nextVal = this._textString.charAt(i + 1);
            }
            int kern = this._font.getKerning(charVal, nextVal);
            cursorX += (float)(chr.xadvance + kern + this._spacing);
        }
        this._meshData.setVertexBuffer(vertices);
        this._meshData.setTextureBuffer(texCrds, 0);
        this._meshData.setIndices(null);
    }

    private void addEmptyCharacter(FloatBuffer vertices, FloatBuffer uvs) {
        vertices.put(0.0f).put(0.0f).put(0.0f);
        vertices.put(0.0f).put(0.0f).put(0.0f);
        vertices.put(0.0f).put(0.0f).put(0.0f);
        vertices.put(0.0f).put(0.0f).put(0.0f);
        vertices.put(0.0f).put(0.0f).put(0.0f);
        vertices.put(0.0f).put(0.0f).put(0.0f);
        uvs.put(0.0f).put(0.0f);
        uvs.put(0.0f).put(0.0f);
        uvs.put(0.0f).put(0.0f);
        uvs.put(0.0f).put(0.0f);
        uvs.put(0.0f).put(0.0f);
        uvs.put(0.0f).put(0.0f);
    }

    public synchronized String getText() {
        return this._textString;
    }

    public void setAlign(Align align) {
        this._align = align;
        this.setText(this._textString);
    }

    public Align getAlign() {
        return this._align;
    }

    public void setJustify(Justify justify) {
        this._justify = justify;
        this.setText(this._textString);
    }

    public Justify getJustify() {
        return this._justify;
    }

    public void setFixedOffset(double x, double y) {
        this._fixedOffset.set(x *= (double)this._font.getSize(), y *= (double)this._font.getSize());
        this.setText(this._textString);
    }

    public void setFixedOffset(Vector2 offset) {
        double x = offset.getX() * (double)this._font.getSize();
        double y = offset.getY() * (double)this._font.getSize();
        this._fixedOffset.set(x, y);
        this.setText(this._textString);
    }

    public int getLineCount() {
        return this._lines;
    }

    @Override
    public BMText makeCopy(boolean shareGeometricData) {
        BMText text = (BMText)super.makeCopy(shareGeometricData);
        text._font = this._font;
        text._textString = this._textString;
        text._fontScale = this._fontScale;
        text._autoRotate = this._autoRotate;
        text._lines = this._lines;
        text._size.set((ReadOnlyVector2)this._size);
        System.arraycopy(this._lineWidths, 0, text._lineWidths, 0, this._lineWidths.length);
        text._textClr.set((ReadOnlyColorRGBA)this._textClr);
        text._tempClr.set((ReadOnlyColorRGBA)this._tempClr);
        text._autoScale = this._autoScale;
        text._autoFade = this._autoFade;
        text._fixedPixelAlphaThresh = this._fixedPixelAlphaThresh;
        text._screenSizeAlphaFalloff = this._screenSizeAlphaFalloff;
        text._distanceAlphaRange.set((ReadOnlyVector2)this._distanceAlphaRange);
        text._useBlend = this._useBlend;
        text._justify = this._justify;
        text._spacing = this._spacing;
        text._align = this._align;
        text._alignOffset.set((ReadOnlyVector2)this._alignOffset);
        text._fixedOffset.set((ReadOnlyVector2)this._fixedOffset);
        return text;
    }

    public static enum Align {
        North(-0.5f, 0.0f),
        NorthWest(0.0f, 0.0f),
        NorthEast(-1.0f, 0.0f),
        Center(-0.5f, -0.5f),
        West(0.0f, -0.5f),
        East(-1.0f, -0.5f),
        South(-0.5f, -1.0f),
        SouthWest(0.0f, -1.0f),
        SouthEast(-1.0f, -1.0f);

        public final float horizontal;
        public final float vertical;

        private Align(float h, float v) {
            this.horizontal = h;
            this.vertical = v;
        }
    }

    public static enum Justify {
        Left,
        Center,
        Right;

    }

    public static enum AutoFade {
        Off,
        DistanceRange,
        FixedPixelSize,
        CapScreenSize;

    }

    public static enum AutoScale {
        Off,
        FixedScreenSize,
        CapScreenSize;

    }
}

