/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.ui.text;

import com.ardor3d.annotation.SavableFactory;
import com.ardor3d.math.Matrix3;
import com.ardor3d.math.type.ReadOnlyMatrix3;
import com.ardor3d.renderer.queue.RenderBucketType;
import com.ardor3d.renderer.state.BlendState;
import com.ardor3d.renderer.state.CullState;
import com.ardor3d.renderer.state.ZBufferState;
import com.ardor3d.scenegraph.hint.LightCombineMode;
import com.ardor3d.scenegraph.hint.TextureCombineMode;
import com.ardor3d.ui.text.BMFont;
import com.ardor3d.ui.text.BMText;
import com.ardor3d.util.resource.ResourceLocatorTool;
import com.ardor3d.util.resource.URLResourceSource;
import java.util.logging.Logger;

@SavableFactory(factoryMethod="initSavable")
public class BasicText
extends BMText {
    static Logger logger = Logger.getLogger(BasicText.class.getName());
    public static BMFont DEFAULT_FONT;
    public static double DEFAULT_FONT_SIZE;

    public static BasicText initSavable() {
        return new BasicText();
    }

    protected BasicText() {
    }

    public BasicText(String name, String text, BMFont font, double fontSize) {
        super(name, text, font);
        this.getSceneHints().setRenderBucketType(RenderBucketType.Ortho);
        this.setFontScale(fontSize);
        this.setAutoFade(BMText.AutoFade.Off);
        this.setAutoScale(BMText.AutoScale.Off);
        this.setAutoRotate(false);
        this.setRotation((ReadOnlyMatrix3)new Matrix3().fromAngles(-1.5707963267948966, 0.0, 0.0));
        ZBufferState zState = new ZBufferState();
        zState.setEnabled(false);
        zState.setWritable(false);
        this.setRenderState(zState);
        CullState cState = new CullState();
        cState.setEnabled(false);
        this.setRenderState(cState);
        BlendState blend = new BlendState();
        blend.setBlendEnabled(true);
        blend.setSourceFunction(BlendState.SourceFunction.SourceAlpha);
        blend.setDestinationFunction(BlendState.DestinationFunction.OneMinusSourceAlpha);
        blend.setTestEnabled(true);
        blend.setReference(0.0f);
        blend.setTestFunction(BlendState.TestFunction.GreaterThan);
        this.setRenderState(blend);
        this.getSceneHints().setLightCombineMode(LightCombineMode.Off);
        this.getSceneHints().setTextureCombineMode(TextureCombineMode.Replace);
        this.updateModelBound();
    }

    public static BasicText createDefaultTextLabel(String name, String text, double fontSize) {
        return new BasicText(name, text, DEFAULT_FONT, fontSize);
    }

    public static BasicText createDefaultTextLabel(String name, String text) {
        return new BasicText(name, text, DEFAULT_FONT, DEFAULT_FONT_SIZE);
    }

    static {
        DEFAULT_FONT_SIZE = 24.0;
        try {
            DEFAULT_FONT = new BMFont(new URLResourceSource(ResourceLocatorTool.getClassPathResource(BasicText.class, "com/ardor3d/ui/text/arial-24-bold-regular.fnt")), true);
        }
        catch (Exception ex) {
            logger.throwing(BasicText.class.getCanonicalName(), "static font init", ex);
        }
    }
}

