/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.util;

import com.ardor3d.renderer.Renderer;
import com.ardor3d.scenegraph.AbstractBufferData;
import com.ardor3d.util.TextureManager;
import com.ardor3d.util.scenegraph.DisplayListDelegate;

public class ContextGarbageCollector {
    private ContextGarbageCollector() {
    }

    public static void doRuntimeCleanup(Renderer immediateDelete) {
        TextureManager.cleanExpiredTextures(immediateDelete, null);
        AbstractBufferData.cleanExpiredVBOs(immediateDelete);
        DisplayListDelegate.cleanExpiredDisplayLists(immediateDelete);
    }

    public static void doFinalCleanup(Renderer immediateDelete) {
        TextureManager.cleanAllTextures(immediateDelete, null);
        AbstractBufferData.cleanAllVBOs(immediateDelete);
        DisplayListDelegate.cleanAllDisplayLists(immediateDelete);
    }
}

