/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.util;

import com.ardor3d.util.Constants;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class ContextIdReference<T>
extends PhantomReference<T> {
    private static final List<ContextIdReference<?>> REFS = new LinkedList();
    private final Map<Object, Integer> _idCache = Constants.useMultipleContexts ? new WeakHashMap<Object, Integer>(2) : null;
    private Integer _singleContextId;

    public ContextIdReference(T reference, ReferenceQueue<? super T> queue) {
        super(reference, queue);
        REFS.add(this);
    }

    public boolean containsKey(Object glContext) {
        if (Constants.useMultipleContexts) {
            return this._idCache.containsKey(glContext);
        }
        return true;
    }

    public Integer getValue(Object glContext) {
        if (Constants.useMultipleContexts) {
            return this._idCache.get(glContext);
        }
        return this._singleContextId;
    }

    public Integer removeValue(Object glContext) {
        if (Constants.useMultipleContexts) {
            return this._idCache.remove(glContext);
        }
        Integer r = this._singleContextId;
        this._singleContextId = 0;
        return r;
    }

    public void put(Object glContext, Integer id) {
        if (Constants.useMultipleContexts) {
            this._idCache.put(glContext, id);
        } else {
            this._singleContextId = id;
        }
    }

    public Set<Object> getContextObjects() {
        if (Constants.useMultipleContexts) {
            return this._idCache.keySet();
        }
        return null;
    }

    @Override
    public void clear() {
        super.clear();
        this._singleContextId = 0;
        REFS.remove(this);
    }
}

