/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.util;

import com.ardor3d.math.ColorRGBA;
import com.ardor3d.math.type.ReadOnlyColorRGBA;
import com.ardor3d.renderer.Camera;
import com.ardor3d.renderer.Renderer;
import com.ardor3d.scenegraph.Mesh;
import com.ardor3d.util.geom.Debugger;

public class DrawableCamera
extends Mesh {
    private final Camera trackedCamera;
    private final ColorRGBA color;
    private final short pattern;

    public DrawableCamera() {
        this(null, new ColorRGBA(0.0f, 1.0f, 1.0f, 1.0f), -4096);
    }

    public DrawableCamera(Camera camera, ColorRGBA color, short pattern) {
        super("DrawableCamera");
        this.trackedCamera = camera;
        this.color = color;
        this.pattern = pattern;
    }

    @Override
    public void draw(Renderer r) {
        Debugger.drawCameraFrustum(r, this.trackedCamera, (ReadOnlyColorRGBA)this.color, this.pattern, true);
    }
}

