/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.util;

import com.ardor3d.bounding.BoundingBox;
import com.ardor3d.bounding.BoundingSphere;
import com.ardor3d.bounding.BoundingVolume;
import com.ardor3d.math.Vector3;
import com.ardor3d.math.Vector4;
import com.ardor3d.math.type.ReadOnlyMatrix4;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.math.type.ReadOnlyVector4;
import com.ardor3d.renderer.Camera;

public class ExtendedCamera
extends Camera {
    protected final Vector3[] _corners = new Vector3[8];
    protected final Vector3 _extents = new Vector3();

    public ExtendedCamera() {
        this(0, 0);
    }

    public ExtendedCamera(int width, int height) {
        super(width, height);
        this.init();
    }

    public ExtendedCamera(Camera source) {
        super(source);
        this.init();
    }

    private void init() {
        for (int i = 0; i < this._corners.length; ++i) {
            this._corners[i] = new Vector3();
        }
    }

    public void pack(BoundingVolume sceneBounds) {
        ReadOnlyVector3 center = sceneBounds.getCenter();
        for (int i = 0; i < this._corners.length; ++i) {
            this._corners[i].set(center);
        }
        if (sceneBounds instanceof BoundingBox) {
            BoundingBox bbox = (BoundingBox)sceneBounds;
            bbox.getExtent(this._extents);
        } else if (sceneBounds instanceof BoundingSphere) {
            BoundingSphere bsphere = (BoundingSphere)sceneBounds;
            this._extents.set(bsphere.getRadius(), bsphere.getRadius(), bsphere.getRadius());
        }
        this._corners[0].addLocal(this._extents.getX(), this._extents.getY(), this._extents.getZ());
        this._corners[1].addLocal(this._extents.getX(), -this._extents.getY(), this._extents.getZ());
        this._corners[2].addLocal(this._extents.getX(), this._extents.getY(), -this._extents.getZ());
        this._corners[3].addLocal(this._extents.getX(), -this._extents.getY(), -this._extents.getZ());
        this._corners[4].addLocal(-this._extents.getX(), this._extents.getY(), this._extents.getZ());
        this._corners[5].addLocal(-this._extents.getX(), -this._extents.getY(), this._extents.getZ());
        this._corners[6].addLocal(-this._extents.getX(), this._extents.getY(), -this._extents.getZ());
        this._corners[7].addLocal(-this._extents.getX(), -this._extents.getY(), -this._extents.getZ());
        ReadOnlyMatrix4 mvMatrix = this.getModelViewMatrix();
        double optimalCameraNear = Double.MAX_VALUE;
        double optimalCameraFar = -1.7976931348623157E308;
        Vector4 position = Vector4.fetchTempInstance();
        for (int i = 0; i < this._corners.length; ++i) {
            position.set(this._corners[i].getX(), this._corners[i].getY(), this._corners[i].getZ(), 1.0);
            mvMatrix.applyPre((ReadOnlyVector4)position, position);
            optimalCameraNear = Math.min(-position.getZ(), optimalCameraNear);
            optimalCameraFar = Math.max(-position.getZ(), optimalCameraFar);
        }
        Vector4.releaseTempInstance((Vector4)position);
        optimalCameraNear = Math.min(Math.max(this.getFrustumNear(), optimalCameraNear), this.getFrustumFar());
        optimalCameraFar = Math.max(optimalCameraNear, Math.min(this.getFrustumFar(), optimalCameraFar));
        double change = optimalCameraNear / this._frustumNear;
        this.setFrustumLeft(this.getFrustumLeft() * change);
        this.setFrustumRight(this.getFrustumRight() * change);
        this.setFrustumTop(this.getFrustumTop() * change);
        this.setFrustumBottom(this.getFrustumBottom() * change);
        this.setFrustumNear(optimalCameraNear);
        this.setFrustumFar(optimalCameraFar);
    }

    public void calculateFrustum() {
        this.calculateFrustum(this._frustumNear, this._frustumFar);
    }

    public void calculateFrustum(double fNear, double fFar) {
        double fNearPlaneHeight = (this._frustumTop - this._frustumBottom) * fNear * 0.5 / this._frustumNear;
        double fNearPlaneWidth = (this._frustumRight - this._frustumLeft) * fNear * 0.5 / this._frustumNear;
        double fFarPlaneHeight = (this._frustumTop - this._frustumBottom) * fFar * 0.5 / this._frustumNear;
        double fFarPlaneWidth = (this._frustumRight - this._frustumLeft) * fFar * 0.5 / this._frustumNear;
        if (this.getProjectionMode() == Camera.ProjectionMode.Parallel) {
            fNearPlaneHeight = (this._frustumTop - this._frustumBottom) * 0.5;
            fNearPlaneWidth = (this._frustumRight - this._frustumLeft) * 0.5;
            fFarPlaneHeight = (this._frustumTop - this._frustumBottom) * 0.5;
            fFarPlaneWidth = (this._frustumRight - this._frustumLeft) * 0.5;
        }
        Vector3 vNearPlaneCenter = Vector3.fetchTempInstance();
        Vector3 vFarPlaneCenter = Vector3.fetchTempInstance();
        Vector3 direction = Vector3.fetchTempInstance();
        Vector3 left = Vector3.fetchTempInstance();
        Vector3 up = Vector3.fetchTempInstance();
        direction.set(this.getDirection()).multiplyLocal(fNear);
        vNearPlaneCenter.set(this.getLocation()).addLocal((ReadOnlyVector3)direction);
        direction.set(this.getDirection()).multiplyLocal(fFar);
        vFarPlaneCenter.set(this.getLocation()).addLocal((ReadOnlyVector3)direction);
        left.set(this.getLeft()).multiplyLocal(fNearPlaneWidth);
        up.set(this.getUp()).multiplyLocal(fNearPlaneHeight);
        this._corners[0].set((ReadOnlyVector3)vNearPlaneCenter).subtractLocal((ReadOnlyVector3)left).subtractLocal((ReadOnlyVector3)up);
        this._corners[1].set((ReadOnlyVector3)vNearPlaneCenter).subtractLocal((ReadOnlyVector3)left).addLocal((ReadOnlyVector3)up);
        this._corners[2].set((ReadOnlyVector3)vNearPlaneCenter).addLocal((ReadOnlyVector3)left).addLocal((ReadOnlyVector3)up);
        this._corners[3].set((ReadOnlyVector3)vNearPlaneCenter).addLocal((ReadOnlyVector3)left).subtractLocal((ReadOnlyVector3)up);
        left.set(this.getLeft()).multiplyLocal(fFarPlaneWidth);
        up.set(this.getUp()).multiplyLocal(fFarPlaneHeight);
        this._corners[4].set((ReadOnlyVector3)vFarPlaneCenter).subtractLocal((ReadOnlyVector3)left).subtractLocal((ReadOnlyVector3)up);
        this._corners[5].set((ReadOnlyVector3)vFarPlaneCenter).subtractLocal((ReadOnlyVector3)left).addLocal((ReadOnlyVector3)up);
        this._corners[6].set((ReadOnlyVector3)vFarPlaneCenter).addLocal((ReadOnlyVector3)left).addLocal((ReadOnlyVector3)up);
        this._corners[7].set((ReadOnlyVector3)vFarPlaneCenter).addLocal((ReadOnlyVector3)left).subtractLocal((ReadOnlyVector3)up);
        Vector3.releaseTempInstance((Vector3)vNearPlaneCenter);
        Vector3.releaseTempInstance((Vector3)vFarPlaneCenter);
        Vector3.releaseTempInstance((Vector3)direction);
        Vector3.releaseTempInstance((Vector3)left);
        Vector3.releaseTempInstance((Vector3)up);
    }

    public Vector3[] getCorners() {
        return this._corners;
    }
}

